/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workflow;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.ade.publish.shared.CmsPublishResourceInfo;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsUUID;
import org.opencms.workflow.CmsDefaultPublishResourceFormatter;
import org.opencms.workflow.Messages;

public class CmsExtendedPublishResourceFormatter
extends CmsDefaultPublishResourceFormatter {
    private static final Log LOG = CmsLog.getLog(CmsExtendedPublishResourceFormatter.class);
    protected LoadingCache<CmsUUID, Boolean> m_workflowProjectStatus = CacheBuilder.newBuilder().build(CacheLoader.from((Function)new Function<CmsUUID, Boolean>(){

        public Boolean apply(CmsUUID projectId) {
            try {
                CmsProject project = CmsExtendedPublishResourceFormatter.this.m_cms.readProject(projectId);
                return new Boolean(project.isWorkflowProject());
            }
            catch (CmsException e) {
                CmsExtendedPublishResourceFormatter.getLog().warn((Object)e.getLocalizedMessage(), (Throwable)e);
                return Boolean.FALSE;
            }
        }
    }));
    private boolean m_isRelease;

    public CmsExtendedPublishResourceFormatter(CmsObject cms) {
        super(cms);
    }

    public static Log getLog() {
        return LOG;
    }

    public void setRelease(boolean release) {
        this.m_isRelease = release;
    }

    protected String getMessage(String key, String ... args) {
        return Messages.get().getBundle(this.m_cms.getRequestContext().getLocale()).key(key, args);
    }

    @Override
    protected Predicate<CmsResource> getResourceMapFilter() {
        if (this.m_isRelease) {
            return null;
        }
        return super.getResourceMapFilter();
    }

    @Override
    protected List<CmsDefaultPublishResourceFormatter.I_PublishResourceValidator> getValidators() {
        if (this.m_isRelease) {
            return Arrays.asList(new CmsDefaultPublishResourceFormatter.AlreadyPublishedValidator(), new CmsDefaultPublishResourceFormatter.BlockingLockedValidator(), new ExcludeAlreadyInWorkflow());
        }
        return Arrays.asList(new CmsDefaultPublishResourceFormatter.AlreadyPublishedValidator(), new CmsDefaultPublishResourceFormatter.NoPermissionsValidator(), new CmsDefaultPublishResourceFormatter.BlockingLockedValidator(), new ExcludeAlreadyInWorkflow());
    }

    protected boolean isWorkflowProject(CmsUUID projectId) {
        try {
            return (Boolean)this.m_workflowProjectStatus.get((Object)projectId);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    class ExcludeAlreadyInWorkflow
    implements CmsDefaultPublishResourceFormatter.I_PublishResourceValidator {
        ExcludeAlreadyInWorkflow() {
        }

        @Override
        public Set<CmsResource> findInvalidResources(Set<CmsResource> input) {
            HashSet result = Sets.newHashSet();
            CmsUUID optionsProject = CmsExtendedPublishResourceFormatter.this.m_options.getProjectId();
            for (CmsResource resource : input) {
                CmsUUID projectId = resource.getProjectLastModified();
                if (!CmsExtendedPublishResourceFormatter.this.isWorkflowProject(projectId) || optionsProject != null && projectId.equals(optionsProject)) continue;
                result.add(resource);
            }
            return result;
        }

        @Override
        public CmsPublishResourceInfo getInfoForResource(CmsResource resource) {
            return new CmsPublishResourceInfo(CmsExtendedPublishResourceFormatter.this.getMessage("GUI_ALREADY_IN_WORKFLOW_0", new String[0]), CmsPublishResourceInfo.Type.WORKFLOW);
        }
    }
}

