/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.cache.CmsVfsMemoryObjectCache;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsUser;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.Messages;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public class CmsLoginUserAgreement
extends CmsDialog {
    public static final int ACTION_ACCEPT = 100;
    public static final String DIALOG_TYPE = "useragreement";
    public static final String NODE_MESSAGE_DECLINED = "MessageDeclined";
    public static final String NODE_TEXT = "Text";
    public static final String PARAM_WPRES = "wpres";
    protected static final String KEY_ACCEPTED_COUNT = "count";
    protected static final String KEY_ACCEPTED_VERSION = "version";
    protected static final String NODE_AGREE_COUNT = "AgreeCount";
    protected static final String NODE_BUTTON_ACCEPT = "ButtonAccept";
    protected static final String NODE_BUTTON_DECLINE = "ButtonDecline";
    protected static final String NODE_DIALOG_TITLE = "DialogTitle";
    protected static final String NODE_VERSION = "Version";
    protected static final String VFS_PATH_CONFIGFOLDER = "/system/login/useragreement/";
    private static final Log LOG = CmsLog.getLog(CmsLoginUserAgreement.class);
    private int m_acceptedCount;
    private double m_acceptedVersion;
    private CmsXmlContent m_configurationContent;
    private String m_paramWpres;
    private double m_requiredVersion;

    public CmsLoginUserAgreement(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsLoginUserAgreement(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void acceptAgreement() {
        this.getSettings().setUserAgreementAccepted(true);
        if (this.getAcceptedVersion() < this.getRequiredVersion()) {
            this.setAcceptedVersion(this.getRequiredVersion());
            this.setAcceptedCount(0);
        }
        this.setAcceptedCount(this.getAcceptedCount() + 1);
        JSONObject jsonData = new JSONObject();
        try {
            jsonData.put(KEY_ACCEPTED_VERSION, this.getRequiredVersion());
            jsonData.put(KEY_ACCEPTED_COUNT, this.m_acceptedCount);
            CmsUser user = this.getCms().getRequestContext().getCurrentUser();
            user.setAdditionalInfo("LOGIN_UA_ACCEPTED", jsonData.toString());
            this.getCms().writeUser(user);
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    public void actionAccept() throws IOException {
        this.acceptAgreement();
        this.getJsp().getResponse().sendRedirect(this.getJsp().link(this.getParamWpres()));
    }

    public void actionDecline() throws IOException {
        this.getJsp().getRequest().getSession().invalidate();
        this.getJsp().getResponse().sendRedirect(this.getJsp().link(this.getParamWpres()));
    }

    @Override
    public String dialogScriptSubmit() {
        if (this.useNewStyle()) {
            return super.dialogScriptSubmit();
        }
        StringBuffer result = new StringBuffer(512);
        result.append("function submitAction(actionValue, theForm, formName) {\n");
        result.append("\tif (theForm == null) {\n");
        result.append("\t\ttheForm = document.forms[formName];\n");
        result.append("\t}\n");
        result.append("\ttheForm.framename.value = window.name;\n");
        result.append("\tif (actionValue == \"ok\") {\n");
        result.append("\t\treturn true;\n");
        result.append("\t}");
        String declinedMessage = this.getConfigurationContentStringValue(NODE_MESSAGE_DECLINED);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(declinedMessage)) {
            result.append(" else if (actionValue == \"cancel\") {\n");
            result.append("\t\talert(\"");
            result.append(CmsStringUtil.escapeJavaScript(declinedMessage));
            result.append("\");\n");
            result.append("\t}\n");
        }
        result.append("\ttheForm.action.value = actionValue;\n");
        result.append("\ttheForm.submit();\n");
        result.append("\treturn false;\n");
        result.append("}\n");
        return result.toString();
    }

    public int getAcceptedCount() {
        return this.m_acceptedCount;
    }

    public double getAcceptedVersion() {
        return this.m_acceptedVersion;
    }

    public String getConfigurationContentStringValue(String path) {
        if (this.getConfigurationContent() != null) {
            return this.getConfigurationContent().getStringValue(this.getCms(), path, this.getLocale());
        }
        return "";
    }

    public String getConfigurationVfsPath() {
        return VFS_PATH_CONFIGFOLDER + this.getLocale().toString() + "/configuration.html";
    }

    public String getParamWpres() {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_paramWpres) || "null".equals(this.m_paramWpres)) {
            return "/system/workplace/views/workplace.jsp";
        }
        return this.m_paramWpres;
    }

    public double getRequiredVersion() {
        if (this.m_requiredVersion == 0.0) {
            String versionStr = this.getConfigurationContentStringValue(NODE_VERSION);
            try {
                this.m_requiredVersion = Double.parseDouble(versionStr);
            }
            catch (Exception e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_USERAGREEMENT_WRONG_VERSION_2", versionStr, this.getConfigurationContent().getFile().getRootPath()));
            }
        }
        return this.m_requiredVersion;
    }

    public boolean isShowUserAgreement() {
        if (!this.getSettings().isUserAgreementAccepted() && this.getConfigurationContent() != null) {
            CmsXmlContent content = this.getConfigurationContent();
            boolean enabled = false;
            try {
                enabled = Boolean.valueOf(this.getCms().readPropertyObject(content.getFile(), "login-form", false).getValue());
                if (enabled && content.hasLocale(this.getLocale())) {
                    if (this.getAcceptedVersion() < this.getRequiredVersion()) {
                        return true;
                    }
                    String countStr = content.getStringValue(this.getCms(), NODE_AGREE_COUNT, this.getLocale());
                    int count = Integer.parseInt(countStr);
                    if (count == -1 || this.getAcceptedCount() < count) {
                        return true;
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_USERAGREEMENT_SHOW_1", this.getConfigurationContent().getFile().getRootPath()), (Throwable)e);
            }
        }
        if (!this.getSettings().isUserAgreementAccepted()) {
            this.getSettings().setUserAgreementAccepted(true);
        }
        return false;
    }

    public void setAcceptedCount(int acceptedCount) {
        this.m_acceptedCount = acceptedCount;
    }

    public void setAcceptedVersion(double acceptedVersion) {
        this.m_acceptedVersion = acceptedVersion;
    }

    public void setParamWpres(String paramWpres) {
        this.m_paramWpres = paramWpres;
    }

    public void setRequiredVersion(double requiredVersion) {
        this.m_requiredVersion = requiredVersion;
    }

    @Override
    protected void dialogButtonsHtml(StringBuffer result, int button, String attribute) {
        attribute = this.appendDelimiter(attribute);
        switch (button) {
            case 0: {
                result.append("<input name=\"ok\" value=\"");
                result.append(this.getConfigurationContentStringValue(NODE_BUTTON_ACCEPT));
                result.append("\"");
                if (attribute.toLowerCase().indexOf("onclick") == -1) {
                    result.append(" type=\"submit\"");
                } else {
                    result.append(" type=\"button\"");
                }
                result.append(" class=\"dialogbutton\"");
                result.append(attribute);
                result.append(">\n");
                break;
            }
            case 1: {
                result.append("<input name=\"cancel\" type=\"button\" value=\"");
                result.append(this.getConfigurationContentStringValue(NODE_BUTTON_DECLINE));
                result.append("\"");
                if (attribute.toLowerCase().indexOf("onclick") == -1) {
                    result.append(" onclick=\"submitAction('cancel', form);\"");
                }
                result.append(" class=\"dialogbutton\"");
                result.append(attribute);
                result.append(">\n");
                break;
            }
            default: {
                super.dialogButtonsHtml(result, button, attribute);
            }
        }
    }

    protected CmsXmlContent getConfigurationContent() {
        if (this.m_configurationContent == null) {
            String configFileName = this.getConfigurationVfsPath();
            if (this.getCms().existsResource(configFileName)) {
                CmsVfsMemoryObjectCache vfsCache = CmsVfsMemoryObjectCache.getVfsMemoryObjectCache();
                this.m_configurationContent = (CmsXmlContent)vfsCache.getCachedObject(this.getCms(), configFileName);
                if (this.m_configurationContent == null) {
                    try {
                        CmsFile configFile = this.getCms().readFile(configFileName);
                        CmsXmlContent content = CmsXmlContentFactory.unmarshal(this.getCms(), configFile);
                        vfsCache.putCachedObject(this.getCms(), configFileName, content);
                        this.m_configurationContent = content;
                    }
                    catch (CmsException cmsException) {
                        // empty catch block
                    }
                }
            }
        }
        return this.m_configurationContent;
    }

    protected void initAcceptData() {
        CmsUser user = this.getCms().getRequestContext().getCurrentUser();
        String result = (String)user.getAdditionalInfo("LOGIN_UA_ACCEPTED");
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(result)) {
            try {
                JSONObject jsonData = new JSONObject(result);
                this.m_acceptedVersion = jsonData.getDouble(KEY_ACCEPTED_VERSION);
                this.m_acceptedCount = jsonData.getInt(KEY_ACCEPTED_COUNT);
            }
            catch (JSONException e) {
                LOG.error((Object)e);
            }
        }
    }

    @Override
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        this.initAcceptData();
        this.setParamDialogtype(DIALOG_TYPE);
        if (DIALOG_TYPE.equals(this.getParamAction())) {
            this.setAction(100);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else {
            this.setAction(0);
            this.setParamTitle(this.getConfigurationContentStringValue(NODE_DIALOG_TITLE));
        }
    }
}

