/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.comparison;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.workplace.comparison.Messages;

public final class CmsDiffViewMode
implements Serializable {
    public static final CmsDiffViewMode ALL = new CmsDiffViewMode("all", Messages.get().container("GUI_DIFF_MODE_DIFFONLY_NAME_0"));
    public static final CmsDiffViewMode DIFF_ONLY = new CmsDiffViewMode("diff_only", Messages.get().container("GUI_DIFF_MODE_ALL_NAME_0"));
    private static final long serialVersionUID = -9107946096096683776L;
    private static final CmsDiffViewMode[] VALUE_ARRAY = new CmsDiffViewMode[]{ALL, DIFF_ONLY};
    public static final List<CmsDiffViewMode> VALUES = Collections.unmodifiableList(Arrays.asList(VALUE_ARRAY));
    private final String m_mode;
    private final CmsMessageContainer m_name;

    private CmsDiffViewMode(String mode, CmsMessageContainer name) {
        this.m_mode = mode;
        this.m_name = name;
    }

    public static CmsDiffViewMode valueOf(String value) throws CmsIllegalArgumentException {
        if (value == null) {
            return null;
        }
        for (CmsDiffViewMode target : VALUES) {
            if (!value.equals(target.getMode())) continue;
            return target;
        }
        throw new CmsIllegalArgumentException(org.opencms.db.Messages.get().container("ERR_MODE_ENUM_PARSE_2", value, CmsDiffViewMode.class.getName()));
    }

    public String getMode() {
        return this.m_mode;
    }

    public CmsMessageContainer getName() {
        return this.m_name;
    }

    public String toString() {
        return this.m_mode;
    }
}

