/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors;

import org.opencms.util.CmsStringUtil;

public class CmsDialogElement
implements Comparable<CmsDialogElement> {
    private boolean m_existing;
    private boolean m_mandantory;
    private String m_name;
    private String m_niceName;
    private boolean m_templateElement;

    public CmsDialogElement(String name, String niceName, boolean mandantory, boolean templateElement, boolean existing) {
        this.m_name = name;
        this.m_niceName = niceName;
        this.m_mandantory = mandantory;
        this.m_templateElement = templateElement;
        this.m_existing = existing;
    }

    @Override
    public int compareTo(CmsDialogElement obj) {
        if (obj == this) {
            return 0;
        }
        CmsDialogElement element = obj;
        if (this.m_name == null) {
            return element.m_name == null ? 0 : -1;
        }
        return this.m_name.compareToIgnoreCase(element.m_name);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CmsDialogElement)) {
            return false;
        }
        CmsDialogElement other = (CmsDialogElement)obj;
        if (this.m_name == null) {
            return other.m_name == null;
        }
        if (other.m_name == null) {
            return false;
        }
        String name1 = this.m_name;
        String name2 = other.m_name;
        if (name1.endsWith("[0]")) {
            name1 = name1.substring(0, name1.length() - 3);
        }
        if (name2.endsWith("[0]")) {
            name2 = name2.substring(0, name2.length() - 3);
        }
        return name1.equals(name2);
    }

    public String getName() {
        return this.m_name;
    }

    public String getNiceName() {
        if (CmsStringUtil.isEmpty(this.m_niceName)) {
            if (this.isExisting() && !this.isTemplateElement()) {
                return "* " + this.getName();
            }
            return this.getName();
        }
        return this.m_niceName;
    }

    public int hashCode() {
        if (this.m_name == null) {
            return 0;
        }
        return this.m_name.hashCode();
    }

    public boolean isExisting() {
        return this.m_existing;
    }

    public boolean isMandantory() {
        return this.m_mandantory;
    }

    public boolean isTemplateElement() {
        return this.m_templateElement;
    }

    public void setExisting(boolean existing) {
        this.m_existing = existing;
    }
}

