/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.opencms.util.CmsStringUtil;

public final class CmsTinyMceToolbarHelper {
    public static final String BUTTON_TRANSLATION = "|newdocument:newdocument|bold:bold|italic:italic|underline:underline|strikethrough:strikethrough|alignleft:alignleft|aligncenter:aligncenter|alignright:alignright|justify:alignjustify|style:styleselect|formatselect:formatselect|fontselect:fontselect|fontsizeselect:fontsizeselect|cut:cut|copy:copy|paste:paste|pastetext:pastetext|find:searchreplace|replace:searchreplace|unorderedlist:bullist|orderedlist:numlist|outdent:outdent|indent:indent|blockquote:blockquote|undo:undo|redo:redo|editorlink:link|unlink:unlink|anchor:anchor|image:image|cleanup:cleanup|source:code|insertdate:insertdate|inserttime:inserttime|forecolor:forecolor|backcolor:backcolor|table:table|hr:hr|removeformat:removeformat|visualaid:visualaid|subscript:subscript|superscript:superscript|specialchar:charmap|emotions:emoticons|spellcheck:spellchecker|media:media|print:print|ltr:ltr|rtl:rtl|fitwindow:fullscreen|insertlayer:insertlayer|moveforward:moveforward|movebackward:movebackward|absolute:absolute|styleprops:styleprops|cite:cite|abbr:abbr|acronym:acronym|del:del|ins:ins|attribs:attribs|visualchars:visualchars|nonbreaking:nonbreaking|template:template|pagebreak:pagebreak|selectall:selectall|fullpage:fullpage|imagegallery:OcmsImageGallery|downloadgallery:OcmsDownloadGallery|linkgallery:OcmsLinkGallery|htmlgallery:OcmsHtmlGallery|tablegallery:OcmsTableGallery|link:link";
    public static final Map<String, String> BUTTON_TRANSLATION_MAP = CmsStringUtil.splitAsMap("|newdocument:newdocument|bold:bold|italic:italic|underline:underline|strikethrough:strikethrough|alignleft:alignleft|aligncenter:aligncenter|alignright:alignright|justify:alignjustify|style:styleselect|formatselect:formatselect|fontselect:fontselect|fontsizeselect:fontsizeselect|cut:cut|copy:copy|paste:paste|pastetext:pastetext|find:searchreplace|replace:searchreplace|unorderedlist:bullist|orderedlist:numlist|outdent:outdent|indent:indent|blockquote:blockquote|undo:undo|redo:redo|editorlink:link|unlink:unlink|anchor:anchor|image:image|cleanup:cleanup|source:code|insertdate:insertdate|inserttime:inserttime|forecolor:forecolor|backcolor:backcolor|table:table|hr:hr|removeformat:removeformat|visualaid:visualaid|subscript:subscript|superscript:superscript|specialchar:charmap|emotions:emoticons|spellcheck:spellchecker|media:media|print:print|ltr:ltr|rtl:rtl|fitwindow:fullscreen|insertlayer:insertlayer|moveforward:moveforward|movebackward:movebackward|absolute:absolute|styleprops:styleprops|cite:cite|abbr:abbr|acronym:acronym|del:del|ins:ins|attribs:attribs|visualchars:visualchars|nonbreaking:nonbreaking|template:template|pagebreak:pagebreak|selectall:selectall|fullpage:fullpage|imagegallery:OcmsImageGallery|downloadgallery:OcmsDownloadGallery|linkgallery:OcmsLinkGallery|htmlgallery:OcmsHtmlGallery|tablegallery:OcmsTableGallery|link:link", "|", ":");

    private CmsTinyMceToolbarHelper() {
    }

    /*
     * WARNING - void declaration
     */
    public static String createTinyMceToolbarStringFromGenericToolbarItems(List<String> barItems) {
        void var5_12;
        ArrayList blocks = new ArrayList();
        blocks.add(new ArrayList());
        Object lastItem = null;
        ArrayList<Object> processedItems = new ArrayList<Object>();
        for (String string : barItems) {
            void var5_5;
            void var5_8;
            String string2 = CmsTinyMceToolbarHelper.translateButton(string);
            if (string2 != null) {
                String string3 = string2;
            }
            if (var5_8.equals("[") || var5_8.equals("]") || var5_8.equals("-")) {
                String string4 = "|";
                if ("|".equals(lastItem)) continue;
            }
            if (var5_5.indexOf(",") > -1) {
                for (String subItem : var5_5.split(",")) {
                    processedItems.add(subItem);
                }
            } else {
                processedItems.add(var5_5);
            }
            lastItem = var5_5;
        }
        if (processedItems.size() > 0 && ((String)processedItems.get(0)).equals("|")) {
            processedItems.remove(0);
        }
        if (processedItems.size() > 0 && ((String)processedItems.get(processedItems.size() - 1)).equals("|")) {
            processedItems.remove(processedItems.size() - 1);
        }
        HashSet<String> writtenItems = new HashSet<String>();
        for (String string : processedItems) {
            if (!writtenItems.contains(string)) {
                ((List)blocks.get(blocks.size() - 1)).add(string);
            }
            if ("|".equals(string)) {
                blocks.add(new ArrayList());
                continue;
            }
            writtenItems.add(string);
        }
        String string = "";
        for (List list : blocks) {
            String string5 = (String)var5_12 + CmsStringUtil.listAsString(list, " ") + " ";
        }
        return var5_12;
    }

    public static String getContextMenuEntries(List<String> barItems) {
        String result = "";
        if (barItems.contains("link")) {
            result = result + CmsTinyMceToolbarHelper.translateButton("link");
        }
        if (barItems.contains("downloadgallery")) {
            result = result + " " + CmsTinyMceToolbarHelper.translateButton("downloadgallery");
        }
        if (barItems.contains("imagegallery")) {
            result = result + " " + CmsTinyMceToolbarHelper.translateButton("imagegallery");
        }
        if (barItems.contains("table")) {
            result = result + " inserttable | cell row column deletetable";
        }
        return result.trim();
    }

    public static String translateButton(String cmsButtonName) {
        return BUTTON_TRANSLATION_MAP.get(cmsButtonName);
    }
}

