/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors.directedit;

import org.opencms.util.CmsStringUtil;

public final class CmsDirectEditMode {
    public static final CmsDirectEditMode AUTO = new CmsDirectEditMode(2);
    public static final CmsDirectEditMode FALSE = new CmsDirectEditMode(0);
    public static final CmsDirectEditMode MANUAL = new CmsDirectEditMode(3);
    public static final CmsDirectEditMode TRUE = new CmsDirectEditMode(1);
    private static final CmsDirectEditMode[] MODES = new CmsDirectEditMode[]{FALSE, TRUE, AUTO, MANUAL};
    private static final String VALUE_AUTO = "auto";
    private static final String VALUE_FALSE = CmsStringUtil.FALSE;
    private static final String VALUE_MANUAL = "manual";
    private static final String VALUE_TRUE = CmsStringUtil.TRUE;
    private int m_mode;

    private CmsDirectEditMode(int mode) {
        this.m_mode = mode;
    }

    public static CmsDirectEditMode valueOf(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static CmsDirectEditMode valueOf(int mode) {
        if (mode > 0 && mode < MODES.length) {
            return MODES[mode];
        }
        return FALSE;
    }

    public static CmsDirectEditMode valueOf(String value) {
        CmsDirectEditMode result = FALSE;
        if (CmsStringUtil.isNotEmpty(value)) {
            if (Boolean.valueOf(value = value.trim().toLowerCase()).booleanValue()) {
                result = TRUE;
            } else if (VALUE_AUTO.equals(value)) {
                result = AUTO;
            } else if (VALUE_MANUAL.equals(value)) {
                result = MANUAL;
            }
        }
        return result;
    }

    public int getMode() {
        return this.m_mode;
    }

    public boolean isEnabled() {
        return this.m_mode > 0;
    }

    public String toString() {
        switch (this.m_mode) {
            case 1: {
                return VALUE_TRUE;
            }
            case 2: {
                return VALUE_AUTO;
            }
            case 3: {
                return VALUE_MANUAL;
            }
        }
        return VALUE_FALSE;
    }
}

