/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.explorer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opencms.util.CmsStringUtil;

public class CmsExplorerContextMenuItem {
    public static final String TYPE_ENTRY = "entry";
    public static final String TYPE_SEPARATOR = "sep";
    private String m_icon;
    private String m_key;
    private String m_name;
    private String m_params;
    private CmsExplorerContextMenuItem m_parent;
    private String m_rule;
    private String m_rules;
    private List<CmsExplorerContextMenuItem> m_subItems;
    private String m_target;
    private String m_type;
    private String m_uri;

    public void addContextMenuEntry(CmsExplorerContextMenuItem item) {
        this.addSubItem(item, TYPE_ENTRY);
    }

    public void addContextMenuSeparator(CmsExplorerContextMenuItem item) {
        this.addSubItem(item, TYPE_SEPARATOR);
    }

    public String getIcon() {
        return this.m_icon;
    }

    public String getKey() {
        return this.m_key;
    }

    public String getName() {
        return this.m_name;
    }

    public String getParams() {
        return this.m_params;
    }

    public Map<String, String> getParamsMap() {
        if (this.m_params == null) {
            return Collections.emptyMap();
        }
        return CmsStringUtil.splitAsMap(this.m_params, "|", "=");
    }

    public CmsExplorerContextMenuItem getParent() {
        return this.m_parent;
    }

    public String getRule() {
        return this.m_rule;
    }

    public String getRules() {
        return this.m_rules;
    }

    public List<CmsExplorerContextMenuItem> getSubItems() {
        return this.m_subItems;
    }

    public String getTarget() {
        return this.m_target;
    }

    public String getType() {
        return this.m_type;
    }

    public String getUri() {
        return this.m_uri;
    }

    public boolean isParentItem() {
        return this.m_subItems != null;
    }

    public boolean isSubItem() {
        return this.m_parent != null;
    }

    public void setIcon(String iconPath) {
        this.m_icon = iconPath;
    }

    public void setKey(String key) {
        this.m_key = key;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setParams(String params) {
        this.m_params = params;
    }

    public void setRule(String rule) {
        this.m_rule = rule;
    }

    public void setRules(String rules) {
        this.m_rules = rules;
    }

    public void setTarget(String target) {
        this.m_target = target;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public void setUri(String uri) {
        this.m_uri = uri;
    }

    protected void addSubItem(CmsExplorerContextMenuItem item, String type) {
        if (this.m_subItems == null) {
            this.m_subItems = new ArrayList<CmsExplorerContextMenuItem>();
        }
        item.setType(type);
        this.m_subItems.add(item);
        item.setParent(this);
    }

    protected void setParent(CmsExplorerContextMenuItem parent) {
        this.m_parent = parent;
    }
}

