/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.explorer.menu;

import org.opencms.util.A_CmsModeIntEnumeration;

public final class CmsMenuItemVisibilityMode
extends A_CmsModeIntEnumeration {
    public static final CmsMenuItemVisibilityMode VISIBILITY_ACTIVE = new CmsMenuItemVisibilityMode(1);
    public static final CmsMenuItemVisibilityMode VISIBILITY_INACTIVE = new CmsMenuItemVisibilityMode(2);
    public static final CmsMenuItemVisibilityMode VISIBILITY_INVISIBLE = new CmsMenuItemVisibilityMode(3);
    private static final long serialVersionUID = 2526260041565757791L;
    private String m_messageKey;
    private boolean m_prioritized;

    private CmsMenuItemVisibilityMode(int mode) {
        super(mode);
    }

    public static CmsMenuItemVisibilityMode valueOf(int type) {
        switch (type) {
            case 1: {
                return VISIBILITY_ACTIVE;
            }
            case 2: {
                return VISIBILITY_INACTIVE;
            }
            case 3: {
                return VISIBILITY_INVISIBLE;
            }
        }
        return VISIBILITY_INVISIBLE;
    }

    public CmsMenuItemVisibilityMode addMessageKey(String messageKey) {
        CmsMenuItemVisibilityMode mode = this.clone();
        mode.m_messageKey = messageKey;
        return mode;
    }

    public String getMessageKey() {
        return this.m_messageKey;
    }

    public boolean isActive() {
        return this.getMode() == VISIBILITY_ACTIVE.getMode();
    }

    public boolean isInActive() {
        return this.getMode() == VISIBILITY_INACTIVE.getMode();
    }

    public boolean isInVisible() {
        return this.getMode() == VISIBILITY_INVISIBLE.getMode();
    }

    public boolean isPrioritized() {
        return this.m_prioritized;
    }

    public CmsMenuItemVisibilityMode prioritize(boolean prioritized) {
        if (this.m_prioritized != prioritized) {
            CmsMenuItemVisibilityMode result = this.clone();
            result.m_prioritized = prioritized;
            return result;
        }
        return this;
    }

    protected CmsMenuItemVisibilityMode clone() {
        return new CmsMenuItemVisibilityMode(this.getMode());
    }
}

