/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.content;

import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsLog;
import org.opencms.xml.content.CmsXmlContentErrorHandler;
import org.opencms.xml.content.I_CmsXmlContentValueVisitor;
import org.opencms.xml.content.Messages;
import org.opencms.xml.types.I_CmsXmlContentValue;

class CmsXmlContentValidationVisitor
implements I_CmsXmlContentValueVisitor {
    private static final Log LOG = CmsLog.getLog(CmsXmlContentValidationVisitor.class);
    CmsObject m_cms;
    CmsXmlContentErrorHandler m_errorHandler = new CmsXmlContentErrorHandler();

    public CmsXmlContentValidationVisitor(CmsObject cms) {
        this.m_cms = cms;
    }

    public CmsXmlContentErrorHandler getErrorHandler() {
        return this.m_errorHandler;
    }

    @Override
    public void visit(I_CmsXmlContentValue value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_XMLCONTENT_VISIT_1", value.getPath()));
        }
        this.m_errorHandler = value.getContentDefinition().getContentHandler().resolveValidation(this.m_cms, value, this.m_errorHandler);
    }
}

