/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.types;

import java.util.Locale;
import org.dom4j.Element;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.types.A_CmsXmlValueTextBase;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsXmlDisplayFormatterValue
extends A_CmsXmlValueTextBase {
    public static final String SEPARATOR = ":";
    private static final String TYPE_NAME = "OpenCmsDisplayFormatter";

    public CmsXmlDisplayFormatterValue() {
    }

    public CmsXmlDisplayFormatterValue(I_CmsXmlDocument document, Element element, Locale locale, I_CmsXmlSchemaType type) {
        super(document, element, locale, type);
    }

    public CmsXmlDisplayFormatterValue(String name, String minOccurs, String maxOccurs) {
        super(name, minOccurs, maxOccurs);
    }

    @Override
    public I_CmsXmlContentValue createValue(I_CmsXmlDocument document, Element element, Locale locale) {
        return new CmsXmlDisplayFormatterValue(document, element, locale, this);
    }

    public String getDisplayType() {
        String value = this.getStringValue(null);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(value)) {
            return value.split(SEPARATOR)[0];
        }
        return null;
    }

    public CmsUUID getFormatterId() {
        String[] parts;
        String value = this.getStringValue(null);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(value) && (parts = value.split(SEPARATOR)).length == 2) {
            return new CmsUUID(parts[1]);
        }
        return null;
    }

    @Override
    public String getSchemaDefinition() {
        return "<xsd:simpleType name=\"OpenCmsDisplayFormatter\"><xsd:restriction base=\"xsd:string\" /></xsd:simpleType>";
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public I_CmsXmlSchemaType newInstance(String name, String minOccurs, String maxOccurs) {
        return new CmsXmlDisplayFormatterValue(name, minOccurs, maxOccurs);
    }
}

