/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.types;

import java.util.Locale;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsLink;
import org.opencms.relations.CmsLinkUpdateUtil;
import org.opencms.relations.CmsRelationType;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.types.A_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsXmlVarLinkValue
extends A_CmsXmlContentValue {
    public static final String NO_LINK = "none";
    public static final String TYPE_NAME = "OpenCmsVarLink";
    public static final String TYPE_VAR_LINK = "varLink";
    private static String m_schemaDefinition;
    private CmsLink m_linkValue;
    private String m_stringValue;

    public CmsXmlVarLinkValue() {
    }

    public CmsXmlVarLinkValue(I_CmsXmlDocument document, Element element, Locale locale, I_CmsXmlSchemaType type) {
        super(document, element, locale, type);
    }

    public CmsXmlVarLinkValue(String name, String minOccurs, String maxOccurs) {
        super(name, minOccurs, maxOccurs);
    }

    @Override
    public I_CmsXmlContentValue createValue(I_CmsXmlDocument document, Element element, Locale locale) {
        return new CmsXmlVarLinkValue(document, element, locale, this);
    }

    @Override
    public Element generateXml(CmsObject cms, I_CmsXmlDocument document, Element root, Locale locale) {
        Element element = root.addElement(this.getName());
        String defaultValue = document.getHandler().getDefault(cms, this, locale);
        if (defaultValue != null) {
            I_CmsXmlContentValue value = this.createValue(document, element, locale);
            value.setStringValue(cms, defaultValue);
        }
        return element;
    }

    public CmsLink getLink(CmsObject cms) {
        if (this.m_linkValue == null) {
            Element linkElement = this.m_element.element("link");
            if (linkElement == null) {
                this.setStringValue(cms, this.m_element.getText());
            } else {
                CmsLinkUpdateUtil.updateType(linkElement, this.getRelationType(this.getPath()));
                CmsLink link = new CmsLink(linkElement);
                if (link.isInternal()) {
                    link.checkConsistency(cms);
                }
                this.m_linkValue = CmsStringUtil.isEmptyOrWhitespaceOnly(link.getTarget()) ? CmsLink.NULL_LINK : link;
            }
        }
        if (this.m_linkValue == CmsLink.NULL_LINK) {
            return null;
        }
        return this.m_linkValue;
    }

    @Override
    public String getPlainText(CmsObject cms) {
        return this.getStringValue(cms);
    }

    @Override
    public String getSchemaDefinition() {
        if (m_schemaDefinition == null) {
            m_schemaDefinition = this.readSchemaDefinition("org/opencms/xml/types/XmlVarLinkValue.xsd");
        }
        return m_schemaDefinition;
    }

    @Override
    public String getStringValue(CmsObject cms) throws CmsRuntimeException {
        if (this.m_stringValue == null) {
            this.m_stringValue = this.createStringValue(cms);
        }
        return this.m_stringValue;
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isSearchable() {
        return false;
    }

    @Override
    public I_CmsXmlSchemaType newInstance(String name, String minOccurs, String maxOccurs) {
        return new CmsXmlVarLinkValue(name, minOccurs, maxOccurs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStringValue(CmsObject cms, String value) throws CmsIllegalArgumentException {
        CmsRelationType type;
        boolean internal;
        this.m_element.clearContent();
        this.m_linkValue = null;
        this.m_stringValue = null;
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(value)) {
            return;
        }
        String path = value;
        if (cms != null) {
            String siteRoot = OpenCms.getSiteManager().getSiteRoot(value);
            String oldSite = cms.getRequestContext().getSiteRoot();
            try {
                if (siteRoot != null) {
                    cms.getRequestContext().setSiteRoot(siteRoot);
                    path = cms.getRequestContext().removeSiteRoot(value);
                }
                String query = "";
                int pos = path.indexOf("?");
                int anchorPos = path.indexOf(35);
                if (pos == -1 || anchorPos > -1 && pos > anchorPos) {
                    pos = anchorPos;
                }
                if (pos > -1) {
                    query = path.substring(pos);
                    path = path.substring(0, pos);
                }
                if ((path = OpenCms.getLinkManager().getRootPath(cms, path)) != null) {
                    path = path + query;
                }
            }
            finally {
                if (siteRoot != null) {
                    cms.getRequestContext().setSiteRoot(oldSite);
                }
            }
        }
        boolean bl = internal = path != null;
        if (internal) {
            type = this.getRelationType(this.getPath());
        } else {
            path = value;
            type = CmsRelationType.XML_WEAK;
        }
        CmsLink link = new CmsLink(TYPE_VAR_LINK, type, path, internal);
        if (internal) {
            link.checkConsistency(cms);
        }
        CmsLinkUpdateUtil.updateXmlForHtmlValue(link, null, this.m_element.addElement("link"));
        this.m_linkValue = link;
    }

    private String createStringValue(CmsObject cms) {
        CmsLink link;
        Attribute enabled = this.m_element.attribute("enabled");
        String content = "";
        if ((enabled == null || Boolean.valueOf(enabled.getText()).booleanValue()) && (link = this.getLink(cms)) != null) {
            content = link.getUri();
            if (link.isInternal() && cms != null) {
                content = cms.getRequestContext().removeSiteRoot(link.getUri());
            }
        }
        return content;
    }
}

