/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsLog;
import org.opencms.main.I_CmsThrowable;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.A_CmsWidget;
import org.opencms.widgets.CmsDisplayWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.Messages;

public abstract class CmsWidgetDialog
extends CmsDialog
implements I_CmsWidgetDialog {
    public static final int ACTION_ELEMENT_ADD = 152;
    public static final int ACTION_ELEMENT_REMOVE = 153;
    public static final int ACTION_ERROR = 303;
    public static final int ACTION_SAVE = 300;
    public static final String DIALOG_SAVE = "save";
    public static final String EDITOR_ACTION_ELEMENT_ADD = "addelement";
    public static final String EDITOR_ACTION_ELEMENT_REMOVE = "removeelement";
    public static final String HIDDEN_PARAM_PREFIX = "hidden.";
    private static final Log LOG = CmsLog.getLog(CmsWidgetDialog.class);
    protected List<Throwable> m_commitErrors;
    protected Object m_dialogObject;
    protected List<String> m_pages;
    protected String m_paramPage;
    protected List<Throwable> m_validationErrorList;
    protected Map<String, List<CmsWidgetDialogParameter>> m_widgetParamValues;
    protected List<CmsWidgetDialogParameter> m_widgets;
    private Set<String> m_helpMessageIds;
    private String m_paramElementIndex = "0";
    private String m_paramElementName = "undefined";
    private String m_prefix;

    public CmsWidgetDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsWidgetDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCancel() {
        this.clearDialogObject();
    }

    public abstract void actionCommit() throws IOException, ServletException;

    public void actionToggleElement() {
        int index = 0;
        try {
            index = Integer.parseInt(this.getParamElementIndex());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String name = this.getParamElementName();
        CmsWidgetDialogParameter base = this.getParameterDefinition(name);
        if (base != null) {
            List<CmsWidgetDialogParameter> params = this.getParameters().get(name);
            if (this.getAction() == 153) {
                params.remove(index);
            } else {
                List<CmsWidgetDialogParameter> sequence = this.getParameters().get(base.getName());
                if (sequence.size() > 0) {
                    ++index;
                }
                CmsWidgetDialogParameter newParam = new CmsWidgetDialogParameter(base, index);
                params.add(index, newParam);
            }
            for (int i = 0; i < params.size(); ++i) {
                CmsWidgetDialogParameter param = params.get(i);
                param.setindex(i);
            }
        }
    }

    public String buildAddElement(String elementName, int insertAfter, boolean enabled) {
        if (enabled) {
            StringBuffer href = new StringBuffer(4);
            href.append("javascript:addElement('");
            href.append(elementName);
            href.append("', ");
            href.append(insertAfter);
            href.append(");");
            return this.button(href.toString(), null, "new.png", "GUI_DIALOG_BUTTON_ADDNEW_0", 0);
        }
        return "";
    }

    public String buildDialogForm() {
        return this.createDialogHtml(this.getParamPage());
    }

    public String buildRemoveElement(String elementName, int index, boolean enabled) {
        if (enabled) {
            StringBuffer href = new StringBuffer(4);
            href.append("javascript:removeElement('");
            href.append(elementName);
            href.append("', ");
            href.append(index);
            href.append(");");
            return this.button(href.toString(), null, "deletecontent.png", "GUI_DIALOG_BUTTON_DELETE_0", 0);
        }
        return "";
    }

    public void clearDialogObject() {
        this.setDialogObject(null);
    }

    public String dialogBlockEnd() {
        StringBuffer result = new StringBuffer(8);
        result.append(super.dialogBlockEnd());
        result.append(this.dialogSpacer());
        result.append("</td></tr>\n");
        return result.toString();
    }

    public String dialogBlockStart(String headline) {
        StringBuffer result = new StringBuffer(8);
        result.append("<tr><td colspan=\"5\">\n");
        result.append(super.dialogBlockStart(headline));
        return result.toString();
    }

    public String dialogButtonsCustom() {
        if (this.getPages().size() > 1) {
            int pageIndex = this.getPages().indexOf(this.getParamPage());
            if (pageIndex == this.getPages().size() - 1) {
                return this.dialogButtons(new int[]{0, 9, 1}, new String[3]);
            }
            if (pageIndex > 0) {
                return this.dialogButtons(new int[]{9, 10, 1}, new String[3]);
            }
            return this.dialogButtons(new int[]{10, 1}, new String[2]);
        }
        boolean onlyDisplay = true;
        for (CmsWidgetDialogParameter wdp : this.getWidgets()) {
            if (wdp.getWidget() instanceof CmsDisplayWidget) continue;
            onlyDisplay = false;
            break;
        }
        if (!onlyDisplay) {
            return this.dialogButtons(new int[]{0, 1}, new String[2]);
        }
        return "";
    }

    public void displayDialog() throws JspException, IOException, ServletException {
        this.displayDialog(false);
    }

    public void displayDialog(boolean writeLater) throws JspException, IOException, ServletException {
        if (this.isForwarded()) {
            return;
        }
        switch (this.getAction()) {
            case 4: {
                this.actionCancel();
                this.actionCloseDialog();
                break;
            }
            case 303: {
                break;
            }
            case 300: {
                this.setParamAction("ok");
                this.actionCommit();
                if (this.closeDialogOnCommit()) {
                    this.setAction(4);
                    this.actionCloseDialog();
                    break;
                }
                this.setAction(0);
            }
            default: {
                if (writeLater) break;
                this.writeDialog();
            }
        }
    }

    public int getButtonStyle() {
        return this.getSettings().getUserSettings().getEditorButtonStyle();
    }

    public List<Throwable> getCommitErrors() {
        return this.m_commitErrors;
    }

    public Object getDialogObject() {
        if (this.m_dialogObject == null) {
            this.m_dialogObject = this.getDialogObjectMap().get(((Object)((Object)this)).getClass().getName());
        }
        return this.m_dialogObject;
    }

    public Set<String> getHelpMessageIds() {
        if (this.m_helpMessageIds == null) {
            this.m_helpMessageIds = new HashSet<String>();
        }
        return this.m_helpMessageIds;
    }

    public String getParamElementIndex() {
        return this.m_paramElementIndex;
    }

    public String getParamElementName() {
        return this.m_paramElementName;
    }

    public String getParamPage() {
        return this.m_paramPage;
    }

    public String getParamValue(String name) {
        return this.getParamValue(name, 0);
    }

    public String getParamValue(String name, int index) {
        CmsWidgetDialogParameter param;
        List<CmsWidgetDialogParameter> params = this.m_widgetParamValues.get(name);
        if (params != null && index >= 0 && index < params.size() && (param = params.get(index)).getId().equals(CmsWidgetDialogParameter.createId(name, index))) {
            return param.getStringValue(this.getCms());
        }
        return null;
    }

    public String getUserAgent() {
        return this.getJsp().getRequest().getHeader("user-agent");
    }

    public String getWidgetHtmlEnd() {
        StringBuffer result = new StringBuffer(32);
        for (CmsWidgetDialogParameter param : this.getWidgets()) {
            result.append(param.getWidget().getDialogHtmlEnd(this.getCms(), (I_CmsWidgetDialog)this, (I_CmsWidgetParameter)param));
        }
        return result.toString();
    }

    public String getWidgetIncludes() throws JspException {
        StringBuffer result = new StringBuffer(32);
        try {
            Iterator<CmsWidgetDialogParameter> i = this.getWidgets().iterator();
            HashSet<I_CmsWidget> set = new HashSet<I_CmsWidget>();
            while (i.hasNext()) {
                I_CmsWidget widget = i.next().getWidget();
                if (set.contains(widget)) continue;
                result.append(widget.getDialogIncludes(this.getCms(), (I_CmsWidgetDialog)this));
                result.append('\n');
                set.add(widget);
            }
        }
        catch (Throwable e) {
            this.includeErrorpage((CmsWorkplace)this, e);
        }
        return result.toString();
    }

    public String getWidgetInitCalls() throws JspException {
        StringBuffer result = new StringBuffer(32);
        try {
            Iterator<CmsWidgetDialogParameter> i = this.getWidgets().iterator();
            HashSet<I_CmsWidget> set = new HashSet<I_CmsWidget>();
            while (i.hasNext()) {
                I_CmsWidget widget = i.next().getWidget();
                if (set.contains(widget)) continue;
                result.append(widget.getDialogInitCall(this.getCms(), (I_CmsWidgetDialog)this));
                set.add(widget);
            }
        }
        catch (Throwable e) {
            this.includeErrorpage((CmsWorkplace)this, e);
        }
        return result.toString();
    }

    public String getWidgetInitMethods() throws JspException {
        StringBuffer result = new StringBuffer(32);
        try {
            Iterator<CmsWidgetDialogParameter> i = this.getWidgets().iterator();
            HashSet<I_CmsWidget> set = new HashSet<I_CmsWidget>();
            while (i.hasNext()) {
                I_CmsWidget widget = i.next().getWidget();
                if (set.contains(widget)) continue;
                result.append(widget.getDialogInitMethod(this.getCms(), (I_CmsWidgetDialog)this));
                set.add(widget);
            }
        }
        catch (Throwable e) {
            this.includeErrorpage((CmsWorkplace)this, e);
        }
        return result.toString();
    }

    public String paramsAsHidden() {
        if (this.getAction() != 303) {
            return super.paramsAsHidden();
        }
        StringBuffer result = new StringBuffer();
        result.append(super.paramsAsHidden());
        result.append('\n');
        result.append(this.widgetParamsAsHidden());
        return result.toString();
    }

    public void setDialogObject(Object dialogObject) {
        this.m_dialogObject = dialogObject;
        if (dialogObject == null) {
            this.getDialogObjectMap().remove(((Object)((Object)this)).getClass().getName());
        } else {
            this.getDialogObjectMap().put(((Object)((Object)this)).getClass().getName(), dialogObject);
        }
    }

    public void setParamElementIndex(String elementIndex) {
        this.m_paramElementIndex = elementIndex;
    }

    public void setParamElementName(String elementName) {
        this.m_paramElementName = elementName;
    }

    public void setParamPage(String paramPage) {
        this.m_paramPage = paramPage;
    }

    public String widgetParamsAsHidden() {
        return this.widgetParamsAsHidden(null);
    }

    public String widgetParamsAsHidden(String excludeDialogPage) {
        StringBuffer result = new StringBuffer();
        Iterator<String> i = this.m_widgetParamValues.keySet().iterator();
        while (i.hasNext()) {
            List<CmsWidgetDialogParameter> params = this.m_widgetParamValues.get(i.next());
            for (CmsWidgetDialogParameter param : params) {
                String value = param.getStringValue(this.getCms());
                if (!CmsStringUtil.isNotEmpty((String)value) || excludeDialogPage != null && param.getDialogPage().equals(excludeDialogPage)) continue;
                result.append("<input type=\"hidden\" name=\"");
                result.append(HIDDEN_PARAM_PREFIX);
                result.append(param.getId());
                result.append("\" value=\"");
                String encoded = CmsEncoder.encode((String)value, (String)this.getCms().getRequestContext().getEncoding());
                result.append(encoded);
                result.append("\">\n");
            }
        }
        return result.toString();
    }

    public void writeDialog() throws IOException, JspException {
        if (this.isForwarded()) {
            return;
        }
        switch (this.getAction()) {
            case 4: 
            case 300: 
            case 303: {
                break;
            }
            default: {
                this.setParamAction(DIALOG_SAVE);
                JspWriter out = this.getJsp().getJspContext().getOut();
                out.print(this.defaultActionHtml());
            }
        }
    }

    protected void addCommitError(Exception error) {
        if (this.m_commitErrors == null) {
            this.m_commitErrors = new ArrayList<Throwable>();
        }
        this.m_commitErrors.add(error);
    }

    protected void addWidget(CmsWidgetDialogParameter param) {
        if (this.m_widgets == null) {
            this.m_widgets = new ArrayList<CmsWidgetDialogParameter>();
        }
        param.setKeyPrefix(this.m_prefix);
        this.m_widgets.add(param);
    }

    protected boolean closeDialogOnCommit() {
        return !this.hasCommitErrors();
    }

    protected List<Throwable> commitWidgetValues() {
        return this.commitWidgetValues(null);
    }

    protected List<Throwable> commitWidgetValues(String dialogPage) {
        ArrayList<Throwable> result = new ArrayList<Throwable>();
        for (CmsWidgetDialogParameter base : this.getWidgets()) {
            if (dialogPage != null && base.getDialogPage() != null && !dialogPage.equals(base.getDialogPage())) continue;
            base.prepareCommit();
            List<CmsWidgetDialogParameter> params = this.m_widgetParamValues.get(base.getName());
            for (CmsWidgetDialogParameter param : params) {
                try {
                    param.commitValue(this);
                }
                catch (Exception e) {
                    result.add(e);
                }
            }
        }
        this.setValidationErrorList(result);
        return result;
    }

    protected String createDialogHtml() {
        return this.createDialogHtml(null);
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        for (CmsWidgetDialogParameter base : this.getWidgets()) {
            if (dialog != null && !dialog.equals(base.getDialogPage())) continue;
            result.append(this.createDialogRowHtml(base));
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected String createDialogRowHtml(CmsWidgetDialogParameter base) {
        StringBuffer result = new StringBuffer(256);
        List<CmsWidgetDialogParameter> sequence = this.getParameters().get(base.getName());
        int count = sequence.size();
        boolean addValue = false;
        if (count < base.getMaxOccurs()) {
            addValue = true;
        }
        boolean removeValue = false;
        if (count > base.getMinOccurs()) {
            removeValue = true;
        }
        boolean disabledElement = false;
        if (count < 1) {
            sequence = new ArrayList<CmsWidgetDialogParameter>();
            sequence.add(base);
            count = 1;
            if (base.getMinOccurs() == 0) {
                disabledElement = true;
            }
        }
        for (int j = 0; j < count; ++j) {
            CmsWidgetDialogParameter p = sequence.get(j);
            I_CmsWidget widget = p.getWidget();
            if (p.hasError()) {
                result.append("<tr><td></td><td><img src=\"");
                result.append(CmsWidgetDialog.getSkinUri()).append("editors/xmlcontent/");
                result.append("error.png");
                result.append("\" border=\"0\" alt=\"\"></td><td class=\"xmlTdError\">");
                Throwable t = p.getError();
                while (t != null) {
                    if (t instanceof I_CmsThrowable) {
                        result.append(CmsEncoder.escapeXml((String)((I_CmsThrowable)t).getLocalizedMessage(this.getLocale())));
                    } else {
                        result.append(CmsEncoder.escapeXml((String)t.getLocalizedMessage()));
                    }
                    if ((t = t.getCause()) == null) continue;
                    result.append("<br>");
                }
                result.append("</td><td colspan=\"2\"></td></tr>\n");
            }
            result.append("<tr>");
            result.append("<td class=\"xmlLabel");
            if (disabledElement) {
                result.append("Disabled");
            }
            result.append("\">");
            result.append(this.keyDefault(A_CmsWidget.getLabelKey((I_CmsWidgetParameter)p), p.getName()));
            if (count > 1) {
                result.append(" [").append(p.getIndex() + 1).append("]");
            }
            result.append(": </td>");
            if (p.getIndex() == 0) {
                result.append(p.getWidget().getHelpBubble(this.getCms(), (I_CmsWidgetDialog)this, (I_CmsWidgetParameter)p));
            } else {
                result.append(this.dialogHorizontalSpacer(16));
            }
            if (!disabledElement) {
                result.append(widget.getDialogWidget(this.getCms(), (I_CmsWidgetDialog)this, (I_CmsWidgetParameter)p));
            } else {
                result.append("<td class=\"xmlTdDisabled maxwidth\">");
                result.append(this.key("GUI_EDITOR_WIDGET_OPTIONALELEMENT_0"));
                result.append("</td>");
            }
            result.append(this.dialogHorizontalSpacer(5));
            result.append("<td>");
            if (addValue || removeValue) {
                result.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>");
                if (!addValue) {
                    result.append(this.dialogHorizontalSpacer(25));
                } else {
                    result.append("<td><table class=\"editorbuttonbackground\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>");
                    result.append(this.buildAddElement(base.getName(), p.getIndex(), addValue));
                }
                if (removeValue) {
                    if (!addValue) {
                        result.append("<td><table class=\"editorbuttonbackground\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>");
                    }
                    result.append(this.buildRemoveElement(base.getName(), p.getIndex(), removeValue));
                }
                result.append("</tr></table></td>");
                result.append("</tr></table>");
            }
            result.append("</td>");
            result.append("</tr>\n");
        }
        return result.toString();
    }

    protected String createDialogRowsHtml(int startIndex, int endIndex) {
        StringBuffer result = new StringBuffer((endIndex - startIndex) * 8);
        for (int i = startIndex; i <= endIndex; ++i) {
            CmsWidgetDialogParameter base = this.getWidgets().get(i);
            result.append(this.createDialogRowHtml(base));
        }
        return result.toString();
    }

    protected String createWidgetBlockEnd() {
        StringBuffer result = new StringBuffer(8);
        result.append(this.createWidgetTableEnd());
        result.append(this.dialogBlockEnd());
        return result.toString();
    }

    protected String createWidgetBlockStart(String headline) {
        StringBuffer result = new StringBuffer(16);
        result.append(this.dialogBlockStart(headline));
        result.append(this.createWidgetTableStart());
        return result.toString();
    }

    protected String createWidgetErrorHeader() {
        StringBuffer result = new StringBuffer(8);
        if (this.hasValidationErrors() || this.hasCommitErrors()) {
            String message;
            result.append("<tr><td colspan=\"5\">&nbsp;</td></tr>\n");
            result.append("<tr><td colspan=\"2\">&nbsp;</td>");
            result.append("<td class=\"xmlTdErrorHeader\">");
            result.append(this.key("GUI_EDITOR_WIDGET_VALIDATION_ERROR_TITLE_0"));
            result.append("</td><td colspan=\"2\">&nbsp;");
            result.append("</td></tr>\n");
            result.append("<tr><td colspan=\"5\">&nbsp;</td></tr>\n");
            if (this.hasCommitErrors()) {
                result.append(this.dialogBlockStart(""));
                result.append(this.createWidgetTableStart());
                for (Throwable t : this.getCommitErrors()) {
                    result.append("<tr><td><img src=\"");
                    result.append(CmsWidgetDialog.getSkinUri()).append("editors/xmlcontent/");
                    result.append("error.png");
                    result.append("\" border=\"0\" alt=\"\"></td><td class=\"xmlTdError maxwidth\">");
                    while (t != null) {
                        message = "";
                        message = t instanceof I_CmsThrowable ? ((I_CmsThrowable)t).getLocalizedMessage(this.getLocale()) : t.getLocalizedMessage();
                        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)message)) {
                            result.append(CmsStringUtil.escapeHtml((String)message));
                        }
                        if ((t = t.getCause()) == null) continue;
                        result.append("<br/>");
                    }
                    result.append("</td></tr>\n");
                }
                result.append(this.createWidgetTableEnd());
                result.append(this.dialogBlockEnd());
            }
            if (this.hasValidationErrors()) {
                result.append(this.dialogBlockStart(""));
                result.append(this.createWidgetTableStart());
                for (Throwable t : this.getValidationErrorList()) {
                    result.append("<tr><td><img src=\"");
                    result.append(CmsWidgetDialog.getSkinUri()).append("editors/xmlcontent/");
                    result.append("error.png");
                    result.append("\" border=\"0\" alt=\"\"></td><td class=\"xmlTdError maxwidth\">");
                    while (t != null) {
                        message = "";
                        message = t instanceof I_CmsThrowable ? ((I_CmsThrowable)t).getLocalizedMessage(this.getLocale()) : t.getLocalizedMessage();
                        result.append(CmsStringUtil.escapeHtml((String)message));
                        if ((t = t.getCause()) == null) continue;
                        result.append("<br>");
                    }
                    result.append("</td></tr>\n");
                }
                result.append(this.createWidgetTableEnd());
                result.append(this.dialogBlockEnd());
            }
        }
        return result.toString();
    }

    protected String createWidgetTableEnd() {
        return "</table>\n";
    }

    protected String createWidgetTableStart() {
        return "<table cellspacing='0' cellpadding='0' class='xmlTable'>\n";
    }

    protected String defaultActionHtml() throws JspException {
        StringBuffer result = new StringBuffer(2048);
        result.append(this.defaultActionHtmlStart());
        result.append(this.defaultActionHtmlContent());
        result.append(this.defaultActionHtmlEnd());
        return result.toString();
    }

    protected String defaultActionHtmlContent() {
        StringBuffer result = new StringBuffer(2048);
        result.append("<form name=\"EDITOR\" id=\"EDITOR\" method=\"post\" action=\"").append(this.getDialogRealUri());
        result.append("\" class=\"nomargin\" onsubmit=\"return submitAction('").append("ok").append("', null, 'EDITOR');\">\n");
        result.append(this.dialogContentStart(this.getDialogTitle()));
        result.append(this.buildDialogForm());
        result.append(this.dialogContentEnd());
        result.append(this.dialogButtonsCustom());
        result.append(this.paramsAsHidden());
        if (this.getParamFramename() == null) {
            result.append("\n<input type=\"hidden\" name=\"").append("framename").append("\" value=\"\">\n");
        }
        result.append("</form>\n");
        result.append(this.getWidgetHtmlEnd());
        return result.toString();
    }

    protected String defaultActionHtmlEnd() {
        StringBuffer result = new StringBuffer(2048);
        result.append(this.dialogEnd());
        result.append(this.bodyEnd());
        result.append(this.htmlEnd());
        return result.toString();
    }

    protected String defaultActionHtmlStart() throws JspException {
        StringBuffer result = new StringBuffer(2048);
        result.append(this.htmlStart("administration/index.html"));
        result.append("<script type=\"text/javascript\" src=\"").append(this.getResourceUri()).append("editors/xmlcontent/edit.js\"></script>\n");
        result.append("<script type=\"text/javascript\" src=\"").append(this.getResourceUri()).append("editors/xmlcontent/help.js\"></script>\n");
        result.append(this.getWidgetIncludes());
        result.append("<script type=\"text/javascript\">\n<!--\n");
        result.append("// flag indicating if form initialization is finished\n");
        result.append("var initialized = false;\n");
        result.append("// the OpenCms context path\n");
        result.append("var contextPath = \"").append(OpenCms.getSystemInfo().getOpenCmsContext()).append("\";\n\n");
        result.append("// action parameters of the form\n");
        result.append("var actionAddElement = \"").append(EDITOR_ACTION_ELEMENT_ADD).append("\";\n");
        result.append("var actionRemoveElement = \"").append(EDITOR_ACTION_ELEMENT_REMOVE).append("\";\n");
        result.append("function init() {\n");
        result.append(this.getWidgetInitCalls());
        result.append("\tsetTimeout(\"scrollForm();\", 200);\n");
        result.append("\tinitialized = true;\n");
        result.append("\twindow.onbeforeunload=exitEditor;\n");
        result.append("}\n\n");
        result.append("window.exitEditorCalled = false;\n");
        result.append("function exitEditor() {\n");
        result.append("\tif (window.exitEditorCalled) return;\n");
        result.append("\twindow.exitEditorCalled = true; \n");
        result.append("\ttry {\n");
        result.append("\t\t// close file selector popup if present\n");
        result.append("\t\tcloseTreeWin();\n");
        result.append("\t} catch (e) {}\n");
        result.append("}\n");
        result.append(this.getWidgetInitMethods());
        result.append("\n// -->\n</script>\n");
        result.append(this.bodyStart(null, "onload='init();'  onunload='exitEditor();'"));
        result.append(this.dialogStart());
        return result.toString();
    }

    protected abstract void defineWidgets();

    protected void fillWidgetValues(HttpServletRequest request) {
        Map parameters = request.getParameterMap();
        HashMap<String, String[]> processedParameters = new HashMap<String, String[]>();
        for (Map.Entry entry : parameters.entrySet()) {
            String key = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            if (key.startsWith(HIDDEN_PARAM_PREFIX)) {
                key = key.substring(HIDDEN_PARAM_PREFIX.length());
                String[] newValues = new String[values.length];
                for (int l = 0; l < values.length; ++l) {
                    newValues[l] = CmsEncoder.decode((String)values[l], (String)this.getCms().getRequestContext().getEncoding());
                }
                values = newValues;
            }
            processedParameters.put(key, values);
        }
        this.m_widgetParamValues = new HashMap<String, List<CmsWidgetDialogParameter>>();
        for (CmsWidgetDialogParameter base : this.getWidgets()) {
            ArrayList<CmsWidgetDialogParameter> params = new ArrayList<CmsWidgetDialogParameter>();
            int maxOccurs = base.getMaxOccurs();
            boolean onPage = false;
            if (base.isCollectionBase() && CmsStringUtil.isNotEmpty((String)this.getParamAction()) && !"initial".equals(this.getParamAction())) {
                String page = this.getParamPage();
                onPage = CmsStringUtil.isEmpty((String)page) || CmsStringUtil.isEmpty((String)base.getDialogPage()) || base.getDialogPage().equals(page);
            }
            for (int j = 0; j < maxOccurs; ++j) {
                boolean required;
                String id = CmsWidgetDialogParameter.createId(base.getName(), j);
                boolean bl = required = params.size() < base.getMinOccurs() || processedParameters.get(id) != null || !onPage && base.hasValue(j);
                if (!required) continue;
                CmsWidgetDialogParameter param = new CmsWidgetDialogParameter(base, params.size(), j);
                param.setKeyPrefix(this.m_prefix);
                base.getWidget().setEditorValue(this.getCms(), processedParameters, (I_CmsWidgetDialog)this, (I_CmsWidgetParameter)param);
                params.add(param);
            }
            this.m_widgetParamValues.put(base.getName(), params);
        }
    }

    protected String getDialogTitle() {
        return null;
    }

    protected abstract String[] getPageArray();

    protected List<String> getPages() {
        if (this.m_pages == null) {
            this.m_pages = Arrays.asList(this.getPageArray());
        }
        return this.m_pages;
    }

    protected CmsWidgetDialogParameter getParameterDefinition(String name) {
        for (CmsWidgetDialogParameter base : this.getWidgets()) {
            if (!base.getName().equals(name)) continue;
            return base;
        }
        return null;
    }

    protected Map<String, List<CmsWidgetDialogParameter>> getParameters() {
        return this.m_widgetParamValues;
    }

    protected List<Throwable> getValidationErrorList() {
        return this.m_validationErrorList;
    }

    protected String getWidget(CmsWidgetDialogParameter param) {
        if (param != null) {
            return param.getWidget().getDialogWidget(this.getCms(), (I_CmsWidgetDialog)this, (I_CmsWidgetParameter)param);
        }
        return null;
    }

    protected List<CmsWidgetDialogParameter> getWidgets() {
        if (this.m_widgets == null) {
            this.m_widgets = new ArrayList<CmsWidgetDialogParameter>();
        }
        return this.m_widgets;
    }

    protected boolean hasCommitErrors() {
        return this.m_commitErrors != null && this.m_commitErrors.size() > 0;
    }

    protected boolean hasValidationErrors() {
        return this.m_validationErrorList != null && this.m_validationErrorList.size() > 0;
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.setParamDialogtype(((Object)((Object)this)).getClass().getName());
        this.fillParamValues(request);
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.getParamPage()) || !this.getPages().contains(this.getParamPage())) {
            this.setParamPage(this.getPages().get(0));
        }
        try {
            this.validateParamaters();
        }
        catch (Exception e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)Messages.get().container("ERR_WORKPLACE_DIALOG_PARAMS_1", (Object)this.getCurrentToolPath()), (Throwable)e);
            }
            this.setAction(4);
            try {
                this.actionCloseDialog();
            }
            catch (JspException jspException) {
                // empty catch block
            }
            return;
        }
        this.defineWidgets();
        this.fillWidgetValues(request);
        if (DIALOG_SAVE.equals(this.getParamAction())) {
            List<Throwable> errors = this.commitWidgetValues(null);
            if (errors.size() > 0) {
                this.setAction(0);
                return;
            }
            this.setAction(300);
        } else if ("ok".equals(this.getParamAction())) {
            this.setAction(4);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else if (EDITOR_ACTION_ELEMENT_ADD.equals(this.getParamAction())) {
            this.setAction(152);
            this.actionToggleElement();
            this.setAction(0);
        } else if (EDITOR_ACTION_ELEMENT_REMOVE.equals(this.getParamAction())) {
            this.setAction(153);
            this.actionToggleElement();
            this.setAction(0);
        } else if ("back".equals(this.getParamAction())) {
            this.setAction(0);
            List<Throwable> errors = this.commitWidgetValues(this.getParamPage());
            if (errors.size() > 0) {
                return;
            }
            int pageIndex = this.getPages().indexOf(this.getParamPage()) - 1;
            this.setParamPage(this.getPages().get(pageIndex));
        } else if ("continue".equals(this.getParamAction())) {
            this.setAction(0);
            List<Throwable> errors = this.commitWidgetValues(this.getParamPage());
            if (errors.size() > 0) {
                return;
            }
            int pageIndex = this.getPages().indexOf(this.getParamPage()) + 1;
            this.setParamPage(this.getPages().get(pageIndex));
        } else {
            this.setAction(0);
        }
    }

    protected void setCommitErrors(List<Throwable> errors) {
        this.m_commitErrors = errors;
    }

    protected void setKeyPrefix(String prefix) {
        this.m_prefix = prefix;
    }

    protected void setPages(List<String> pages) {
        this.m_pages = pages;
    }

    protected void setValidationErrorList(List<Throwable> errors) {
        this.m_validationErrorList = errors;
    }

    protected void validateParamaters() throws Exception {
    }

    private Map<String, Object> getDialogObjectMap() {
        Hashtable objects = (Hashtable)this.getSettings().getDialogObject();
        if (objects == null) {
            objects = new Hashtable();
            this.getSettings().setDialogObject(objects);
        }
        return objects;
    }
}

