/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.A_CmsWidget;
import org.opencms.widgets.CmsWidgetException;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.widgets.Messages;
import org.opencms.workplace.CmsWidgetDialog;

public class CmsWidgetDialogParameter
implements I_CmsWidgetParameter {
    public static final String DEFAULT_DIALOG_PAGE = "default";
    public static final int MAX_OCCURENCES = 200;
    protected Object m_baseCollection;
    protected Object m_baseObject;
    protected String m_baseObjectProperty;
    protected String m_defaultValue;
    protected String m_dialogPage;
    protected Throwable m_error;
    protected String m_id;
    protected int m_index;
    protected int m_maxOccurs;
    protected int m_minOccurs;
    protected String m_name;
    protected String m_prefix;
    protected String m_value;
    protected I_CmsWidget m_widget;

    public CmsWidgetDialogParameter(CmsWidgetDialogParameter base, int index) {
        this(null, base.m_defaultValue, base.getName(), base.getWidget(), base.getDialogPage(), base.getMinOccurs(), base.getMaxOccurs(), index);
        this.m_baseObject = base.m_baseObject;
        this.m_baseObjectProperty = base.m_baseObjectProperty;
        this.m_baseCollection = base.m_baseCollection;
        this.m_prefix = base.m_prefix;
    }

    public CmsWidgetDialogParameter(CmsWidgetDialogParameter base, int index, int originalIndex) {
        this(null, base.m_defaultValue, base.getName(), base.getWidget(), base.getDialogPage(), base.getMinOccurs(), base.getMaxOccurs(), index);
        this.m_baseObject = base.m_baseObject;
        this.m_baseObjectProperty = base.m_baseObjectProperty;
        this.m_baseCollection = base.m_baseCollection;
        if (this.m_baseCollection != null) {
            SortedMap baseMap;
            ArrayList keyList;
            if (this.m_baseCollection instanceof List) {
                Object o;
                List baseList = (List)this.m_baseCollection;
                if (originalIndex < baseList.size() && (o = baseList.get(originalIndex)) != null) {
                    this.m_value = o.toString();
                }
            } else if (this.m_baseCollection instanceof SortedMap && originalIndex < (keyList = new ArrayList((baseMap = (SortedMap)this.m_baseCollection).keySet())).size()) {
                Object key = keyList.get(originalIndex);
                Object value = baseMap.get(key);
                StringBuffer val = new StringBuffer();
                val.append(key != null ? key.toString() : "");
                val.append('=');
                val.append(value != null ? value.toString() : "");
                this.m_value = val.toString();
            }
        }
    }

    public CmsWidgetDialogParameter(Object base, String property, I_CmsWidget widget) {
        this(base, property, DEFAULT_DIALOG_PAGE, widget);
    }

    public CmsWidgetDialogParameter(Object base, String property, String dialogPage, I_CmsWidget widget) {
        this(base, property, null, dialogPage, widget, 1, 1);
    }

    public CmsWidgetDialogParameter(Object base, String property, String htmlName, String dialogPage, I_CmsWidget widget) {
        this(base, property, htmlName, null, dialogPage, widget, 1, 1);
    }

    public CmsWidgetDialogParameter(Object base, String property, String defaultValue, String dialogPage, I_CmsWidget widget, int minOccurs, int maxOccurs) {
        this(base, property, property, defaultValue, dialogPage, widget, minOccurs, maxOccurs);
    }

    public CmsWidgetDialogParameter(Object base, String property, String htmlName, String defaultValue, String dialogPage, I_CmsWidget widget, int minOccurs, int maxOccurs) {
        if (htmlName == null) {
            htmlName = property;
        }
        if (base instanceof List || base instanceof SortedMap) {
            this.init(null, defaultValue, htmlName, widget, dialogPage, 0, 200, 0);
            this.m_baseObject = null;
            this.m_baseObjectProperty = null;
            this.m_baseCollection = base;
        } else {
            this.init(null, defaultValue, htmlName, widget, dialogPage, minOccurs, maxOccurs, 0);
            this.m_baseObject = base;
            this.m_baseObjectProperty = property;
            this.m_baseCollection = null;
            PropertyUtilsBean bean = new PropertyUtilsBean();
            Object value = null;
            if (!bean.isReadable(this.m_baseObject, this.m_baseObjectProperty) || !bean.isWriteable(this.m_baseObject, this.m_baseObjectProperty)) {
                try {
                    value = bean.getMappedProperty(this.m_baseObject, this.m_baseObjectProperty);
                }
                catch (Exception e) {
                    throw new CmsIllegalArgumentException(Messages.get().container("ERR_NO_PROPERTY_2", (Object)base.getClass().getName(), (Object)property));
                }
            }
            try {
                if (value == null) {
                    value = bean.getNestedProperty(this.m_baseObject, this.m_baseObjectProperty);
                }
            }
            catch (Exception e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_PROPERTY_READ_2", (Object)property, (Object)base.getClass().getName()), (Throwable)e);
            }
            if (value != null) {
                if (value instanceof List || value instanceof SortedMap) {
                    this.m_baseCollection = value;
                    this.m_minOccurs = 0;
                    this.m_maxOccurs = 200;
                } else {
                    this.m_value = this.m_defaultValue = String.valueOf(value);
                    if (this.m_minOccurs == 0 && !this.m_value.equals(defaultValue)) {
                        this.m_minOccurs = 1;
                    }
                }
            }
        }
    }

    public CmsWidgetDialogParameter(String name, I_CmsWidget widget) {
        this(null, null, name, widget, DEFAULT_DIALOG_PAGE, 1, 1, 0);
    }

    public CmsWidgetDialogParameter(String name, I_CmsWidget widget, int minOccurs, int maxOccurs) {
        this(null, null, name, widget, DEFAULT_DIALOG_PAGE, minOccurs, maxOccurs, 0);
    }

    public CmsWidgetDialogParameter(String value, String defaultValue, String name, I_CmsWidget widget, String dialog, int minOccurs, int maxOccurs, int index) {
        this.init(value, defaultValue, name, widget, dialog, minOccurs, maxOccurs, index);
    }

    public static String createId(String name, int index) {
        StringBuffer result = new StringBuffer();
        result.append(name);
        result.append('.');
        result.append(index);
        return result.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commitValue(CmsWidgetDialog dialog) throws CmsException {
        if (this.m_baseCollection == null) {
            PropertyUtilsBean bean = new PropertyUtilsBean();
            ConvertUtilsBean converter = new ConvertUtilsBean();
            Object value = null;
            try {
                Class type = bean.getPropertyType(this.m_baseObject, this.m_baseObjectProperty);
                value = converter.convert(this.m_value, type);
                bean.setNestedProperty(this.m_baseObject, this.m_baseObjectProperty, value);
                this.setError(null);
                return;
            }
            catch (InvocationTargetException e) {
                this.setError(e.getTargetException());
                throw new CmsWidgetException(Messages.get().container("ERR_PROPERTY_WRITE_3", value, (Object)dialog.keyDefault(A_CmsWidget.getLabelKey((I_CmsWidgetParameter)this), this.getKey()), (Object)this.m_baseObject.getClass().getName()), e.getTargetException(), (Object)this);
            }
            catch (Exception e) {
                this.setError(e);
                throw new CmsWidgetException(Messages.get().container("ERR_PROPERTY_WRITE_3", value, (Object)dialog.keyDefault(A_CmsWidget.getLabelKey((I_CmsWidgetParameter)this), this.getKey()), (Object)this.m_baseObject.getClass().getName()), (Throwable)e, (Object)this);
            }
        }
        if (!(this.m_baseCollection instanceof SortedMap)) {
            if (!(this.m_baseCollection instanceof List)) return;
            if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.m_value)) return;
            List list = (List)this.m_baseCollection;
            list.add(this.m_value);
            return;
        }
        if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.m_value)) return;
        int pos = this.m_value.indexOf(61);
        if (pos > 0 && pos < this.m_value.length() - 1) {
            String key = this.m_value.substring(0, pos);
            String value = this.m_value.substring(pos + 1).trim();
            SortedMap map = (SortedMap)this.m_baseCollection;
            if (map.containsKey(key)) {
                Object val = map.get(key);
                CmsWidgetException error = new CmsWidgetException(Messages.get().container("ERR_MAP_DUPLICATE_KEY_3", (Object)dialog.keyDefault(A_CmsWidget.getLabelKey((I_CmsWidgetParameter)this), this.getKey()), (Object)key, val), (Object)this);
                this.setError((Throwable)error);
                throw error;
            }
            map.put(key, value);
            return;
        }
        CmsWidgetException error = new CmsWidgetException(Messages.get().container("ERR_MAP_PARAMETER_FORM_1", (Object)dialog.keyDefault(A_CmsWidget.getLabelKey((I_CmsWidgetParameter)this), this.getKey())), (Object)this);
        this.setError((Throwable)error);
        throw error;
    }

    public String getDefault(CmsObject cms) {
        return this.m_defaultValue;
    }

    public String getDialogPage() {
        return this.m_dialogPage;
    }

    public Throwable getError() {
        return this.m_error;
    }

    public String getId() {
        return this.m_id;
    }

    public int getIndex() {
        return this.m_index;
    }

    public String getKey() {
        StringBuffer result = new StringBuffer(128);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.m_prefix)) {
            result.append(this.m_prefix);
            result.append('.');
        }
        result.append(this.getName());
        return result.toString();
    }

    public int getMaxOccurs() {
        return this.m_maxOccurs;
    }

    public int getMinOccurs() {
        return this.m_minOccurs;
    }

    public String getName() {
        return this.m_name;
    }

    public String getStringValue(CmsObject cms) throws CmsRuntimeException {
        return this.m_value;
    }

    public I_CmsWidget getWidget() {
        return this.m_widget;
    }

    public boolean hasError() {
        return this.m_error != null;
    }

    public boolean hasValue(int index) {
        if (this.m_baseCollection instanceof List) {
            return index < ((List)this.m_baseCollection).size();
        }
        if (this.m_baseCollection instanceof SortedMap) {
            return index < ((SortedMap)this.m_baseCollection).size();
        }
        return false;
    }

    public boolean isCollectionBase() {
        return this.m_baseCollection != null && (this.m_baseCollection instanceof List || this.m_baseCollection instanceof SortedMap);
    }

    public void prepareCommit() {
        if (this.m_baseCollection instanceof List) {
            List list = (List)this.m_baseCollection;
            list.clear();
        } else if (this.m_baseCollection instanceof SortedMap) {
            SortedMap map = (SortedMap)this.m_baseCollection;
            map.clear();
        }
    }

    public void setError(Throwable error) {
        this.m_error = error;
    }

    public void setindex(int index) {
        this.m_index = index;
        this.m_id = CmsWidgetDialogParameter.createId(this.m_name, this.m_index);
    }

    public void setKeyPrefix(String prefix) {
        this.m_prefix = prefix;
    }

    public void setStringValue(CmsObject cms, String value) throws CmsIllegalArgumentException {
        this.m_value = value;
    }

    protected void init(String value, String defaultValue, String name, I_CmsWidget widget, String dialog, int minOccurs, int maxOccurs, int index) {
        this.m_defaultValue = defaultValue == null ? "" : defaultValue;
        this.m_value = value == null ? this.m_defaultValue : value;
        this.m_name = name;
        this.m_widget = widget;
        this.m_maxOccurs = maxOccurs < 200 ? maxOccurs : 200;
        this.m_minOccurs = minOccurs >= 0 ? minOccurs : 0;
        if (this.m_minOccurs > this.m_maxOccurs) {
            this.m_minOccurs = this.m_maxOccurs;
        }
        this.m_dialogPage = dialog;
        this.m_error = null;
        this.setindex(index);
    }
}

