/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.relations.CmsCategory;
import org.opencms.relations.CmsCategoryService;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.commons.Messages;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.I_CmsListFormatter;

public abstract class A_CmsResourceCategoriesList
extends A_CmsListDialog {
    public static final String LIST_ACTION_ICON = "ai";
    public static final String LIST_COLUMN_ICON = "ci";
    public static final String LIST_COLUMN_LEAFS = "cl";
    public static final String LIST_COLUMN_NAME = "cn";
    public static final String LIST_COLUMN_PATH = "cp";
    public static final String LIST_COLUMN_STATE = "cs";
    public static final String LIST_DETAIL_DESCRIPTION = "doo";
    public static final String LIST_DETAIL_PATH = "dp";
    private CmsCategoryService m_categoryService = CmsCategoryService.getInstance();
    private List<CmsCategory> m_resCats;

    protected A_CmsResourceCategoriesList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName, boolean searchable) {
        super(jsp, listId, listName, LIST_COLUMN_PATH, CmsListOrderEnum.ORDER_ASCENDING, searchable ? LIST_COLUMN_NAME : null);
    }

    @Override
    public void executeListMultiActions() throws CmsRuntimeException {
        this.throwListUnsupportedActionException();
    }

    @Override
    protected void fillDetails(String detailId) {
        List<CmsListItem> items = this.getList().getAllContent();
        for (CmsListItem item : items) {
            String categoryPath = item.getId();
            StringBuffer html = new StringBuffer(512);
            try {
                CmsCategory category = this.m_categoryService.readCategory(this.getCms(), categoryPath, this.getParamResource());
                if (detailId.equals(LIST_DETAIL_PATH)) {
                    html.append(category.getRootPath());
                } else if (detailId.equals(LIST_DETAIL_DESCRIPTION) && CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)category.getDescription())) {
                    html.append(category.getDescription());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            item.set(detailId, html.toString());
        }
    }

    protected abstract List<CmsCategory> getCategories() throws CmsException;

    protected CmsCategoryService getCategoryService() {
        return this.m_categoryService;
    }

    @Override
    protected List<CmsListItem> getListItems() throws CmsException {
        HashMap<String, CmsListItem> ret = new HashMap<String, CmsListItem>();
        HashMap<String, Boolean> isLeaf = new HashMap<String, Boolean>();
        List<CmsCategory> cats = this.getCategories();
        for (CmsCategory category : cats) {
            isLeaf.put(category.getPath(), Boolean.TRUE);
        }
        for (CmsCategory category : cats) {
            String parentPath = CmsResource.getParentFolder((String)category.getPath());
            if (parentPath == null || isLeaf.get(parentPath) == null) continue;
            isLeaf.put(parentPath, Boolean.FALSE);
        }
        for (CmsCategory category : cats) {
            String name;
            String categoryPath = category.getPath();
            if (ret.get(categoryPath) != null) continue;
            CmsListItem item = this.getList().newItem(categoryPath);
            StringBuffer itemHtml = new StringBuffer(192);
            int pathLevel = CmsStringUtil.splitAsList((String)categoryPath, (char)'/').size();
            if (pathLevel > 1) {
                itemHtml.append("<img src=\"");
                itemHtml.append(CmsWorkplace.getResourceUri((String)"tree/empty.gif"));
                itemHtml.append("\" width=\"");
                itemHtml.append((pathLevel - 1) * 20);
                itemHtml.append("px\" height=\"11px\"/>");
            }
            if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)(name = category.getTitle()))) {
                name = category.getName();
            }
            itemHtml.append(name);
            item.set(LIST_COLUMN_NAME, itemHtml.toString());
            item.set(LIST_COLUMN_PATH, categoryPath);
            item.set(LIST_COLUMN_LEAFS, isLeaf.get(categoryPath));
            ret.put(item.getId(), item);
        }
        return new ArrayList<CmsListItem>(ret.values());
    }

    protected List<CmsCategory> getResourceCategories() throws CmsException {
        if (this.m_resCats == null) {
            this.m_resCats = this.m_categoryService.readResourceCategories(this.getJsp().getCmsObject(), this.getParamResource());
        }
        return this.m_resCats;
    }

    @Override
    protected void setColumns(CmsListMetadata metadata) {
        this.setStateActionCol(metadata);
        CmsListColumnDefinition nameCol = new CmsListColumnDefinition(LIST_COLUMN_NAME);
        nameCol.setName(Messages.get().container("GUI_CATEGORIES_LIST_COLS_NAME_0"));
        nameCol.setWidth("100%");
        nameCol.setSorteable(false);
        metadata.addColumn(nameCol);
        CmsListColumnDefinition pathCol = new CmsListColumnDefinition(LIST_COLUMN_PATH);
        pathCol.setName(Messages.get().container("GUI_CATEGORIES_LIST_COLS_PATH_0"));
        pathCol.setVisible(false);
        metadata.addColumn(pathCol);
        CmsListColumnDefinition leafCol = new CmsListColumnDefinition(LIST_COLUMN_LEAFS);
        leafCol.setName(Messages.get().container("GUI_CATEGORIES_LIST_COLS_PATH_0"));
        leafCol.setVisible(false);
        metadata.addColumn(leafCol);
    }

    @Override
    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails pathDetails = new CmsListItemDetails(LIST_DETAIL_PATH);
        pathDetails.setAtColumn(LIST_COLUMN_NAME);
        pathDetails.setVisible(false);
        pathDetails.setShowActionName(Messages.get().container("GUI_CATEGORIES_DETAIL_SHOW_PATH_NAME_0"));
        pathDetails.setShowActionHelpText(Messages.get().container("GUI_CATEGORIES_DETAIL_SHOW_PATH_HELP_0"));
        pathDetails.setHideActionName(Messages.get().container("GUI_CATEGORIES_DETAIL_HIDE_PATH_NAME_0"));
        pathDetails.setHideActionHelpText(Messages.get().container("GUI_CATEGORIES_DETAIL_HIDE_PATH_HELP_0"));
        pathDetails.setName(Messages.get().container("GUI_CATEGORIES_DETAIL_PATH_NAME_0"));
        pathDetails.setFormatter(new I_CmsListFormatter(){

            @Override
            public String format(Object data, Locale locale) {
                StringBuffer html = new StringBuffer(512);
                html.append("<table border='0' cellspacing='0' cellpadding='0'>\n");
                html.append("\t<tr>\n");
                html.append("\t\t<td style='white-space:normal;' >\n");
                html.append("\t\t\t");
                html.append(data == null ? "" : data);
                html.append("\n");
                html.append("\t\t</td>\n");
                html.append("\t</tr>\n");
                html.append("</table>\n");
                return html.toString();
            }
        });
        metadata.addItemDetails(pathDetails);
        CmsListItemDetails descriptionDetails = new CmsListItemDetails(LIST_DETAIL_DESCRIPTION);
        descriptionDetails.setAtColumn(LIST_COLUMN_NAME);
        descriptionDetails.setVisible(false);
        descriptionDetails.setShowActionName(Messages.get().container("GUI_CATEGORIES_DETAIL_SHOW_DESCRIPTION_NAME_0"));
        descriptionDetails.setShowActionHelpText(Messages.get().container("GUI_CATEGORIES_DETAIL_SHOW_DESCRIPTION_HELP_0"));
        descriptionDetails.setHideActionName(Messages.get().container("GUI_CATEGORIES_DETAIL_HIDE_DESCRIPTION_NAME_0"));
        descriptionDetails.setHideActionHelpText(Messages.get().container("GUI_CATEGORIES_DETAIL_HIDE_DESCRIPTION_HELP_0"));
        descriptionDetails.setName(Messages.get().container("GUI_CATEGORIES_DETAIL_DESCRIPTION_NAME_0"));
        descriptionDetails.setFormatter(new I_CmsListFormatter(){

            @Override
            public String format(Object data, Locale locale) {
                StringBuffer html = new StringBuffer(512);
                html.append("<table border='0' cellspacing='0' cellpadding='0'>\n");
                html.append("\t<tr>\n");
                html.append("\t\t<td style='white-space:normal;' >\n");
                html.append("\t\t\t");
                html.append(data == null ? "" : data);
                html.append("\n");
                html.append("\t\t</td>\n");
                html.append("\t</tr>\n");
                html.append("</table>\n");
                return html.toString();
            }
        });
        metadata.addItemDetails(descriptionDetails);
    }

    @Override
    protected void setMultiActions(CmsListMetadata metadata) {
    }

    protected abstract void setStateActionCol(CmsListMetadata var1);
}

