/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;

public class CmsCopyToProject
extends CmsDialog {
    public static final int ACTION_COPYTOPROJECT = 100;
    public static final String DIALOG_TYPE = "copytoproject";
    private static final Log LOG = CmsLog.getLog(CmsCopyToProject.class);

    public CmsCopyToProject(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsCopyToProject(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCopyToProject() throws JspException {
        this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
        try {
            this.getCms().copyResourceToProject(this.getParamResource());
            this.actionCloseDialog();
        }
        catch (Throwable e) {
            this.includeErrorpage((CmsWorkplace)this, e);
        }
    }

    public String buildProjectInformation() {
        String resName;
        StringBuffer result;
        block10: {
            block9: {
                result = new StringBuffer(32);
                try {
                    Object[] localizedObject = new String[]{this.getCms().getRequestContext().getCurrentProject().getName()};
                    List resources = this.getCms().readProjectResources(this.getCms().getRequestContext().getCurrentProject());
                    Iterator i = resources.iterator();
                    result.append(this.dialogBlockStart(this.key("GUI_COPYTOPROJECT_RESOURCES_0")));
                    if (resources.size() > 0) {
                        result.append(this.key("GUI_COPYTOPROJECT_PART_1", localizedObject));
                        result.append("<ul style=\"margin-top: 3px; margin-bottom: 3px;\">\n");
                        String siteRoot = this.getCms().getRequestContext().getSiteRoot();
                        while (i.hasNext()) {
                            String resName2 = (String)i.next();
                            if (resName2.startsWith(siteRoot)) {
                                resName2 = resName2.substring(siteRoot.length());
                            }
                            result.append("\t<li>");
                            result.append(resName2);
                            result.append("</li>\n");
                        }
                        result.append("</ul>\n");
                    } else {
                        result.append(this.key("GUI_COPYTOPROJECT_NOPART_1", localizedObject));
                    }
                    result.append(this.dialogBlockEnd());
                    result.append(this.dialogSpacer());
                }
                catch (CmsException e) {
                    if (!LOG.isInfoEnabled()) break block9;
                    LOG.info((Object)e.getLocalizedMessage());
                }
            }
            resName = this.getParamResource();
            try {
                CmsResource res = this.getCms().readResource(this.getParamResource(), CmsResourceFilter.ALL);
                if (res.isFolder() && !resName.endsWith("/")) {
                    resName = resName + "/";
                }
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) break block10;
                LOG.info((Object)e.getLocalizedMessage());
            }
        }
        Object[] localizedObject = new String[]{resName, this.getCms().getRequestContext().getCurrentProject().getName()};
        result.append(this.key("GUI_COPYTOPROJECT_PROJECT_CONFIRMATION_2", localizedObject));
        return result.toString();
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        this.setParamDialogtype(DIALOG_TYPE);
        if (DIALOG_TYPE.equals(this.getParamAction())) {
            this.setAction(100);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else {
            this.setAction(0);
            this.setParamTitle(this.key("GUI_COPYTOPROJECT_TITLE_0"));
        }
    }
}

