/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.opencms.file.CmsResource;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationDeleteValidator;
import org.opencms.relations.CmsRelationValidatorInfoEntry;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.commons.CmsDeleteBrokenRelationsCollector;
import org.opencms.workplace.commons.Messages;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.workplace.list.A_CmsListExplorerDialog;
import org.opencms.workplace.list.A_CmsListIndependentJsAction;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListIndependentAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.I_CmsListAction;
import org.opencms.workplace.list.I_CmsListResourceCollector;

public class CmsDeleteBrokenRelationsList
extends A_CmsListExplorerDialog {
    public static final String LIST_DETAIL_RELATIONS = "dr";
    public static final String LIST_DETAIL_RELATIONS_PRINT = "drp";
    public static final String LIST_DETAIL_RELATIONS_HIDE = "drh";
    public static final String LIST_DETAIL_RELATIONS_SHOW = "drs";
    public static final String LIST_ID = "dbr";
    private I_CmsListResourceCollector m_collector;
    private CmsRelationDeleteValidator m_validator;

    public CmsDeleteBrokenRelationsList(CmsJspActionElement jsp, List<String> resources, boolean includeSiblings) {
        super(jsp, LIST_ID, Messages.get().container("GUI_DELETE_BROKENRELATIONS_LIST_NAME_0"));
        String relativeTo = CmsResource.getParentFolder((String)resources.get(0));
        this.m_validator = new CmsRelationDeleteValidator(this.getCms(), resources, includeSiblings);
        ArrayList<String> resourceList = new ArrayList<String>(this.m_validator.keySet());
        Collections.sort(resourceList);
        this.m_collector = new CmsDeleteBrokenRelationsCollector(this, resourceList);
        this.getList().setMaxItemsPerPage(Integer.MAX_VALUE);
        CmsResourceUtil resUtil = this.getResourceUtil();
        resUtil.setAbbrevLength(50);
        resUtil.setRelativeTo(this.getCms().getRequestContext().addSiteRoot(relativeTo));
        resUtil.setSiteMode(CmsResourceUtil.SITE_MODE_MATCHING);
    }

    @Override
    public void executeListMultiActions() {
        this.throwListUnsupportedActionException();
    }

    @Override
    public void executeListSingleActions() {
        this.throwListUnsupportedActionException();
    }

    @Override
    public I_CmsListResourceCollector getCollector() {
        return this.m_collector;
    }

    public CmsRelationDeleteValidator getValidator() {
        return this.m_validator;
    }

    @Override
    protected void fillDetails(String detailId) {
        for (CmsListItem item : this.getList().getAllContent()) {
            String resourceName = this.getResourceUtil(item).getResource().getRootPath();
            StringBuffer html = new StringBuffer(128);
            if (!detailId.equals(LIST_DETAIL_RELATIONS) && !detailId.equals(LIST_DETAIL_RELATIONS_PRINT)) continue;
            CmsRelationValidatorInfoEntry infoEntry = this.m_validator.getInfoEntry(resourceName);
            Iterator itRelations = infoEntry.getRelations().iterator();
            while (itRelations.hasNext()) {
                CmsRelation relation = (CmsRelation)itRelations.next();
                String relationName = relation.getSourcePath();
                if (relationName.startsWith(infoEntry.getSiteRoot())) {
                    relationName = relationName.substring(infoEntry.getSiteRoot().length());
                    if (detailId.equals(LIST_DETAIL_RELATIONS)) {
                        relationName = CmsStringUtil.formatResourceName((String)relationName, (int)50);
                    }
                } else {
                    String site;
                    String siteName = site = OpenCms.getSiteManager().getSiteRoot(relationName);
                    if (site != null) {
                        relationName = relationName.substring(site.length());
                        siteName = OpenCms.getSiteManager().getSiteForSiteRoot(site).getTitle();
                    } else {
                        siteName = "/";
                    }
                    if (detailId.equals(LIST_DETAIL_RELATIONS)) {
                        relationName = CmsStringUtil.formatResourceName((String)relationName, (int)50);
                    }
                    relationName = this.key("GUI_DELETE_SITE_RELATION_2", new Object[]{siteName, relationName});
                }
                html.append(relationName);
                html.append("&nbsp;<span style='color: #666666;'>(");
                html.append(relation.getType().getLocalizedName(this.getMessages()));
                html.append(")</span>");
                if (itRelations.hasNext()) {
                    html.append("<br>");
                }
                html.append("\n");
            }
            item.set(detailId, html.toString());
        }
    }

    @Override
    protected List<CmsListItem> getListItems() throws CmsException {
        String storedSiteRoot = this.getCms().getRequestContext().getSiteRoot();
        try {
            this.getCms().getRequestContext().setSiteRoot("");
            List<CmsListItem> list = super.getListItems();
            return list;
        }
        finally {
            this.getCms().getRequestContext().setSiteRoot(storedSiteRoot);
        }
    }

    @Override
    protected boolean isColumnVisible(int colFlag) {
        boolean isVisible = colFlag == 1;
        isVisible = isVisible || colFlag == "ecti".hashCode();
        isVisible = isVisible || colFlag == "ecli".hashCode();
        isVisible = isVisible || colFlag == "ecpi".hashCode();
        isVisible = isVisible || colFlag == "ecn".hashCode();
        isVisible = isVisible || colFlag == "ecsi".hashCode() && OpenCms.getSiteManager().getSites().size() > 1;
        return isVisible;
    }

    @Override
    protected void setColumns(CmsListMetadata metadata) {
        super.setColumns(metadata);
        for (CmsListColumnDefinition colDefinition : metadata.getColumnDefinitions()) {
            colDefinition.setSorteable(false);
            if (!colDefinition.getId().equals("ecn")) continue;
            colDefinition.removeDefaultAction("edo");
            colDefinition.setWidth("60%");
        }
    }

    @Override
    protected void setIndependentActions(CmsListMetadata metadata) {
        abstract class DetailsJsAction
        extends A_CmsListIndependentJsAction {
            public DetailsJsAction(String id) {
                super(id);
            }

            @Override
            public String buttonHtml(CmsWorkplace wp) {
                StringBuffer html = new StringBuffer(1024);
                html.append("\t<span id='");
                html.append(this.getId());
                html.append("' class=\"link");
                html.append("\"");
                html.append(" onClick=\"");
                html.append(this.resolveOnClic(wp));
                html.append("\"");
                html.append(">");
                html.append("<img src='");
                html.append(CmsWorkplace.getSkinUri());
                html.append(this.getIconPath());
                html.append("'");
                html.append(" alt='");
                html.append(this.getName().key(wp.getLocale()));
                html.append("'");
                html.append(" title='");
                html.append(this.getName().key(wp.getLocale()));
                html.append("'");
                html.append(">");
                html.append("&nbsp;");
                html.append("<a href='#'>");
                html.append(this.getName().key(wp.getLocale()));
                html.append("</a>");
                html.append("</span>");
                return html.toString();
            }
        }
        DetailsJsAction hideAction = new DetailsJsAction(LIST_DETAIL_RELATIONS_HIDE){
            {
                super(id);
            }

            @Override
            public String jsCode(CmsWorkplace wp) {
                return "javascript:showBrokenLinks(false);";
            }
        };
        hideAction.setIconPath("list/details_hide.png");
        hideAction.setName(Messages.get().container("GUI_DELETE_BROKENRELATIONS_DETAIL_HIDE_RELATIONS_NAME_0"));
        hideAction.setHelpText(Messages.get().container("GUI_DELETE_BROKENRELATIONS_DETAIL_HIDE_RELATIONS_HELP_0"));
        metadata.addIndependentAction(hideAction);
        DetailsJsAction showAction = new DetailsJsAction(LIST_DETAIL_RELATIONS_SHOW){
            {
                super(id);
            }

            @Override
            public String jsCode(CmsWorkplace wp) {
                return "javascript:showBrokenLinks(true);";
            }
        };
        showAction.setIconPath("list/details_show.png");
        showAction.setName(Messages.get().container("GUI_DELETE_BROKENRELATIONS_DETAIL_SHOW_RELATIONS_NAME_0"));
        showAction.setHelpText(Messages.get().container("GUI_DELETE_BROKENRELATIONS_DETAIL_SHOW_RELATIONS_HELP_0"));
        metadata.addIndependentAction(showAction);
        CmsListItemDetails relationsDetails = new CmsListItemDetails(LIST_DETAIL_RELATIONS){

            @Override
            public I_CmsListAction getAction() {
                return new CmsListIndependentAction("hide"){

                    @Override
                    public String buttonHtml(CmsWorkplace wp) {
                        return "";
                    }
                };
            }
        };
        relationsDetails.setAtColumn("ecn");
        relationsDetails.setVisible(true);
        relationsDetails.setPrintable(false);
        relationsDetails.setFormatter(new CmsListItemDetailsFormatter(Messages.get().container("GUI_DELETE_BROKENRELATIONS_LABEL_RELATIONS_0")));
        relationsDetails.setShowActionName(Messages.get().container("GUI_DELETE_BROKENRELATIONS_DETAIL_SHOW_RELATIONS_NAME_0"));
        relationsDetails.setShowActionHelpText(Messages.get().container("GUI_DELETE_BROKENRELATIONS_DETAIL_SHOW_RELATIONS_HELP_0"));
        relationsDetails.setHideActionName(Messages.get().container("GUI_DELETE_BROKENRELATIONS_DETAIL_HIDE_RELATIONS_NAME_0"));
        relationsDetails.setHideActionHelpText(Messages.get().container("GUI_DELETE_BROKENRELATIONS_DETAIL_HIDE_RELATIONS_HELP_0"));
        metadata.addItemDetails(relationsDetails);
        CmsListItemDetails relationsDetailsPrint = new CmsListItemDetails(LIST_DETAIL_RELATIONS_PRINT){

            @Override
            public I_CmsListAction getAction() {
                return new CmsListIndependentAction("hide"){

                    @Override
                    public String buttonHtml(CmsWorkplace wp) {
                        return "";
                    }
                };
            }
        };
        relationsDetailsPrint.setAtColumn("crp");
        relationsDetailsPrint.setVisible(false);
        relationsDetailsPrint.setPrintable(true);
        relationsDetailsPrint.setFormatter(new CmsListItemDetailsFormatter(Messages.get().container("GUI_DELETE_BROKENRELATIONS_LABEL_RELATIONS_0")));
        metadata.addItemDetails(relationsDetailsPrint);
    }

    @Override
    protected void setMultiActions(CmsListMetadata metadata) {
        metadata.setSearchAction(null);
    }
}

