/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;

public class CmsDialogMultiPropertyEdit
extends CmsDialog {
    public static final int ACTION_MULTIFILEPROPERTYEDIT = 100;
    public static final String DIALOG_TYPE = "multifilepropertyedit";
    public static final String PREFIX_DESCRIPTION = "desc_";
    private static final Log LOG = CmsLog.getLog(CmsDialogMultiPropertyEdit.class);

    public CmsDialogMultiPropertyEdit(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsDialogMultiPropertyEdit(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommentImages() throws JspException {
        this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
        try {
            this.performDialogOperation();
            this.actionCloseDialog();
        }
        catch (Throwable e) {
            this.includeErrorpage((CmsWorkplace)this, e);
        }
    }

    public String buildDialogForm() {
        StringBuffer result = new StringBuffer(16384);
        List<CmsResource> resources = this.getResources();
        int amountOfInputFields = 4 * resources.size();
        int height = amountOfInputFields * 25;
        height += resources.size() * 30;
        height += 80;
        height = Math.min(height, 600);
        Iterator<CmsResource> i = resources.iterator();
        result.append("<div style=\"height: ").append(height).append("px; padding: 4px; overflow: auto;\">");
        while (i.hasNext()) {
            CmsResource res = i.next();
            I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(res);
            CmsExplorerTypeSettings settings = this.getSettingsForType(type.getTypeName());
            List editProperties = settings.getProperties();
            if (editProperties.size() > 0) {
                String iconPath = CmsDialogMultiPropertyEdit.getSkinUri() + "filetypes/" + settings.getIcon();
                String imageName = res.getName();
                String propertySuffix = "" + imageName.hashCode();
                result.append(this.dialogBlockStart("<img src=\"" + iconPath + "\"/>&nbsp;" + imageName));
                result.append("<table border=\"0\">\n");
                for (String property : editProperties) {
                    String title;
                    block6: {
                        result.append("<tr>\n");
                        result.append("<td>&nbsp;</td>\n");
                        title = "";
                        try {
                            title = this.getCms().readPropertyObject(res, property, false).getValue();
                        }
                        catch (CmsException e) {
                            if (!LOG.isErrorEnabled()) break block6;
                            LOG.error((Object)e.getLocalizedMessage(this.getLocale()));
                        }
                    }
                    result.append("<td style=\"white-space: nowrap;\" unselectable=\"on\" width=\"15%\">");
                    result.append(property).append(": ");
                    result.append("</td>\n");
                    result.append("<td class=\"maxwidth\">");
                    result.append("<input type=\"text\" class=\"maxwidth\" name=\"");
                    result.append(property);
                    result.append(propertySuffix);
                    result.append("\" value=\"");
                    if (CmsStringUtil.isNotEmpty((String)title)) {
                        result.append(CmsEncoder.escapeXml((String)title));
                    }
                    result.append("\"");
                    result.append(">");
                    result.append("</td>\n</tr>\n");
                }
                result.append("</table>\n");
                result.append(this.dialogBlockEnd());
            }
            if (!i.hasNext()) continue;
            result.append(this.dialogSpacer());
        }
        result.append("</div>");
        return result.toString();
    }

    protected List<CmsResource> getResources() {
        List result;
        block2: {
            result = Collections.emptyList();
            CmsResourceFilter filter = CmsResourceFilter.DEFAULT;
            try {
                CmsObject cms = this.getCms();
                result = cms.readResources(this.getParamResource(), filter, false);
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)e.getLocalizedMessage(this.getLocale()));
            }
        }
        return result;
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        if (!this.checkResourcePermissions(CmsPermissionSet.ACCESS_WRITE, false)) {
            this.setParamAction("cancel");
        }
        this.setParamDialogtype(DIALOG_TYPE);
        if (DIALOG_TYPE.equals(this.getParamAction())) {
            this.setAction(100);
        } else if ("locksconfirmed".equals(this.getParamAction())) {
            this.setAction(99);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else {
            this.setAction(0);
            Object[] args = new Object[]{this.getParamResource()};
            this.setParamTitle(this.key("GUI_MULTIFILE_PROPERTY_TITLE_1", args));
        }
    }

    protected boolean performDialogOperation() throws CmsException {
        this.checkLock(this.getParamResource());
        for (CmsResource res : this.getResources()) {
            String imageName = res.getName();
            String propertySuffix = "" + imageName.hashCode();
            I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(res);
            CmsExplorerTypeSettings settings = this.getSettingsForType(type.getTypeName());
            for (String property : settings.getProperties()) {
                CmsProperty currProperty = this.getCms().readPropertyObject(res, property, false);
                String newValue = this.getJsp().getRequest().getParameter(property + propertySuffix);
                this.writeProperty(res, property, newValue, currProperty);
            }
        }
        CmsObject cms = this.getCms();
        cms.unlockResource(this.getParamResource());
        return true;
    }

    protected void writeProperty(CmsResource res, String propName, String propValue, CmsProperty currentProperty) throws CmsException {
        CmsProperty prop = currentProperty;
        if (prop.isNullProperty()) {
            prop = new CmsProperty();
            prop.setName(propName);
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)propValue)) {
            boolean writeProperty = false;
            if (prop.getStructureValue() != null) {
                prop.setStructureValue("");
                prop.setResourceValue(null);
                writeProperty = true;
            } else if (prop.getResourceValue() != null) {
                prop.setResourceValue("");
                prop.setStructureValue(null);
                writeProperty = true;
            }
            if (writeProperty) {
                this.getCms().writePropertyObject(this.getCms().getSitePath(res), prop);
            }
        } else if (!propValue.equals(prop.getValue())) {
            if (prop.getStructureValue() == null && prop.getResourceValue() == null) {
                if (OpenCms.getWorkplaceManager().isDefaultPropertiesOnStructure()) {
                    prop.setStructureValue(propValue);
                    prop.setResourceValue(null);
                } else {
                    prop.setResourceValue(propValue);
                    prop.setStructureValue(null);
                }
            } else if (prop.getStructureValue() != null) {
                prop.setStructureValue(propValue);
                prop.setResourceValue(null);
            } else {
                prop.setResourceValue(propValue);
                prop.setStructureValue(null);
            }
            this.getCms().writePropertyObject(this.getCms().getSitePath(res), prop);
        }
    }

    private CmsExplorerTypeSettings getSettingsForType(String resTypeName) {
        CmsExplorerTypeSettings settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(resTypeName);
        if (!settings.hasEditOptions() && CmsStringUtil.isNotEmpty((String)settings.getReference())) {
            settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(settings.getReference());
        }
        return settings;
    }
}

