/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.history.I_CmsHistoryResource;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.commons.Messages;

public class CmsDisplayResource
extends CmsDialog {
    public static final String PARAM_VERSION = "version";
    private static final Log LOG = CmsLog.getLog(CmsDisplayResource.class);
    private String m_paramVersion;

    public CmsDisplayResource(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsDisplayResource(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] getHistoricalResourceContent(CmsObject cms, String resource, String version) {
        if (CmsStringUtil.isNotEmpty((String)resource) && CmsStringUtil.isNotEmpty((String)version)) {
            I_CmsHistoryResource res = null;
            String storedSiteRoot = cms.getRequestContext().getSiteRoot();
            try {
                cms.getRequestContext().setSiteRoot("/");
                res = cms.readResource(cms.readResource(resource, CmsResourceFilter.ALL).getStructureId(), Integer.parseInt(version));
            }
            catch (CmsException e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)e.getLocalizedMessage());
                }
                byte[] byArray = "".getBytes();
                return byArray;
            }
            finally {
                cms.getRequestContext().setSiteRoot(storedSiteRoot);
            }
            if (res.isFile()) {
                byte[] historyResourceContent = ((CmsFile)res).getContents();
                if (historyResourceContent == null || historyResourceContent.length == 0) {
                    try {
                        CmsFile file = cms.readFile((CmsResource)res);
                        historyResourceContent = file.getContents();
                    }
                    catch (CmsException cmsException) {
                        // empty catch block
                    }
                }
                historyResourceContent = CmsEncoder.changeEncoding((byte[])historyResourceContent, (String)OpenCms.getSystemInfo().getDefaultEncoding(), (String)cms.getRequestContext().getEncoding());
                return historyResourceContent;
            }
        }
        return "".getBytes();
    }

    public void actionShow() throws Exception {
        if (CmsStringUtil.isNotEmpty((String)this.getParamVersion())) {
            this.showHistoricVersion();
        } else {
            String url;
            String resourceStr = this.getParamResource();
            CmsResource resource = this.readResource(resourceStr);
            if (this.isDeleted(resource)) {
                throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_RESOURCE_DELETED_2", (Object)resourceStr, (Object)this.getCms().getRequestContext().getCurrentProject().getName()));
            }
            this.autoTimeWarp(resource);
            if (OpenCms.getSiteManager().isSharedFolder(this.getCms().getRequestContext().getSiteRoot()) && !OpenCms.getSiteManager().startsWithShared(resourceStr)) {
                resourceStr = CmsStringUtil.joinPaths((String[])new String[]{OpenCms.getSiteManager().getSharedFolder(), resourceStr});
            }
            if ((url = this.getJsp().link(resourceStr)).indexOf("://") < 0 && this.getCms().getRequestContext().getCurrentProject().isOnlineProject()) {
                url = this.prependSiteRoot(url);
            }
            this.getJsp().getResponse().sendRedirect(url);
        }
    }

    public String getParamVersion() {
        return this.m_paramVersion;
    }

    public void setParamVersionid(String paramVersion) {
        this.m_paramVersion = paramVersion;
    }

    protected void autoTimeWarp(CmsResource resource) throws CmsVfsResourceNotFoundException {
        long surfTime = this.getCms().getRequestContext().getRequestTime();
        if (resource.isReleasedAndNotExpired(surfTime)) {
            return;
        }
        if (this.getSettings().getUserSettings().getTimeWarp() == -1L) {
            long timeWarp = resource.isExpired(surfTime) ? resource.getDateExpired() - 1L : (!resource.isReleased(surfTime) ? resource.getDateReleased() + 1L : -1L);
            if (timeWarp != -1L) {
                this.getSession().setAttribute("__org.opencms.main.CmsContextInfo#m_requestTime", (Object)new Long(timeWarp));
            }
        } else {
            throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_RESOURCE_OUTSIDE_TIMEWINDOW_1", (Object)this.getParamResource()));
        }
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(settings, request);
    }

    private boolean isDeleted(CmsResource resource) {
        return resource.getState().isDeleted();
    }

    private String prependSiteRoot(String url) {
        String site = this.getCms().getRequestContext().getSiteRoot();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)site) || OpenCms.getSiteManager().isSharedFolder(site)) {
            site = OpenCms.getSiteManager().getDefaultUri();
            if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)site) || OpenCms.getSiteManager().getSiteForSiteRoot(site) == null) {
                return OpenCms.getSiteManager().getWorkplaceServer() + url;
            }
            return OpenCms.getSiteManager().getSiteForSiteRoot(site).getUrl() + url;
        }
        return OpenCms.getSiteManager().getSiteForSiteRoot(site).getUrl() + url;
    }

    private CmsResource readResource(String resourceName) throws CmsException {
        CmsResource resource = null;
        try {
            resource = this.getCms().readResource(resourceName, CmsResourceFilter.ALL);
        }
        catch (CmsVfsResourceNotFoundException e) {
            throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_RESOURCE_DOES_NOT_EXIST_3", (Object)resourceName, (Object)this.getCms().getRequestContext().getCurrentProject().getName(), (Object)this.getCms().getRequestContext().getSiteRoot()), (Throwable)e);
        }
        return resource;
    }

    private void showHistoricVersion() {
        block3: {
            String resourceStr = this.getParamResource();
            byte[] result = CmsDisplayResource.getHistoricalResourceContent(this.getCms(), resourceStr, this.getParamVersion());
            if (result != null) {
                String contentType = OpenCms.getResourceManager().getMimeType(resourceStr, this.getCms().getRequestContext().getEncoding());
                HttpServletResponse res = this.getJsp().getResponse();
                HttpServletRequest req = this.getJsp().getRequest();
                res.setHeader("Content-Disposition", new StringBuffer("attachment; filename=\"").append(resourceStr).append("\"").toString());
                res.setContentLength(result.length);
                CmsFlexController controller = CmsFlexController.getController((ServletRequest)req);
                res = controller.getTopResponse();
                res.setContentType(contentType);
                try {
                    res.getOutputStream().write(result);
                    res.getOutputStream().flush();
                }
                catch (IOException e) {
                    if (!LOG.isInfoEnabled()) break block3;
                    LOG.info((Object)e.getLocalizedMessage());
                }
            }
        }
    }
}

