/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.commons.Messages;

public class CmsEditPointer
extends CmsDialog {
    public static final String DIALOG_TYPE = "newlink";
    public static final String PARAM_LINKTARGET = "linktarget";
    private String m_paramLinkTarget;

    public CmsEditPointer(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsEditPointer(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionChangeLinkTarget() throws JspException {
        try {
            this.checkLock(this.getParamResource());
            CmsFile editFile = this.getCms().readFile(this.getParamResource());
            editFile.setContents(this.getParamLinkTarget().getBytes());
            this.getCms().writeFile(editFile);
            this.actionCloseDialog();
        }
        catch (Throwable e) {
            this.setParamMessage(Messages.get().getBundle(this.getLocale()).key("ERR_CHANGE_LINK_TARGET_0"));
            this.includeErrorpage((CmsWorkplace)this, e);
        }
    }

    public String getOldTargetValue() throws JspException {
        String linkTarget = "";
        if (CmsStringUtil.isEmpty((String)this.getParamLinkTarget())) {
            try {
                CmsFile file = this.getCms().readFile(this.getParamResource());
                linkTarget = new String(file.getContents());
            }
            catch (Throwable e1) {
                this.setParamMessage(Messages.get().getBundle(this.getLocale()).key("ERR_GET_LINK_TARGET_1", (Object)this.getParamResource()));
                this.includeErrorpage((CmsWorkplace)this, e1);
            }
        }
        return CmsEncoder.escapeXml((String)linkTarget);
    }

    public String getParamLinkTarget() {
        return this.m_paramLinkTarget;
    }

    public void setParamLinkTarget(String linkTarget) {
        this.m_paramLinkTarget = linkTarget;
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        if (!this.checkResourcePermissions(CmsPermissionSet.ACCESS_WRITE, false)) {
            this.setParamAction("cancel");
        }
        this.setParamDialogtype(DIALOG_TYPE);
        if ("ok".equals(this.getParamAction())) {
            this.setAction(3);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else {
            this.setAction(0);
            this.setParamTitle(this.key("GUI_CHLINK_1", new Object[]{CmsResource.getName((String)this.getParamResource())}));
        }
    }
}

