/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationType;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.commons.CmsResourceLinkRelationList;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.workplace.list.A_CmsListExplorerDialog;
import org.opencms.workplace.list.A_CmsListResourceCollector;
import org.opencms.workplace.list.CmsListItem;

public class CmsListResourceLinkRelationCollector
extends A_CmsListResourceCollector {
    protected static final Log LOG = CmsLog.getLog(CmsListResourceLinkRelationCollector.class);
    private static final String COLLECTOR_NAME = "linkRelations";
    private boolean m_isSource;
    private String m_resource;

    public CmsListResourceLinkRelationCollector(A_CmsListExplorerDialog wp, String resource, boolean isSource) {
        super(wp);
        this.m_isSource = isSource;
        this.m_resource = resource;
    }

    public List<String> getCollectorNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(COLLECTOR_NAME);
        return names;
    }

    public String getResource() {
        return this.m_resource;
    }

    @Override
    public CmsResource getResource(CmsObject cms, CmsListItem item) {
        CmsResource res;
        block3: {
            CmsUUID id;
            String itemId = item.getId().startsWith(item.get("crt") + "_") ? item.getId().substring(item.getId().lastIndexOf("_") + 1) : item.getId();
            res = (CmsResource)this.m_resCache.get(itemId);
            if (res == null && !(id = new CmsUUID(item.getId())).isNullUUID()) {
                try {
                    res = cms.readResource(id, CmsResourceFilter.ALL);
                    this.m_resCache.put(itemId, res);
                }
                catch (CmsException e) {
                    if (!LOG.isErrorEnabled()) break block3;
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return res;
    }

    @Override
    public List<CmsResource> getResources(CmsObject cms, Map<String, String> params) {
        List relations;
        ArrayList<CmsResource> allResources;
        block9: {
            allResources = new ArrayList<CmsResource>();
            CmsRelationFilter filter = CmsRelationFilter.TARGETS;
            if (this.isSource()) {
                filter = CmsRelationFilter.SOURCES;
            }
            relations = new ArrayList();
            try {
                relations = cms.getRelationsForResource(this.getResource(), filter);
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) break block9;
                LOG.error((Object)e.getLocalizedMessage(this.getWp().getLocale()), (Throwable)e);
            }
        }
        HashMap<CmsResource, List<CmsRelationType>> relationTypes = new HashMap<CmsResource, List<CmsRelationType>>();
        ArrayList<String> brokenLinks = new ArrayList<String>();
        for (CmsRelation relation : relations) {
            CmsResource resource;
            block10: {
                resource = null;
                try {
                    resource = this.isSource() ? relation.getSource(cms, CmsResourceFilter.ALL) : relation.getTarget(cms, CmsResourceFilter.ALL);
                }
                catch (CmsException e) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)e.getLocalizedMessage(this.getWp().getLocale()), (Throwable)e);
                    }
                    if (brokenLinks.contains(resource = new CmsResource(new CmsUUID(), new CmsUUID(), relation.getTargetPath(), CmsResourceTypePlain.getStaticTypeId(), false, 0, this.getWp().getJsp().getRequestContext().getCurrentProject().getUuid(), CmsResourceState.STATE_DELETED, 0L, this.getWp().getJsp().getRequestContext().getCurrentUser().getId(), 0L, this.getWp().getJsp().getRequestContext().getCurrentUser().getId(), 0L, 0L, 0, 0, 0L, 0))) break block10;
                    brokenLinks.add(relation.getType().getLocalizedName(this.getWp().getJsp().getRequestContext().getLocale()) + "_" + resource.getStructureId());
                }
            }
            allResources.add(resource);
            if (relationTypes.containsKey(resource)) {
                ((List)relationTypes.get(resource)).add(relation.getType());
                continue;
            }
            ArrayList<CmsRelationType> types = new ArrayList<CmsRelationType>();
            types.add(relation.getType());
            relationTypes.put(resource, types);
        }
        if (this.getWp() instanceof CmsResourceLinkRelationList) {
            CmsResourceLinkRelationList wp = (CmsResourceLinkRelationList)this.getWp();
            wp.setRelationTypes(relationTypes);
            wp.setBrokenLinks(brokenLinks);
        }
        return allResources;
    }

    public boolean isSource() {
        return this.m_isSource;
    }

    public void setResource(String resource) {
        this.m_resource = resource;
    }

    public void setSource(boolean isSource) {
        this.m_isSource = isSource;
    }

    @Override
    protected void setAdditionalColumns(CmsListItem item, CmsResourceUtil resUtil) {
    }
}

