/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsException;
import org.opencms.file.CmsVfsResourceAlreadyExistsException;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.workplace.CmsMultiDialog;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.commons.Messages;

public class CmsMove
extends CmsMultiDialog {
    public static final int ACTION_MOVE = 100;
    public static final String DIALOG_TYPE = "move";
    private static final Log LOG = CmsLog.getLog(CmsMove.class);
    private String m_paramTarget;

    public CmsMove(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsMove(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionMove() throws JspException {
        block18: {
            this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
            try {
                boolean isFolder = false;
                String source = this.getResourceList().get(0);
                String target = CmsLinkManager.getAbsoluteUri((String)this.getParamTarget(), (String)CmsResource.getParentFolder((String)source));
                if (!this.isMultiOperation()) {
                    CmsResource resource = this.getCms().readResource(source, CmsResourceFilter.ALL);
                    isFolder = resource.isFolder();
                } else {
                    CmsResource resource;
                    String siteRootFolder = null;
                    try {
                        if (OpenCms.getSiteManager().getSiteRoot(target) != null) {
                            siteRootFolder = this.getCms().getRequestContext().getSiteRoot();
                            if (siteRootFolder.endsWith("/")) {
                                siteRootFolder = siteRootFolder.substring(0, siteRootFolder.length() - 1);
                            }
                            this.getCms().getRequestContext().setSiteRoot("/");
                        }
                        resource = this.getCms().readResource(target, CmsResourceFilter.ALL);
                    }
                    finally {
                        if (siteRootFolder != null) {
                            this.getCms().getRequestContext().setSiteRoot(siteRootFolder);
                        }
                    }
                    if (!resource.isFolder()) {
                        throw new CmsVfsException(Messages.get().container("ERR_MOVE_MULTI_TARGET_NOFOLDER_1", (Object)target));
                    }
                }
                if (this.performDialogOperation()) {
                    if (this.isMultiOperation() || isFolder) {
                        ArrayList<String> folderList;
                        block17: {
                            folderList = new ArrayList<String>(2);
                            String sourceParent = CmsResource.getParentFolder((String)source);
                            folderList.add(sourceParent);
                            try {
                                String targetParent = CmsResource.getParentFolder((String)target);
                                if (!targetParent.equals(sourceParent)) {
                                    folderList.add(targetParent);
                                }
                            }
                            catch (Exception e) {
                                if (!LOG.isInfoEnabled()) break block17;
                                LOG.info((Object)e);
                            }
                        }
                        this.getJsp().getRequest().setAttribute("__CmsWorkplace.RELOADTREE", folderList);
                    }
                    this.actionCloseDialog();
                    break block18;
                }
                this.getJsp().include("/system/workplace/commons/includes/wait.jsp");
            }
            catch (Throwable e) {
                this.includeErrorpage((CmsWorkplace)this, e);
            }
        }
    }

    public String getCurrentResourceName() {
        if (this.isMultiOperation()) {
            return "";
        }
        String resourceName = CmsResource.getName((String)this.getParamResource());
        if (resourceName.endsWith("/")) {
            resourceName = resourceName.substring(0, resourceName.length() - 1);
        }
        return resourceName;
    }

    public String getParamTarget() {
        return this.m_paramTarget;
    }

    public void setParamTarget(String value) {
        this.m_paramTarget = value;
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        if (!this.checkResourcePermissions(CmsPermissionSet.ACCESS_WRITE, false)) {
            this.setParamAction("cancel");
        }
        this.setParamDialogtype(DIALOG_TYPE);
        if (DIALOG_TYPE.equals(this.getParamAction())) {
            this.setAction(100);
        } else if ("confirmed".equals(this.getParamAction())) {
            this.setAction(1);
        } else if ("wait".equals(this.getParamAction())) {
            this.setAction(2);
        } else if ("locksconfirmed".equals(this.getParamAction())) {
            this.setAction(99);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else {
            this.setAction(0);
            this.setDialogTitle("GUI_MOVE_RESOURCE_1", "GUI_MOVE_MULTI_2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean performDialogOperation() throws CmsException {
        boolean isFolder = this.isOperationOnFolder();
        if ((this.isMultiOperation() || isFolder) && !"wait".equals(this.getParamAction())) {
            return false;
        }
        String target = this.getParamTarget();
        if (target == null) {
            target = "";
        }
        String siteRootFolder = null;
        try {
            String sitePrefix = "";
            if (OpenCms.getSiteManager().getSiteRoot(target) != null) {
                siteRootFolder = this.getCms().getRequestContext().getSiteRoot();
                if (siteRootFolder.endsWith("/")) {
                    siteRootFolder = siteRootFolder.substring(0, siteRootFolder.length() - 1);
                }
                sitePrefix = siteRootFolder;
                this.getCms().getRequestContext().setSiteRoot("/");
            }
            for (String resName : this.getResourceList()) {
                try {
                    this.performSingleMoveOperation(resName, target, sitePrefix);
                }
                catch (CmsException e) {
                    if (!this.isMultiOperation()) throw e;
                    this.addMultiOperationException(e);
                }
            }
            this.checkMultiOperationException(Messages.get(), "ERR_MOVE_MULTI_0");
            if (siteRootFolder == null) return true;
        }
        catch (Throwable throwable) {
            if (siteRootFolder == null) throw throwable;
            this.getCms().getRequestContext().setSiteRoot(siteRootFolder);
            throw throwable;
        }
        this.getCms().getRequestContext().setSiteRoot(siteRootFolder);
        return true;
    }

    protected void performSingleMoveOperation(String source, String target, String sitePrefix) throws CmsException {
        String finalTarget;
        block7: {
            finalTarget = this.getCms().getRequestContext().getFileTranslator().translateResource(target);
            if ((finalTarget = CmsLinkManager.getAbsoluteUri((String)finalTarget, (String)CmsResource.getParentFolder((String)source))).equals(source) || this.isMultiOperation() && finalTarget.startsWith(source)) {
                throw new CmsVfsException(Messages.get().container("ERR_MOVE_ONTO_ITSELF_1", (Object)finalTarget));
            }
            try {
                CmsResource res = this.getCms().readResource(finalTarget, CmsResourceFilter.ALL);
                if (res.isFolder()) {
                    if (!finalTarget.endsWith("/")) {
                        finalTarget = finalTarget + "/";
                    }
                    if ((finalTarget = finalTarget + CmsResource.getName((String)source)).endsWith("/")) {
                        finalTarget = finalTarget.substring(0, finalTarget.length() - 1);
                    }
                }
            }
            catch (CmsVfsResourceNotFoundException e) {
                if (!LOG.isInfoEnabled()) break block7;
                LOG.info((Object)e.getLocalizedMessage());
            }
        }
        this.setParamTarget(finalTarget);
        if (this.getCms().existsResource(finalTarget, CmsResourceFilter.ALL)) {
            throw new CmsVfsResourceAlreadyExistsException(Messages.get().container("ERR_MOVE_FAILED_TARGET_EXISTS_2", (Object)source, (Object)this.getJsp().getRequestContext().removeSiteRoot(finalTarget)));
        }
        this.checkLock(sitePrefix + source);
        this.getCms().moveResource(sitePrefix + source, finalTarget);
    }
}

