/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.relations.CmsCategory;
import org.opencms.workplace.commons.A_CmsResourceCategoriesList;
import org.opencms.workplace.commons.Messages;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.I_CmsListFormatter;

public class CmsNotResourceCategoriesList
extends A_CmsResourceCategoriesList {
    public static final String LIST_ACTION_ADD = "aa";
    public static final String LIST_ID = "lnrc";

    public CmsNotResourceCategoriesList(CmsJspActionElement jsp) {
        this(jsp, LIST_ID);
    }

    public CmsNotResourceCategoriesList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    protected CmsNotResourceCategoriesList(CmsJspActionElement jsp, String listId) {
        super(jsp, listId, Messages.get().container("GUI_NOTRESOURCECATEGORIES_LIST_NAME_0"), true);
    }

    @Override
    public void executeListSingleActions() throws CmsRuntimeException {
        if (this.getParamListAction().equals(LIST_ACTION_ADD)) {
            try {
                this.checkLock(this.getParamResource());
                CmsListItem listItem = this.getSelectedItem();
                this.getCategoryService().addResourceToCategory(this.getCms(), this.getParamResource(), listItem.getId());
                this.getCategoryService().repairRelations(this.getCms(), this.getParamResource());
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(e.getMessageContainer(), (Throwable)e);
            }
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    @Override
    protected String defaultActionHtmlStart() {
        return this.getList().listJs() + this.dialogContentStart(this.getParamTitle());
    }

    @Override
    protected List<CmsCategory> getCategories() throws CmsException {
        List<CmsCategory> resourceRelations = this.getResourceCategories();
        List result = this.getCategoryService().readCategories(this.getJsp().getCmsObject(), null, true, this.getParamResource());
        for (CmsCategory category : resourceRelations) {
            if (!result.contains(category) || !resourceRelations.containsAll(this.getCategoryService().readCategories(this.getJsp().getCmsObject(), category.getPath(), true, this.getParamResource()))) continue;
            result.remove(category);
        }
        return result;
    }

    @Override
    protected void setColumns(CmsListMetadata metadata) {
        super.setColumns(metadata);
        metadata.getColumnDefinition("cn").setFormatter(new I_CmsListFormatter(){

            @Override
            public String format(Object data, Locale locale) {
                CmsListColumnDefinition listColumnDefinition = CmsNotResourceCategoriesList.this.getList().getMetadata().getColumnDefinition("cs");
                CmsListDirectAction stateAction = (CmsListDirectAction)listColumnDefinition.getDirectAction(CmsNotResourceCategoriesList.LIST_ACTION_ADD);
                if (!stateAction.isEnabled()) {
                    StringBuffer ret = new StringBuffer();
                    ret.append("<span style=\"color: graytext;\">");
                    ret.append(data);
                    ret.append("</span>");
                    return ret.toString();
                }
                return (String)data;
            }
        });
    }

    @Override
    protected void setStateActionCol(CmsListMetadata metadata) {
        CmsListColumnDefinition stateCol = new CmsListColumnDefinition("cs");
        stateCol.setName(Messages.get().container("GUI_CATEGORIES_LIST_COLS_STATE_0"));
        stateCol.setHelpText(Messages.get().container("GUI_CATEGORIES_LIST_COLS_STATE_HELP_0"));
        stateCol.setWidth("20");
        stateCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        stateCol.setSorteable(false);
        CmsListDirectAction stateAction = new CmsListDirectAction(LIST_ACTION_ADD){

            public boolean isEnabled() {
                try {
                    A_CmsResourceCategoriesList wp = (A_CmsResourceCategoriesList)this.getWp();
                    if (wp.getResourceCategories().contains(wp.getCategoryService().readCategory(wp.getCms(), this.getItem().getId(), wp.getParamResource()))) {
                        return false;
                    }
                }
                catch (CmsException cmsException) {
                    // empty catch block
                }
                return true;
            }
        };
        stateAction.setName(Messages.get().container("GUI_CATEGORIES_LIST_DEFACTION_ADD_NAME_0"));
        stateAction.setHelpText(Messages.get().container("GUI_CATEGORIES_LIST_DEFACTION_ADD_HELP_0"));
        stateAction.setIconPath("list/add.png");
        stateCol.addDirectAction(stateAction);
        metadata.addColumn(stateCol);
    }
}

