/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsRole;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.commons.Messages;
import org.opencms.workplace.list.A_CmsListDefaultJsAction;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.CmsListSearchAction;
import org.opencms.workplace.tools.CmsToolMacroResolver;

public class CmsOrgUnitSelectionList
extends A_CmsListDialog {
    public static final String LIST_ACTION_ICON = "ai";
    public static final String LIST_ACTION_SELECT = "js";
    public static final String LIST_COLUMN_DESCRIPTION = "cd";
    public static final String LIST_COLUMN_ICON = "ci";
    public static final String LIST_COLUMN_PATH = "cp";
    public static final String LIST_ID = "lous";
    private String m_paramOufqn;
    private String m_paramRole;

    public CmsOrgUnitSelectionList(CmsJspActionElement jsp) {
        super(jsp, LIST_ID, Messages.get().container("GUI_ORGUNITSELECTION_LIST_NAME_0"), LIST_COLUMN_PATH, CmsListOrderEnum.ORDER_ASCENDING, null);
    }

    public CmsOrgUnitSelectionList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public String dialogTitle() {
        StringBuffer html = new StringBuffer(512);
        html.append("<div class='screenTitle'>\n");
        html.append("\t<table width='100%' cellspacing='0'>\n");
        html.append("\t\t<tr>\n");
        html.append("\t\t\t<td>\n");
        html.append(this.key("GUI_ORGUNITSELECTION_INTRO_TITLE_0"));
        html.append("\n\t\t\t</td>");
        html.append("\t\t</tr>\n");
        html.append("\t</table>\n");
        html.append("</div>\n");
        return CmsToolMacroResolver.resolveMacros((String)html.toString(), (CmsWorkplace)this);
    }

    @Override
    public void executeListMultiActions() {
        this.throwListUnsupportedActionException();
    }

    @Override
    public void executeListSingleActions() {
        this.throwListUnsupportedActionException();
    }

    public String getParamOufqn() {
        return this.m_paramOufqn;
    }

    public String getParamRole() {
        return this.m_paramRole;
    }

    public void setParamOufqn(String ouFqn) {
        if (ouFqn == null) {
            ouFqn = "";
        }
        this.m_paramOufqn = ouFqn;
    }

    public void setParamRole(String paramRole) {
        this.m_paramRole = paramRole;
    }

    @Override
    protected void fillDetails(String detailId) {
    }

    @Override
    protected List<CmsListItem> getListItems() throws CmsException {
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        for (CmsOrganizationalUnit orgUnit : this.getOrgUnits()) {
            CmsListItem item = this.getList().newItem(orgUnit.getName());
            item.set(LIST_COLUMN_DESCRIPTION, orgUnit.getDescription(this.getLocale()));
            item.set(LIST_COLUMN_PATH, "/" + orgUnit.getName());
            ret.add(item);
        }
        return ret;
    }

    protected List<CmsOrganizationalUnit> getOrgUnits() throws CmsException {
        String ou;
        ArrayList<CmsOrganizationalUnit> ret = new ArrayList<CmsOrganizationalUnit>();
        CmsRole role = null;
        if (this.getParamRole() != null) {
            role = CmsRole.valueOfGroupName((String)this.getParamRole());
        }
        if ((ou = this.getParamOufqn()) == null) {
            ou = "";
        }
        if (role != null) {
            ret.addAll(OpenCms.getRoleManager().getOrgUnitsForRole(this.getCms(), role.forOrgUnit(ou), true));
        } else {
            ret.addAll(OpenCms.getOrgUnitManager().getOrganizationalUnits(this.getCms(), ou, true));
        }
        return ret;
    }

    @Override
    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition iconCol = new CmsListColumnDefinition(LIST_COLUMN_ICON);
        iconCol.setName(Messages.get().container("GUI_ORGUNITSELECTION_LIST_COLS_ICON_0"));
        iconCol.setHelpText(Messages.get().container("GUI_ORGUNITSELECTION_LIST_COLS_ICON_HELP_0"));
        iconCol.setWidth("20");
        iconCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        iconCol.setSorteable(false);
        CmsListDirectAction iconAction = new CmsListDirectAction(LIST_ACTION_ICON);
        iconAction.setName(Messages.get().container("GUI_ORGUNITSELECTION_LIST_ICON_NAME_0"));
        iconAction.setHelpText(Messages.get().container("GUI_ORGUNITSELECTION_LIST_ICON_HELP_0"));
        iconAction.setIconPath("buttons/orgunit.png");
        iconAction.setEnabled(false);
        iconCol.addDirectAction(iconAction);
        metadata.addColumn(iconCol);
        CmsListColumnDefinition descCol = new CmsListColumnDefinition(LIST_COLUMN_DESCRIPTION);
        descCol.setName(Messages.get().container("GUI_ORGUNITSELECTION_LIST_COLS_DESCRIPTION_0"));
        descCol.setWidth("60%");
        A_CmsListDefaultJsAction selectAction = new A_CmsListDefaultJsAction(LIST_ACTION_SELECT){

            @Override
            public String jsCode() {
                return "window.opener.setOrgUnitFormValue('" + this.getItem().get(CmsOrgUnitSelectionList.LIST_COLUMN_PATH) + "'); window.opener.focus(); window.close();";
            }
        };
        selectAction.setName(Messages.get().container("GUI_ORGUNITSELECTION_LIST_ACTION_SELECT_NAME_0"));
        selectAction.setHelpText(Messages.get().container("GUI_ORGUNITSELECTION_LIST_ACTION_SELECT_HELP_0"));
        descCol.addDefaultAction(selectAction);
        metadata.addColumn(descCol);
        CmsListColumnDefinition pathCol = new CmsListColumnDefinition(LIST_COLUMN_PATH);
        pathCol.setName(Messages.get().container("GUI_ORGUNITSELECTION_LIST_COLS_PATH_0"));
        pathCol.setWidth("40%");
        pathCol.setTextWrapping(true);
        metadata.addColumn(pathCol);
    }

    @Override
    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListSearchAction searchAction = new CmsListSearchAction(metadata.getColumnDefinition(LIST_COLUMN_PATH));
        searchAction.addColumn(metadata.getColumnDefinition(LIST_COLUMN_DESCRIPTION));
        searchAction.setCaseInSensitive(true);
        metadata.setSearchAction(searchAction);
    }

    @Override
    protected void setMultiActions(CmsListMetadata metadata) {
    }

    @Override
    protected void validateParamaters() throws Exception {
        try {
            OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), this.getParamOufqn());
        }
        catch (Exception e) {
            this.setParamOufqn(null);
        }
    }
}

