/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.workplace.list.A_CmsListExplorerDialog;
import org.opencms.workplace.list.A_CmsListResourceCollector;
import org.opencms.workplace.list.CmsListItem;

public class CmsPublishBrokenRelationsCollector
extends A_CmsListResourceCollector {
    private static final Log LOG = CmsLog.getLog(CmsPublishBrokenRelationsCollector.class);
    public static final String COLLECTOR_NAME = "potentialBrokenResources";

    public CmsPublishBrokenRelationsCollector(A_CmsListExplorerDialog wp, List<String> resources) {
        super(wp);
        this.setResourcesParam(resources);
    }

    public List<String> getCollectorNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(COLLECTOR_NAME);
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CmsResource> getResources(CmsObject cms, Map<String, String> params) {
        String siteRoot = cms.getRequestContext().getSiteRoot();
        if (siteRoot == null) {
            siteRoot = "";
        }
        ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
        try {
            cms.getRequestContext().setSiteRoot("");
            for (String resName : this.getResourceNamesFromParam(params)) {
                try {
                    resources.add(cms.readResource(resName, CmsResourceFilter.ALL));
                }
                catch (CmsException e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        finally {
            cms.getRequestContext().setSiteRoot(siteRoot);
        }
        return resources;
    }

    @Override
    protected void setAdditionalColumns(CmsListItem item, CmsResourceUtil resUtil) {
    }
}

