/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.DataFormatException;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsPublishList;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.commons.CmsProgressThread;
import org.opencms.workplace.commons.Messages;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.workplace.list.A_CmsListExplorerDialog;
import org.opencms.workplace.list.A_CmsListIndependentJsAction;
import org.opencms.workplace.list.A_CmsListResourceCollector;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListExplorerColumn;
import org.opencms.workplace.list.CmsListIndependentAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListResourceProjStateAction;
import org.opencms.workplace.list.I_CmsListAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.list.I_CmsListResourceCollector;

public class CmsPublishResourcesList
extends A_CmsListExplorerDialog {
    public static final String LIST_DETAIL_RELATIONS = "dr";
    public static final String LIST_DETAIL_RELATIONS_HIDE = "drh";
    public static final String LIST_DETAIL_RELATIONS_SHOW = "drs";
    public static final String LIST_ID = "pr";
    protected static final String LIST_COLUMN_IS_RELATED = "ecir";
    protected static final Log LOG = CmsLog.getLog(CmsPublishResourcesList.class);
    protected CmsPublishList m_publishList;
    protected boolean m_publishRelated;
    private I_CmsListResourceCollector m_collector;

    public CmsPublishResourcesList(CmsJspActionElement jsp, String relativeTo, boolean publishRelated) {
        super(jsp, LIST_ID, Messages.get().container("GUI_PUBLISH_RESOURCES_LIST_NAME_0"));
        this.getList().setMaxItemsPerPage(Integer.MAX_VALUE);
        CmsResourceUtil resUtil = this.getResourceUtil();
        resUtil.setAbbrevLength(50);
        resUtil.setRelativeTo(this.getCms().getRequestContext().addSiteRoot(relativeTo));
        resUtil.setSiteMode(CmsResourceUtil.SITE_MODE_MATCHING);
        this.m_publishRelated = publishRelated;
    }

    @Override
    public void executeListMultiActions() {
        this.throwListUnsupportedActionException();
    }

    @Override
    public void executeListSingleActions() {
        this.throwListUnsupportedActionException();
    }

    @Override
    public I_CmsListResourceCollector getCollector() {
        if (this.m_collector == null) {
            this.m_collector = new A_CmsListResourceCollector(this){
                private static final String COLLECTOR_NAME = "publishResources";

                public List<String> getCollectorNames() {
                    ArrayList<String> names = new ArrayList<String>();
                    names.add(COLLECTOR_NAME);
                    return names;
                }

                @Override
                public List<CmsResource> getResources(CmsObject cms, Map<String, String> params) {
                    if (CmsPublishResourcesList.this.m_publishRelated && CmsPublishResourcesList.this.getSettings().getPublishList().isDirectPublish()) {
                        try {
                            CmsPublishList mergedPL;
                            CmsPublishList relatedPL = OpenCms.getPublishManager().getRelatedResourcesToPublish(cms, CmsPublishResourcesList.this.getSettings().getPublishList());
                            CmsPublishResourcesList.this.m_publishList = mergedPL = OpenCms.getPublishManager().mergePublishLists(cms, CmsPublishResourcesList.this.getSettings().getPublishList(), relatedPL);
                        }
                        catch (CmsException e) {
                            if (LOG.isErrorEnabled()) {
                                LOG.error((Object)e.getLocalizedMessage(CmsPublishResourcesList.this.getLocale()), (Throwable)e);
                            }
                        }
                    } else {
                        CmsPublishResourcesList.this.m_publishList = CmsPublishResourcesList.this.getSettings().getPublishList();
                    }
                    return CmsPublishResourcesList.this.m_publishList.getAllResources();
                }

                @Override
                protected void setAdditionalColumns(CmsListItem item, CmsResourceUtil resUtil) {
                    item.set(CmsPublishResourcesList.LIST_COLUMN_IS_RELATED, !CmsPublishResourcesList.this.getSettings().getPublishList().getAllResources().contains(resUtil.getResource()));
                }
            };
        }
        return this.m_collector;
    }

    public CmsPublishList getPublishList() {
        return this.m_publishList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fillDetails(String detailId) {
        CmsObject cms;
        try {
            cms = OpenCms.initCmsObject((CmsObject)this.getCms());
        }
        catch (CmsException e) {
            cms = this.getCms();
        }
        CmsProgressThread thread = null;
        int progressOffset = 0;
        if (Thread.currentThread() instanceof CmsProgressThread) {
            thread = (CmsProgressThread)((Object)Thread.currentThread());
            progressOffset = thread.getProgress();
        }
        List publishResources = this.getSettings().getPublishList().getAllResources();
        ArrayList<CmsListItem> resourceNames = new ArrayList<CmsListItem>(this.getList().getAllContent());
        Iterator itResourceNames = resourceNames.iterator();
        int count = 0;
        while (itResourceNames.hasNext()) {
            ++count;
            if (thread != null) {
                if (thread.isInterrupted()) {
                    throw new CmsIllegalStateException(Messages.get().container("ERR_PROGRESS_INTERRUPTED_0"));
                }
                thread.setProgress(count * 10 / resourceNames.size() + progressOffset);
                thread.setDescription(Messages.get().getBundle(thread.getLocale()).key("GUI_PROGRESS_PUBLISH_STEP3_2", (Object)new Integer(count), (Object)new Integer(resourceNames.size())));
            }
            CmsListItem item = (CmsListItem)itResourceNames.next();
            try {
                ArrayList<String> relatedResources;
                block30: {
                    if (!detailId.equals(LIST_DETAIL_RELATIONS)) continue;
                    relatedResources = new ArrayList<String>();
                    CmsResource resource = this.getResourceUtil(item).getResource();
                    String rightSite = OpenCms.getSiteManager().getSiteRoot(resource.getRootPath());
                    if (rightSite == null) {
                        rightSite = "";
                    }
                    String oldSite = cms.getRequestContext().getSiteRoot();
                    try {
                        String siteName;
                        String site;
                        String relationName2;
                        cms.getRequestContext().setSiteRoot(rightSite);
                        for (CmsRelation relation : cms.getRelationsForResource(resource, CmsRelationFilter.TARGETS.filterStrong())) {
                            CmsResource target = null;
                            try {
                                target = relation.getTarget(cms, CmsResourceFilter.ALL);
                            }
                            catch (CmsVfsResourceNotFoundException cmsVfsResourceNotFoundException) {
                                // empty catch block
                            }
                            if (target == null || publishResources.contains(target) || target.getState().isUnchanged()) continue;
                            relationName2 = target.getRootPath();
                            if (relationName2.startsWith(cms.getRequestContext().getSiteRoot())) {
                                relationName2 = cms.getSitePath(target);
                                relationName2 = CmsStringUtil.formatResourceName((String)relationName2, (int)50);
                            } else {
                                siteName = site = OpenCms.getSiteManager().getSiteRoot(relationName2);
                                if (site != null) {
                                    relationName2 = relationName2.substring(site.length());
                                    siteName = OpenCms.getSiteManager().getSiteForSiteRoot(site).getTitle();
                                } else {
                                    siteName = "/";
                                }
                                relationName2 = CmsStringUtil.formatResourceName((String)relationName2, (int)50);
                                relationName2 = this.key("GUI_DELETE_SITE_RELATION_2", new Object[]{siteName, relationName2});
                            }
                            if (!cms.getLock(target).isLockableBy(cms.getRequestContext().getCurrentUser())) {
                                relationName2 = relationName2 + "*";
                            } else if (this.m_publishRelated) {
                                relationName2 = relationName2 + "!";
                            }
                            if (resourceNames.contains(relationName2)) continue;
                            relatedResources.add(relationName2);
                        }
                        if (!((Boolean)item.get(LIST_COLUMN_IS_RELATED)).booleanValue()) break block30;
                        for (CmsRelation relation : cms.getRelationsForResource(resource, CmsRelationFilter.SOURCES.filterStrong())) {
                            CmsResource source = null;
                            try {
                                source = relation.getSource(cms, CmsResourceFilter.ALL);
                            }
                            catch (CmsVfsResourceNotFoundException relationName2) {
                                // empty catch block
                            }
                            if (source == null || !publishResources.contains(source)) continue;
                            relationName2 = source.getRootPath();
                            if (relationName2.startsWith(cms.getRequestContext().getSiteRoot())) {
                                relationName2 = cms.getSitePath(source);
                                relationName2 = CmsStringUtil.formatResourceName((String)relationName2, (int)50);
                            } else {
                                siteName = site = OpenCms.getSiteManager().getSiteRoot(relationName2);
                                if (site != null) {
                                    relationName2 = relationName2.substring(site.length());
                                    siteName = OpenCms.getSiteManager().getSiteForSiteRoot(site).getTitle();
                                } else {
                                    siteName = "/";
                                }
                                relationName2 = CmsStringUtil.formatResourceName((String)relationName2, (int)50);
                                relationName2 = this.key("GUI_DELETE_SITE_RELATION_2", new Object[]{siteName, relationName2});
                            }
                            if (resourceNames.contains(relationName2 = relationName2 + "$")) continue;
                            relatedResources.add(relationName2);
                        }
                    }
                    finally {
                        cms.getRequestContext().setSiteRoot(oldSite);
                    }
                }
                if (relatedResources.isEmpty()) continue;
                item.set(detailId, relatedResources);
            }
            catch (CmsException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                item.set(detailId, e.getLocalizedMessage());
            }
        }
    }

    @Override
    protected boolean isColumnVisible(int colFlag) {
        boolean isVisible = colFlag == 1;
        isVisible = isVisible || colFlag == "ecti".hashCode();
        isVisible = isVisible || colFlag == "ecli".hashCode();
        isVisible = isVisible || colFlag == "ecpi".hashCode();
        isVisible = isVisible || colFlag == "ecn".hashCode();
        isVisible = isVisible || colFlag == "ecsi".hashCode() && OpenCms.getSiteManager().getSites().size() > 1;
        return isVisible;
    }

    @Override
    protected void setColumns(CmsListMetadata metadata) {
        super.setColumns(metadata);
        for (CmsListColumnDefinition colDefinition : metadata.getColumnDefinitions()) {
            colDefinition.setSorteable(false);
            if (colDefinition.getId().equals("ecn")) {
                colDefinition.removeDefaultAction("edo");
                colDefinition.setWidth("60%");
                continue;
            }
            if (!colDefinition.getId().equals("ecpi")) continue;
            colDefinition.removeDirectAction("eaps");
            CmsListResourceProjStateAction resourceProjStateAction = new CmsListResourceProjStateAction("eaps"){

                @Override
                public String getIconPath() {
                    if (((Boolean)this.getItem().get(CmsPublishResourcesList.LIST_COLUMN_IS_RELATED)).booleanValue()) {
                        return "explorer/related_resource.png";
                    }
                    return super.getIconPath();
                }

                @Override
                public CmsMessageContainer getName() {
                    if (((Boolean)this.getItem().get(CmsPublishResourcesList.LIST_COLUMN_IS_RELATED)).booleanValue()) {
                        return Messages.get().container("GUI_PUBLISH_RELATED_RESOURCE_0");
                    }
                    return super.getName();
                }
            };
            resourceProjStateAction.setEnabled(false);
            colDefinition.addDirectAction(resourceProjStateAction);
        }
        CmsListExplorerColumn relatedCol = new CmsListExplorerColumn(LIST_COLUMN_IS_RELATED);
        relatedCol.setName(org.opencms.workplace.explorer.Messages.get().container("GUI_INPUT_NAME_0"));
        relatedCol.setVisible(false);
        relatedCol.setPrintable(false);
        metadata.addColumn(relatedCol);
    }

    @Override
    protected void setIndependentActions(CmsListMetadata metadata) {
        abstract class DetailsJsAction
        extends A_CmsListIndependentJsAction {
            public DetailsJsAction(String id) {
                super(id);
            }

            @Override
            public String buttonHtml(CmsWorkplace wp) {
                StringBuffer html = new StringBuffer(1024);
                html.append("\t<span id='");
                html.append(this.getId());
                html.append("' class=\"link");
                html.append("\"");
                html.append(" onClick=\"");
                html.append(this.resolveOnClic(wp));
                html.append("\"");
                html.append(">");
                html.append("<img src='");
                html.append(CmsWorkplace.getSkinUri());
                html.append(this.getIconPath());
                html.append("'");
                html.append(" alt='");
                html.append(this.getName().key(wp.getLocale()));
                html.append("'");
                html.append(" title='");
                html.append(this.getName().key(wp.getLocale()));
                html.append("'");
                html.append(">");
                html.append("&nbsp;");
                html.append("<a href='#'>");
                html.append(this.getName().key(wp.getLocale()));
                html.append("</a>");
                html.append("</span>");
                return html.toString();
            }
        }
        DetailsJsAction hideAction = new DetailsJsAction(LIST_DETAIL_RELATIONS_HIDE){
            {
                super(id);
            }

            @Override
            public String jsCode(CmsWorkplace wp) {
                return "javascript:showRelatedResources(false);";
            }
        };
        hideAction.setIconPath("list/details_hide.png");
        hideAction.setName(Messages.get().container("GUI_PUBLISH_RELATED_RESOURCES_DETAIL_HIDE_NAME_0"));
        hideAction.setHelpText(Messages.get().container("GUI_PUBLISH_RELATED_RESOURCES_DETAIL_HIDE_HELP_0"));
        metadata.addIndependentAction(hideAction);
        DetailsJsAction showAction = new DetailsJsAction(LIST_DETAIL_RELATIONS_SHOW){
            {
                super(id);
            }

            @Override
            public String jsCode(CmsWorkplace wp) {
                return "javascript:showRelatedResources(true);";
            }
        };
        showAction.setIconPath("list/details_show.png");
        showAction.setName(Messages.get().container("GUI_PUBLISH_RELATED_RESOURCES_DETAIL_SHOW_NAME_0"));
        showAction.setHelpText(Messages.get().container("GUI_PUBLISH_RELATED_RESOURCES_DETAIL_SHOW_HELP_0"));
        metadata.addIndependentAction(showAction);
        CmsListItemDetails relationsDetails = new CmsListItemDetails(LIST_DETAIL_RELATIONS){

            @Override
            public I_CmsListAction getAction() {
                return new CmsListIndependentAction("hide"){

                    @Override
                    public String buttonHtml(CmsWorkplace wp) {
                        return "";
                    }
                };
            }
        };
        relationsDetails.setAtColumn("ecn");
        relationsDetails.setVisible(true);
        relationsDetails.setFormatter(new I_CmsListFormatter(){

            @Override
            public String format(Object data, Locale locale) {
                if (!(data instanceof List)) {
                    return new DataFormatException().getLocalizedMessage();
                }
                StringBuffer html = new StringBuffer(512);
                Iterator itResourceNames = ((List)data).iterator();
                if (itResourceNames.hasNext()) {
                    html.append("<table border='0' cellspacing='0' cellpadding='0'>\n");
                }
                while (itResourceNames.hasNext()) {
                    String resName = (String)itResourceNames.next();
                    html.append("\t<tr>\n");
                    html.append("\t\t<td width='150' align='right' class='listdetailhead'>\n");
                    html.append("\t\t\t");
                    if (resName.endsWith("*")) {
                        resName = resName.substring(0, resName.length() - 1);
                        html.append("<font color='red' />");
                        html.append(Messages.get().getBundle(locale).key("GUI_PUBLISH_DETAIL_RELATED_LOCKED_RESOURCE_0"));
                        html.append("</font/>");
                    } else if (resName.endsWith("!")) {
                        resName = resName.substring(0, resName.length() - 1);
                        html.append(Messages.get().getBundle(locale).key("GUI_PUBLISH_DETAIL_RELATED_RESOURCE_0"));
                    } else if (resName.endsWith("$")) {
                        resName = resName.substring(0, resName.length() - 1);
                        html.append(Messages.get().getBundle(locale).key("GUI_PUBLISH_DETAIL_REVERSE_REFERENCE_0"));
                    } else {
                        html.append("<font color='red' />");
                        html.append(Messages.get().getBundle(locale).key("GUI_PUBLISH_DETAIL_RELATED_RESOURCE_NO_0"));
                        html.append("</font/>");
                    }
                    html.append("&nbsp;:&nbsp;\n");
                    html.append("\t\t</td>\n");
                    html.append("\t\t<td class='listdetailitem' style='white-space:normal;'>\n");
                    html.append("\t\t\t");
                    html.append(resName);
                    html.append("\n");
                    html.append("\t\t</td>\n");
                    html.append("\t</tr>\n");
                }
                if (html.length() > 0) {
                    html.append("</table>\n");
                }
                return html.toString();
            }
        });
        relationsDetails.setShowActionName(Messages.get().container("GUI_PUBLISH_RELATED_RESOURCES_DETAIL_SHOW_NAME_0"));
        relationsDetails.setShowActionHelpText(Messages.get().container("GUI_PUBLISH_RELATED_RESOURCES_DETAIL_SHOW_HELP_0"));
        relationsDetails.setHideActionName(Messages.get().container("GUI_PUBLISH_RELATED_RESOURCES_DETAIL_HIDE_NAME_0"));
        relationsDetails.setHideActionHelpText(Messages.get().container("GUI_PUBLISH_RELATED_RESOURCES_DETAIL_HIDE_HELP_0"));
        metadata.addItemDetails(relationsDetails);
    }

    @Override
    protected void setMultiActions(CmsListMetadata metadata) {
        metadata.setSearchAction(null);
    }
}

