/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.PrintfFormat;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.commons.Messages;

public class CmsRenameImages
extends CmsDialog {
    public static final int ACTION_RENAMEIMAGES = 100;
    public static final String DIALOG_TYPE = "renameimages";
    public static final String OPTION_DECIMALPLACES_1 = "1 (1, 2, ..., 9)";
    public static final String OPTION_DECIMALPLACES_2 = "2 (01, 02, ..., 99)";
    public static final String OPTION_DECIMALPLACES_3 = "3 (001, 002, ..., 999)";
    public static final String OPTION_DECIMALPLACES_4 = "4 (0001, 0002, ..., 9999)";
    public static final String PARAM_PLACES = "places";
    public static final String PARAM_PREFIX = "prefix";
    public static final String PARAM_REMOVETITLE = "removetitle";
    public static final String PARAM_STARTCOUNT = "startcount";
    private String m_paramPlaces;
    private String m_paramPrefix;
    private String m_paramRemovetitle;
    private String m_paramStartcount;

    public CmsRenameImages(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsRenameImages(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionRenameImages() throws JspException {
        this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
        try {
            if (this.performDialogOperation()) {
                this.actionCloseDialog();
            } else {
                this.getJsp().include("/system/workplace/commons/includes/wait.jsp");
            }
        }
        catch (Throwable e) {
            this.includeErrorpage((CmsWorkplace)this, e);
        }
    }

    public String buildImageInformation() {
        int count = 0;
        try {
            int imageId = OpenCms.getResourceManager().getResourceType(CmsResourceTypeImage.getStaticTypeName()).getTypeId();
            CmsResourceFilter filter = CmsResourceFilter.IGNORE_EXPIRATION.addRequireType(imageId);
            List images = this.getCms().readResources(this.getParamResource(), filter, false);
            count = images.size();
        }
        catch (CmsException imageId) {
            // empty catch block
        }
        Object[] args = new Object[]{this.getParamResource(), new Integer(count)};
        return this.key("GUI_RENAMEIMAGES_INFO_IMAGECOUNT_2", args);
    }

    public String buildSelectPlaces(String htmlAttributes) {
        ArrayList<String> options = new ArrayList<String>(4);
        options.add(OPTION_DECIMALPLACES_1);
        options.add(OPTION_DECIMALPLACES_2);
        options.add(OPTION_DECIMALPLACES_3);
        options.add(OPTION_DECIMALPLACES_4);
        ArrayList<String> values = new ArrayList<String>(4);
        values.add("1");
        values.add("2");
        values.add("3");
        values.add("4");
        int selectedIndex = 2;
        if (this.getAction() != 0) {
            selectedIndex = values.indexOf(this.getParamPlaces());
        }
        return this.buildSelect(htmlAttributes, options, values, selectedIndex);
    }

    public String getDefaultPrefix() {
        return this.key("GUI_RENAMEIMAGES_DEFAULT_PREFIX_0");
    }

    public String getDefaultStartcount() {
        return "1";
    }

    public String getParamPlaces() {
        return this.m_paramPlaces;
    }

    public String getParamPrefix() {
        return this.m_paramPrefix;
    }

    public String getParamRemovetitle() {
        return this.m_paramRemovetitle;
    }

    public String getParamStartcount() {
        return this.m_paramStartcount;
    }

    public void setParamPlaces(String paramPlaces) {
        this.m_paramPlaces = paramPlaces;
    }

    public void setParamPrefix(String paramPrefix) {
        this.m_paramPrefix = paramPrefix;
    }

    public void setParamRemovetitle(String paramRemovetitle) {
        this.m_paramRemovetitle = paramRemovetitle;
    }

    public void setParamStartcount(String paramStartcount) {
        this.m_paramStartcount = paramStartcount;
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        if (!this.checkResourcePermissions(CmsPermissionSet.ACCESS_WRITE, false)) {
            this.setParamAction("cancel");
        }
        this.setParamDialogtype(DIALOG_TYPE);
        if (DIALOG_TYPE.equals(this.getParamAction())) {
            this.setAction(100);
        } else if ("wait".equals(this.getParamAction())) {
            this.setAction(2);
        } else if ("locksconfirmed".equals(this.getParamAction())) {
            this.setAction(99);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else {
            this.setAction(0);
            Object[] args = new Object[]{this.getParamResource()};
            this.setParamTitle(this.key("GUI_RENAMEIMAGES_TITLE_1", args));
        }
    }

    protected boolean performDialogOperation() throws CmsException {
        if (!"wait".equals(this.getParamAction())) {
            return false;
        }
        this.checkLock(this.getParamResource());
        int imageId = OpenCms.getResourceManager().getResourceType(CmsResourceTypeImage.getStaticTypeName()).getTypeId();
        CmsResourceFilter filter = CmsResourceFilter.IGNORE_EXPIRATION.addRequireType(imageId);
        List images = this.getCms().readResources(this.getParamResource(), filter, false);
        int count = 1;
        try {
            count = Integer.parseInt(this.getParamStartcount());
        }
        catch (Exception exception) {
            // empty catch block
        }
        PrintfFormat numberFormat = new PrintfFormat("%0." + this.getParamPlaces() + "d");
        String folder = this.getParamResource();
        if (!folder.endsWith("/")) {
            folder = folder + "/";
        }
        for (CmsResource res : images) {
            String oldName = CmsResource.getName((String)res.getRootPath());
            CmsProperty titleProperty = this.getCms().readPropertyObject(res, "Title", false);
            String oldTitle = titleProperty.getValue();
            int lastDot = oldName.lastIndexOf(46);
            String suffix = "";
            String oldNameWithoutSuffix = oldName;
            if (lastDot > -1) {
                suffix = oldName.substring(lastDot);
                oldNameWithoutSuffix = oldName.substring(0, lastDot);
            }
            String newName = "";
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.getParamPrefix()) && !"null".equals(this.getParamPrefix())) {
                newName = newName + this.getParamPrefix();
            }
            String imageNumber = numberFormat.sprintf(count);
            if (!(newName = newName + imageNumber + suffix).equals(oldName)) {
                if (this.getCms().existsResource(folder + newName, CmsResourceFilter.ALL)) {
                    throw new CmsException(Messages.get().container("ERR_MOVE_FAILED_TARGET_EXISTS_2", (Object)this.getCms().getSitePath(res), (Object)(folder + newName)));
                }
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)oldTitle) && oldTitle.equals(oldNameWithoutSuffix)) {
                    if (Boolean.valueOf(this.getParamRemovetitle()).booleanValue()) {
                        if (oldTitle.equals(titleProperty.getStructureValue())) {
                            titleProperty.setStructureValue("");
                        }
                        if (oldTitle.equals(titleProperty.getResourceValue())) {
                            titleProperty.setResourceValue("");
                        }
                    } else if (oldTitle.equals(titleProperty.getStructureValue())) {
                        titleProperty.setStructureValue(this.getParamPrefix() + imageNumber);
                    } else if (oldTitle.equals(titleProperty.getResourceValue())) {
                        titleProperty.setResourceValue(this.getParamPrefix() + imageNumber);
                    }
                    this.getCms().writePropertyObject(this.getCms().getSitePath(res), titleProperty);
                }
                this.getCms().renameResource(folder + oldName, folder + newName);
            }
            ++count;
        }
        return true;
    }
}

