/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsUserSearchParameters;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPrincipal;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.commons.Messages;
import org.opencms.workplace.list.A_CmsListDefaultJsAction;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.CmsListSearchAction;
import org.opencms.workplace.list.CmsListState;
import org.opencms.workplace.tools.CmsToolMacroResolver;

public class CmsUserSelectionList
extends A_CmsListDialog {
    public static final String LIST_ACTION_ICON = "ai";
    public static final String LIST_ACTION_SELECT = "js";
    public static final String LIST_COLUMN_FULLNAME = "cf";
    public static final String LIST_COLUMN_ICON = "ci";
    public static final String LIST_COLUMN_LOGIN = "cn";
    public static final String LIST_ID = "lus";
    private String m_paramFlags;
    private String m_paramGroup;

    public CmsUserSelectionList(CmsJspActionElement jsp) {
        super(jsp, LIST_ID, Messages.get().container("GUI_USERSELECTION_LIST_NAME_0"), LIST_COLUMN_LOGIN, CmsListOrderEnum.ORDER_ASCENDING, null);
    }

    public CmsUserSelectionList(CmsJspActionElement jsp, boolean lazy) {
        super(jsp, LIST_ID, Messages.get().container("GUI_USERSELECTION_LIST_NAME_0"), LIST_COLUMN_LOGIN, CmsListOrderEnum.ORDER_ASCENDING, LIST_COLUMN_LOGIN, lazy);
    }

    public CmsUserSelectionList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public CmsUserSelectionList(PageContext context, HttpServletRequest req, HttpServletResponse res, boolean lazy) {
        this(new CmsJspActionElement(context, req, res), lazy);
    }

    public String dialogTitle() {
        StringBuffer html = new StringBuffer(512);
        html.append("<div class='screenTitle'>\n");
        html.append("\t<table width='100%' cellspacing='0'>\n");
        html.append("\t\t<tr>\n");
        html.append("\t\t\t<td>\n");
        String param = "";
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.getParamGroup())) {
            param = Messages.get().getBundle(this.getLocale()).key("GUI_USERSELECTION_GROUP_BLOCK_1", (Object)this.getParamGroup());
        }
        html.append(this.key("GUI_USERSELECTION_INTRO_TITLE_1", new Object[]{param}));
        html.append("\n\t\t\t</td>");
        html.append("\t\t</tr>\n");
        html.append("\t</table>\n");
        html.append("</div>\n");
        return CmsToolMacroResolver.resolveMacros((String)html.toString(), (CmsWorkplace)this);
    }

    @Override
    public void executeListMultiActions() throws CmsRuntimeException {
        this.throwListUnsupportedActionException();
    }

    @Override
    public void executeListSingleActions() throws CmsRuntimeException {
        this.throwListUnsupportedActionException();
    }

    public String getParamFlags() {
        return this.m_paramFlags;
    }

    public String getParamGroup() {
        return this.m_paramGroup;
    }

    public void setParamFlags(String flags) {
        this.m_paramFlags = flags;
    }

    public void setParamGroup(String groupName) {
        this.m_paramGroup = groupName;
    }

    @Override
    protected void fillDetails(String detailId) {
    }

    @Override
    protected List<CmsListItem> getListItems() throws CmsException {
        if (!this.m_lazy) {
            ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
            List<CmsPrincipal> users = this.getUsers();
            for (CmsPrincipal prin : users) {
                if (!(prin instanceof CmsUser)) continue;
                CmsUser user = (CmsUser)prin;
                CmsListItem item = this.makeListItem(user);
                ret.add(item);
            }
            return ret;
        }
        CmsUserSearchParameters params = this.getSearchParams();
        List users = OpenCms.getOrgUnitManager().searchUsers(this.getCms(), params);
        int count = (int)OpenCms.getOrgUnitManager().countUsers(this.getCms(), params);
        this.getList().setSize(count);
        ArrayList result = Lists.newArrayList();
        for (CmsUser user : users) {
            CmsListItem item = this.makeListItem(user);
            result.add(item);
        }
        return result;
    }

    protected CmsUserSearchParameters getSearchParams() throws CmsException {
        CmsListState state = this.getListState();
        CmsUserSearchParameters params = new CmsUserSearchParameters();
        String searchFilter = state.getFilter();
        params.setSearchFilter(searchFilter);
        params.setPaging(this.getList().getMaxItemsPerPage(), state.getPage());
        params.setSorting(this.getSortKey(state.getColumn()), state.getOrder().equals(CmsListOrderEnum.ORDER_ASCENDING));
        String groupStr = this.getParamGroup();
        if (!CmsStringUtil.isEmpty((String)groupStr)) {
            CmsGroup group = this.getCms().readGroup(this.getParamGroup());
            params.setGroup(group);
        } else {
            List ous = OpenCms.getRoleManager().getManageableOrgUnits(this.getCms(), "", true, false);
            params.setAllowedOus(ous);
        }
        if (this.getParamFlags() != null) {
            int flags = Integer.parseInt(this.getParamFlags());
            params.setFlags(flags);
        }
        params.setCaseSensitive(false);
        return params;
    }

    protected CmsUserSearchParameters.SortKey getSortKey(String column) {
        if (column == null) {
            return null;
        }
        if (column.equals(LIST_COLUMN_FULLNAME)) {
            return CmsUserSearchParameters.SortKey.fullName;
        }
        if (column.equals(LIST_COLUMN_LOGIN)) {
            return CmsUserSearchParameters.SortKey.loginName;
        }
        return null;
    }

    protected List<CmsPrincipal> getUsers() throws CmsException {
        ArrayList<CmsPrincipal> ret = new ArrayList<CmsPrincipal>();
        if (this.getParamGroup() != null) {
            ret.addAll(this.getCms().getUsersOfGroup(this.getParamGroup()));
        } else {
            ret.addAll(OpenCms.getRoleManager().getManageableUsers(this.getCms(), "", true));
        }
        if (this.getParamFlags() != null) {
            int flags = Integer.parseInt(this.getParamFlags());
            return new ArrayList<CmsPrincipal>(CmsPrincipal.filterFlag(ret, (int)flags));
        }
        return ret;
    }

    protected CmsListItem makeListItem(CmsUser user) {
        CmsListItem item = this.getList().newItem(user.getId().toString());
        item.set(LIST_COLUMN_LOGIN, user.getName());
        item.set(LIST_COLUMN_FULLNAME, user.getFullName());
        return item;
    }

    @Override
    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition iconCol = new CmsListColumnDefinition(LIST_COLUMN_ICON);
        iconCol.setName(Messages.get().container("GUI_USERSELECTION_LIST_COLS_ICON_0"));
        iconCol.setHelpText(Messages.get().container("GUI_USERSELECTION_LIST_COLS_ICON_HELP_0"));
        iconCol.setWidth("20");
        iconCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        iconCol.setSorteable(false);
        CmsListDirectAction iconAction = new CmsListDirectAction(LIST_ACTION_ICON);
        iconAction.setName(Messages.get().container("GUI_USERSELECTION_LIST_ICON_NAME_0"));
        iconAction.setHelpText(Messages.get().container("GUI_USERSELECTION_LIST_ICON_HELP_0"));
        iconAction.setIconPath("buttons/user.png");
        iconAction.setEnabled(false);
        iconCol.addDirectAction(iconAction);
        metadata.addColumn(iconCol);
        CmsListColumnDefinition loginCol = new CmsListColumnDefinition(LIST_COLUMN_LOGIN);
        loginCol.setName(Messages.get().container("GUI_USERSELECTION_LIST_COLS_LOGIN_0"));
        loginCol.setWidth("60%");
        A_CmsListDefaultJsAction selectAction = new A_CmsListDefaultJsAction(LIST_ACTION_SELECT){

            @Override
            public String jsCode() {
                return "window.opener.setUserFormValue('" + this.getItem().get(CmsUserSelectionList.LIST_COLUMN_LOGIN) + "'); window.opener.focus(); window.close();";
            }
        };
        selectAction.setName(Messages.get().container("GUI_USERSELECTION_LIST_ACTION_SELECT_NAME_0"));
        selectAction.setHelpText(Messages.get().container("GUI_USERSELECTION_LIST_ACTION_SELECT_HELP_0"));
        loginCol.addDefaultAction(selectAction);
        metadata.addColumn(loginCol);
        CmsListColumnDefinition fullnameCol = new CmsListColumnDefinition(LIST_COLUMN_FULLNAME);
        fullnameCol.setName(Messages.get().container("GUI_USERSELECTION_LIST_COLS_FULLNAME_0"));
        fullnameCol.setWidth("40%");
        fullnameCol.setTextWrapping(true);
        metadata.addColumn(fullnameCol);
    }

    @Override
    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListSearchAction searchAction = new CmsListSearchAction(metadata.getColumnDefinition(LIST_COLUMN_LOGIN));
        searchAction.addColumn(metadata.getColumnDefinition(LIST_COLUMN_FULLNAME));
        searchAction.setCaseInSensitive(true);
        metadata.setSearchAction(searchAction);
    }

    @Override
    protected void setMultiActions(CmsListMetadata metadata) {
    }

    @Override
    protected void validateParamaters() throws Exception {
        try {
            this.getCms().readGroup(this.getParamGroup()).getName();
        }
        catch (Exception e) {
            this.setParamGroup(null);
        }
        try {
            Integer.valueOf(this.getParamFlags());
        }
        catch (Throwable e) {
            this.setParamFlags(null);
        }
    }
}

