/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.comparison;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.history.CmsHistoryFile;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.comparison.CmsAttributeComparison;
import org.opencms.workplace.comparison.CmsHistoryListUtil;
import org.opencms.workplace.comparison.CmsPropertyComparisonList;
import org.opencms.workplace.comparison.CmsResourceComparison;
import org.opencms.workplace.comparison.Messages;
import org.opencms.workplace.list.CmsListIndependentAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;

public class CmsAttributeComparisonList
extends CmsPropertyComparisonList {
    public static final String AC_LIST_ID = "hiacl";

    public CmsAttributeComparisonList(CmsJspActionElement jsp) {
        this(AC_LIST_ID, jsp);
    }

    public CmsAttributeComparisonList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    protected CmsAttributeComparisonList(String listId, CmsJspActionElement jsp) {
        super(jsp, listId, Messages.get().container("GUI_COMPARE_ATTRIBUTES_0"), "cp", CmsListOrderEnum.ORDER_ASCENDING, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static CmsFile readFile(CmsObject cms, CmsUUID structureId, String version) throws CmsException {
        if (Integer.parseInt(version) == Integer.MAX_VALUE) {
            CmsResource resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            return cms.readFile(resource);
        }
        int ver = Integer.parseInt(version);
        if (ver < 0) {
            CmsProject project = cms.getRequestContext().getCurrentProject();
            try {
                cms.getRequestContext().setCurrentProject(cms.readProject(CmsProject.ONLINE_PROJECT_ID));
                CmsResource resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
                CmsFile cmsFile = cms.readFile(resource);
                return cmsFile;
            }
            finally {
                cms.getRequestContext().setCurrentProject(project);
            }
        }
        return cms.readFile((CmsResource)((CmsHistoryFile)cms.readResource(structureId, ver)));
    }

    @Override
    public void executeListSingleActions() throws IOException, ServletException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("version1", new String[]{this.getParamVersion1()});
        params.put("version2", new String[]{this.getParamVersion2()});
        params.put("id1", new String[]{this.getParamId1()});
        params.put("id2", new String[]{this.getParamId2()});
        params.put("compare", new String[]{"attributes"});
        params.put("resource", new String[]{this.getParamResource()});
        this.getToolManager().jspForwardTool((CmsWorkplace)this, "/history/comparison/difference", params);
    }

    @Override
    protected List<CmsListItem> getListItems() {
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        Iterator diffs = CmsResourceComparison.compareAttributes((CmsObject)this.getCms(), (CmsResource)this.getResource1(), (CmsResource)this.getResource2()).iterator();
        while (diffs.hasNext()) {
            CmsAttributeComparison comparison = (CmsAttributeComparison)diffs.next();
            CmsListItem item = this.getList().newItem(comparison.getName());
            item.set("cp", this.key(comparison.getName()));
            item.set("cv", CmsStringUtil.trimToSize((String)comparison.getVersion1(), (int)60));
            item.set("cw", CmsStringUtil.trimToSize((String)comparison.getVersion2(), (int)60));
            if ("added".equals(comparison.getStatus())) {
                item.set("cz", this.key("GUI_COMPARE_ADDED_0"));
            } else if ("removed".equals(comparison.getStatus())) {
                item.set("cz", this.key("GUI_COMPARE_REMOVED_0"));
            } else if ("changed".equals(comparison.getStatus())) {
                item.set("cz", this.key("GUI_COMPARE_CHANGED_0"));
            } else {
                if (!this.getList().getMetadata().getItemDetailDefinition("is").isVisible()) continue;
                item.set("cz", this.key("GUI_COMPARE_UNCHANGED_0"));
            }
            ret.add(item);
            if (diffs.hasNext()) continue;
            this.getList().getMetadata().getIndependentAction("v1").setEnabled(this.getResource1().isFile());
            this.getList().getMetadata().getIndependentAction("v2").setEnabled(this.getResource2().isFile());
        }
        this.getList().getMetadata().getColumnDefinition("cv").setName(Messages.get().container("GUI_COMPARE_VERSION_1", (Object)CmsHistoryListUtil.getDisplayVersion((String)this.getParamVersion1(), (Locale)this.getLocale())));
        this.getList().getMetadata().getColumnDefinition("cw").setName(Messages.get().container("GUI_COMPARE_VERSION_1", (Object)CmsHistoryListUtil.getDisplayVersion((String)this.getParamVersion2(), (Locale)this.getLocale())));
        return ret;
    }

    protected String getViewVersionButtonHtml(CmsUUID structureId, String version) {
        boolean active = true;
        try {
            if (OpenCms.getResourceManager().getResourceType(this.getResource1().getTypeId()).isFolder()) {
                active = false;
            } else {
                byte[] content = CmsAttributeComparisonList.readFile(this.getCms(), structureId, version).getContents();
                if (content.length < 1) {
                    active = false;
                }
            }
        }
        catch (CmsLoaderException content) {
        }
        catch (CmsException e) {
            active = false;
        }
        if (active) {
            String label = Messages.get().container("GUI_COMPARE_VIEW_VERSION_1", (Object)CmsHistoryListUtil.getDisplayVersion((String)version, (Locale)this.getLocale())).key(this.getLocale());
            String iconPath = null;
            try {
                String typeName = OpenCms.getResourceManager().getResourceType(this.getResource1().getTypeId()).getTypeName();
                iconPath = "filetypes/" + OpenCms.getWorkplaceManager().getExplorerTypeSetting(typeName).getIcon();
            }
            catch (CmsException e) {
                iconPath = "filetypes/" + OpenCms.getWorkplaceManager().getExplorerTypeSetting(CmsResourceTypePlain.getStaticTypeName()).getIcon();
            }
            StringBuffer result = new StringBuffer(1024);
            result.append("<span class='link' onClick=\"");
            result.append("window.open('");
            result.append(this.getJsp().link(CmsHistoryListUtil.getHistoryLink((CmsObject)this.getCms(), (CmsUUID)structureId, (String)version)));
            result.append("','version','scrollbars=yes', 'resizable=yes', 'width=800', 'height=600')\">");
            result.append("<img style='width: 16px; height: 16px;' src='");
            result.append(CmsWorkplace.getSkinUri());
            result.append(iconPath);
            result.append("' alt='");
            result.append(label);
            result.append("' title='");
            result.append(label);
            result.append("'>&nbsp;<a href='#'>");
            result.append(label);
            result.append("</a></span>");
            return result.toString();
        }
        return "";
    }

    @Override
    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListIndependentAction viewVersion1 = new CmsListIndependentAction("v1"){

            @Override
            public String buttonHtml(CmsWorkplace wp) {
                return ((CmsAttributeComparisonList)wp).getViewVersionButtonHtml(new CmsUUID(((CmsAttributeComparisonList)wp).getParamId1()), ((CmsAttributeComparisonList)wp).getParamVersion1());
            }
        };
        metadata.addIndependentAction(viewVersion1);
        CmsListIndependentAction viewVersion2 = new CmsListIndependentAction("v2"){

            @Override
            public String buttonHtml(CmsWorkplace wp) {
                return ((CmsAttributeComparisonList)wp).getViewVersionButtonHtml(new CmsUUID(((CmsAttributeComparisonList)wp).getParamId2()), ((CmsAttributeComparisonList)wp).getParamVersion2());
            }
        };
        metadata.addIndependentAction(viewVersion2);
        CmsListItemDetails eventDetails = new CmsListItemDetails("is");
        eventDetails.setVisible(false);
        eventDetails.setShowActionName(Messages.get().container("GUI_COMPARE_SHOW_ALL_ATTRIBUTES_0"));
        eventDetails.setHideActionName(Messages.get().container("GUI_COMPARE_HIDE_IDENTICAL_ATTRIBUTES_0"));
        metadata.addItemDetails(eventDetails);
    }
}

