/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.comparison;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsDateUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.comparison.CmsElementComparison;
import org.opencms.workplace.comparison.CmsHistoryListUtil;
import org.opencms.workplace.comparison.CmsResourceComparisonDialog;
import org.opencms.workplace.comparison.CmsXmlContentElementComparison;
import org.opencms.workplace.comparison.CmsXmlDocumentComparison;
import org.opencms.workplace.comparison.Messages;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListIndependentAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;

public class CmsElementComparisonList
extends A_CmsListDialog {
    public static final String LIST_ACTION_ICON = "ai";
    public static final String LIST_ACTION_STATUS = "at";
    public static final String LIST_COLUMN_ATTRIBUTE = "ca";
    public static final String LIST_COLUMN_ICON = "ci";
    public static final String LIST_COLUMN_LOCALE = "cl";
    public static final String LIST_COLUMN_STATUS = "cs";
    public static final String LIST_COLUMN_TYPE = "cy";
    public static final String LIST_COLUMN_VERSION_1 = "cv";
    public static final String LIST_COLUMN_VERSION_2 = "cw";
    public static final String LIST_DEFACTION_VIEW = "dv";
    public static final String LIST_DETAIL_TYPE = "dt";
    public static final String LIST_IACTION_COMPARE_ALL = "ava";
    public static final String LIST_IACTION_SHOW = "isy";
    public static final String LIST_ID = "hiecl";
    public static final String PARAM_ELEMENT = "element";
    public static final String PARAM_LOCALE = "locale";
    private static final Log LOG = CmsLog.getLog(CmsElementComparisonList.class);
    private String m_paramId1;
    private String m_paramId2;
    private String m_paramVersion1;
    private String m_paramVersion2;
    private boolean m_xmlContentComparisonMode;

    public CmsElementComparisonList(CmsJspActionElement jsp) {
        this(LIST_ID, jsp);
    }

    public CmsElementComparisonList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    protected CmsElementComparisonList(String listId, CmsJspActionElement jsp) {
        super(jsp, listId, Messages.get().container("GUI_COMPARE_CONTENT_0"), LIST_COLUMN_LOCALE, CmsListOrderEnum.ORDER_ASCENDING, null);
    }

    public static String formatContentValueForDiffTable(CmsObject cms, CmsElementComparison comparison, String origValue) {
        String result = CmsStringUtil.escapeHtml((String)CmsStringUtil.substitute((String)CmsStringUtil.trimToSize((String)origValue, (int)60), (String)"\n", (String)""));
        if (comparison instanceof CmsXmlContentElementComparison && ((CmsXmlContentElementComparison)comparison).getType().equals("OpenCmsDateTime") && CmsStringUtil.isNotEmpty((String)result)) {
            result = CmsDateUtil.getDateTime((Date)new Date(Long.parseLong(result)), (int)3, (Locale)cms.getRequestContext().getLocale());
        }
        return result;
    }

    @Override
    public void executeListIndepActions() {
        if (this.getParamListAction().equals(LIST_IACTION_COMPARE_ALL)) {
            HashMap<String, String[]> params = new HashMap<String, String[]>();
            params.put("version1", new String[]{this.getParamVersion1()});
            params.put("version2", new String[]{this.getParamVersion2()});
            params.put("id1", new String[]{this.getParamId1()});
            params.put("id2", new String[]{this.getParamId2()});
            params.put("compare", new String[]{"allelements"});
            params.put("resource", new String[]{this.getParamResource()});
            try {
                this.getToolManager().jspForwardTool((CmsWorkplace)this, "/history/comparison/difference", params);
            }
            catch (Exception e) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        super.executeListIndepActions();
    }

    @Override
    public void executeListMultiActions() {
        this.throwListUnsupportedActionException();
    }

    @Override
    public void executeListSingleActions() throws IOException, ServletException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("version1", new String[]{this.getParamVersion1()});
        params.put("version2", new String[]{this.getParamVersion2()});
        params.put("id1", new String[]{this.getParamId1()});
        params.put("id2", new String[]{this.getParamId2()});
        params.put(PARAM_LOCALE, new String[]{this.getSelectedItem().get(LIST_COLUMN_LOCALE).toString()});
        params.put(PARAM_ELEMENT, new String[]{this.getSelectedItem().get(LIST_COLUMN_ATTRIBUTE).toString()});
        params.put("resource", new String[]{this.getParamResource()});
        this.getToolManager().jspForwardTool((CmsWorkplace)this, "/history/comparison/difference", params);
    }

    public String getParamId1() {
        return this.m_paramId1;
    }

    public String getParamId2() {
        return this.m_paramId2;
    }

    public String getParamVersion1() {
        return this.m_paramVersion1;
    }

    public String getParamVersion2() {
        return this.m_paramVersion2;
    }

    public void setParamId1(String paramId1) {
        this.m_paramId1 = paramId1;
    }

    public void setParamId2(String paramId2) {
        this.m_paramId2 = paramId2;
    }

    public void setParamVersion1(String paramNewversionid) {
        this.m_paramVersion1 = paramNewversionid;
    }

    public void setParamVersion2(String paramOldversionid) {
        this.m_paramVersion2 = paramOldversionid;
    }

    @Override
    protected void fillDetails(String detailId) {
    }

    @Override
    protected List<CmsListItem> getListItems() throws CmsException {
        ArrayList<CmsListItem> result = new ArrayList<CmsListItem>();
        CmsFile resource1 = CmsResourceComparisonDialog.readFile(this.getCms(), new CmsUUID(this.getParamId1()), this.getParamVersion1());
        CmsFile resource2 = CmsResourceComparisonDialog.readFile(this.getCms(), new CmsUUID(this.getParamId2()), this.getParamVersion2());
        for (CmsElementComparison comparison : new CmsXmlDocumentComparison(this.getCms(), resource1, resource2).getElements()) {
            String locale = comparison.getLocale().toString();
            String attribute = comparison.getName();
            CmsListItem item = this.getList().newItem(locale + attribute);
            item.set(LIST_COLUMN_LOCALE, locale);
            item.set(LIST_COLUMN_ATTRIBUTE, attribute);
            if (comparison instanceof CmsXmlContentElementComparison) {
                this.m_xmlContentComparisonMode = true;
                item.set(LIST_COLUMN_TYPE, ((CmsXmlContentElementComparison)comparison).getType());
            }
            if ("added".equals(comparison.getStatus())) {
                item.set(LIST_COLUMN_STATUS, this.key("GUI_COMPARE_ADDED_0"));
            } else if ("removed".equals(comparison.getStatus())) {
                item.set(LIST_COLUMN_STATUS, this.key("GUI_COMPARE_REMOVED_0"));
            } else if ("changed".equals(comparison.getStatus())) {
                item.set(LIST_COLUMN_STATUS, this.key("GUI_COMPARE_CHANGED_0"));
            } else {
                if (!this.getList().getMetadata().getItemDetailDefinition(LIST_IACTION_SHOW).isVisible()) continue;
                item.set(LIST_COLUMN_STATUS, this.key("GUI_COMPARE_UNCHANGED_0"));
            }
            String value1 = CmsStringUtil.escapeHtml((String)CmsStringUtil.substitute((String)CmsStringUtil.trimToSize((String)comparison.getVersion1(), (int)60), (String)"\n", (String)""));
            if (comparison instanceof CmsXmlContentElementComparison && ((CmsXmlContentElementComparison)comparison).getType().equals("OpenCmsDateTime") && CmsStringUtil.isNotEmpty((String)value1)) {
                value1 = CmsDateUtil.getDateTime((Date)new Date(Long.parseLong(value1)), (int)3, (Locale)this.getCms().getRequestContext().getLocale());
            }
            item.set(LIST_COLUMN_VERSION_1, value1);
            String origValue = comparison.getVersion2();
            String value2 = CmsElementComparisonList.formatContentValueForDiffTable(this.getCms(), comparison, origValue);
            item.set(LIST_COLUMN_VERSION_2, value2);
            result.add(item);
        }
        this.getList().getMetadata().getColumnDefinition(LIST_COLUMN_VERSION_1).setName(Messages.get().container("GUI_COMPARE_VERSION_1", (Object)CmsHistoryListUtil.getDisplayVersion((String)this.getParamVersion1(), (Locale)this.getLocale())));
        this.getList().getMetadata().getColumnDefinition(LIST_COLUMN_VERSION_2).setName(Messages.get().container("GUI_COMPARE_VERSION_1", (Object)CmsHistoryListUtil.getDisplayVersion((String)this.getParamVersion2(), (Locale)this.getLocale())));
        return result;
    }

    @Override
    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition iconCol = new CmsListColumnDefinition(LIST_COLUMN_ICON);
        iconCol.setName(Messages.get().container("GUI_COMPARE_COLS_ICON_0"));
        iconCol.setWidth("20");
        iconCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        iconCol.setSorteable(true);
        CmsListDirectAction addedAction = new CmsListDirectAction("added"){

            public boolean isVisible() {
                String type = this.getItem().get(CmsElementComparisonList.LIST_COLUMN_STATUS).toString();
                return CmsElementComparisonList.this.key("GUI_COMPARE_ADDED_0").equals(type);
            }
        };
        addedAction.setName(Messages.get().container("GUI_COMPARE_ELEM_ADDED_0"));
        addedAction.setIconPath("tools/ex_history/buttons/added.png");
        addedAction.setEnabled(true);
        iconCol.addDirectAction(addedAction);
        CmsListDirectAction removedAction = new CmsListDirectAction("removed"){

            public boolean isVisible() {
                String type = this.getItem().get(CmsElementComparisonList.LIST_COLUMN_STATUS).toString();
                return CmsElementComparisonList.this.key("GUI_COMPARE_REMOVED_0").equals(type);
            }
        };
        removedAction.setName(Messages.get().container("GUI_COMPARE_ELEM_REMOVED_0"));
        removedAction.setIconPath("tools/ex_history/buttons/removed.png");
        removedAction.setEnabled(true);
        iconCol.addDirectAction(removedAction);
        CmsListDirectAction changedAction = new CmsListDirectAction("changed"){

            public boolean isVisible() {
                String type = this.getItem().get(CmsElementComparisonList.LIST_COLUMN_STATUS).toString();
                return CmsElementComparisonList.this.key("GUI_COMPARE_CHANGED_0").equals(type);
            }
        };
        changedAction.setName(Messages.get().container("GUI_COMPARE_ELEM_CHANGED_0"));
        changedAction.setIconPath("tools/ex_history/buttons/changed.png");
        changedAction.setEnabled(true);
        iconCol.addDirectAction(changedAction);
        CmsListDirectAction unchangedAction = new CmsListDirectAction("unchanged"){

            public boolean isVisible() {
                String type = this.getItem().get(CmsElementComparisonList.LIST_COLUMN_STATUS).toString();
                return CmsElementComparisonList.this.key("GUI_COMPARE_UNCHANGED_0").equals(type);
            }
        };
        unchangedAction.setName(Messages.get().container("GUI_COMPARE_ELEM_UNCHANGED_0"));
        unchangedAction.setIconPath("tools/ex_history/buttons/unchanged.png");
        unchangedAction.setEnabled(true);
        iconCol.addDirectAction(unchangedAction);
        metadata.addColumn(iconCol);
        iconCol.setPrintable(false);
        CmsListColumnDefinition statusCol = new CmsListColumnDefinition(LIST_COLUMN_STATUS);
        statusCol.setName(Messages.get().container("GUI_COMPARE_COLS_STATUS_0"));
        statusCol.setWidth("10%");
        CmsListDefaultAction statusColAction = new CmsListDefaultAction(LIST_ACTION_STATUS);
        statusColAction.setName(Messages.get().container("GUI_COMPARE_COLS_STATUS_0"));
        statusColAction.setEnabled(true);
        statusCol.addDefaultAction(statusColAction);
        metadata.addColumn(statusCol);
        statusCol.setPrintable(true);
        CmsListColumnDefinition localeCol = new CmsListColumnDefinition(LIST_COLUMN_LOCALE);
        localeCol.setName(Messages.get().container("GUI_COMPARE_COLS_LOCALE_0"));
        localeCol.setWidth("10%");
        metadata.addColumn(localeCol);
        localeCol.setPrintable(true);
        CmsListColumnDefinition attCol = new CmsListColumnDefinition(LIST_COLUMN_ATTRIBUTE);
        attCol.setName(Messages.get().container("GUI_COMPARE_COLS_NAME_0"));
        attCol.setWidth("10%");
        metadata.addColumn(attCol);
        attCol.setPrintable(true);
        CmsListColumnDefinition typeCol = new CmsListColumnDefinition(LIST_COLUMN_TYPE);
        typeCol.setName(Messages.get().container("GUI_COMPARE_COLS_TYPE_0"));
        typeCol.setWidth("10%");
        typeCol.setVisible(this.m_xmlContentComparisonMode);
        metadata.addColumn(typeCol);
        typeCol.setPrintable(true);
        CmsListColumnDefinition version1Col = new CmsListColumnDefinition(LIST_COLUMN_VERSION_1);
        version1Col.setName(Messages.get().container("GUI_COMPARE_VERSION_1", (Object)CmsHistoryListUtil.getDisplayVersion((String)this.getParamVersion1(), (Locale)this.getLocale())));
        version1Col.setWidth("35%");
        version1Col.setSorteable(false);
        metadata.addColumn(version1Col);
        version1Col.setPrintable(true);
        CmsListColumnDefinition version2Col = new CmsListColumnDefinition(LIST_COLUMN_VERSION_2);
        version2Col.setName(Messages.get().container("GUI_COMPARE_VERSION_1", (Object)CmsHistoryListUtil.getDisplayVersion((String)this.getParamVersion2(), (Locale)this.getLocale())));
        version2Col.setWidth("35%");
        version2Col.setSorteable(false);
        metadata.addColumn(version2Col);
        version2Col.setPrintable(true);
    }

    @Override
    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListIndependentAction compare = new CmsListIndependentAction(LIST_IACTION_COMPARE_ALL);
        compare.setName(Messages.get().container("GUI_COMPARE_COMPARE_ALL_0"));
        compare.setIconPath("tools/ex_history/buttons/compare.png");
        compare.setEnabled(true);
        metadata.addIndependentAction(compare);
        CmsListItemDetails eventDetails = new CmsListItemDetails(LIST_IACTION_SHOW);
        eventDetails.setVisible(false);
        eventDetails.setShowActionName(Messages.get().container("GUI_COMPARE_SHOW_ALL_ELEMENTS_0"));
        eventDetails.setHideActionName(Messages.get().container("GUI_COMPARE_HIDE_IDENTICAL_ELEMENTS_0"));
        metadata.addItemDetails(eventDetails);
    }

    @Override
    protected void setMultiActions(CmsListMetadata metadata) {
    }
}

