/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.comparison;

import com.alkacon.diff.Diff;
import com.alkacon.diff.I_HtmlDiffConfiguration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.util.CmsHtml2TextConverter;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.comparison.CmsDiffViewMode;
import org.opencms.workplace.comparison.CmsDifferenceDialog;
import org.opencms.workplace.comparison.CmsHtmlDifferenceConfiguration;
import org.opencms.workplace.comparison.Messages;

public class CmsHtmlDifferenceDialog
extends CmsDifferenceDialog {
    public static final String MODE_HTML = "html";
    public static final String MODE_TEXT = "text";
    public static final String PARAM_TEXTMODE = "textmode";

    public CmsHtmlDifferenceDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsHtmlDifferenceDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    @Override
    public void displayDialog() throws Exception {
        if (this.getAction() == 4) {
            this.actionCloseDialog();
        }
        JspWriter out = this.getJsp().getJspContext().getOut();
        out.print("<link rel='stylesheet' type='text/css' href='");
        out.print(CmsHtmlDifferenceDialog.getStyleUri((CmsJspActionElement)this.getJsp()));
        out.println("diff.css'>");
        out.println(this.dialogContentStart(this.getParamTitle()));
        out.print("<form name='diff-form' method='post' action='");
        out.print(this.getDialogUri());
        out.println("'>");
        out.println(this.allParamsAsHidden());
        out.println("</form>");
        out.println("<p>");
        out.println(this.getDiffOnlyButtonsHtml());
        String onClic1 = "javascript:document.forms['diff-form'].textmode.value = '";
        onClic1 = onClic1 + MODE_TEXT;
        onClic1 = onClic1 + "'; document.forms['diff-form'].submit();";
        String onClic2 = "javascript:document.forms['diff-form'].textmode.value = '";
        onClic2 = onClic2 + MODE_HTML;
        onClic2 = onClic2 + "'; document.forms['diff-form'].submit();";
        out.println(this.getTwoButtonsHtml(Messages.get().container("GUI_DIFF_MODE_TEXT_0").key(this.getLocale()), Messages.get().container("GUI_DIFF_MODE_HTML_0").key(this.getLocale()), onClic1, onClic2, MODE_HTML.equals(this.getParamTextmode())));
        out.println("</p>");
        out.println(this.dialogBlockStart(null));
        out.println("<table cellspacing='0' cellpadding='0' class='xmlTable'>\n<tr><td><pre style='overflow:auto'>");
        try {
            String diff;
            CmsHtmlDifferenceConfiguration conf = new CmsHtmlDifferenceConfiguration(this.getMode() == CmsDiffViewMode.ALL ? -1 : this.getLinesBeforeSkip(), this.getLocale());
            String originalSource = this.getOriginalSource();
            String copySource = this.getCopySource();
            if (MODE_TEXT.equals(this.getParamTextmode())) {
                originalSource = CmsHtml2TextConverter.html2text((String)originalSource, (String)"ISO-8859-1");
                copySource = CmsHtml2TextConverter.html2text((String)copySource, (String)"ISO-8859-1");
            }
            if (CmsStringUtil.isNotEmpty((String)(diff = Diff.diffAsHtml((String)originalSource, (String)copySource, (I_HtmlDiffConfiguration)conf)))) {
                out.println(diff);
            } else {
                String htmlDiff = Diff.diffAsHtml((String)this.getOriginalSource(), (String)this.getCopySource(), (I_HtmlDiffConfiguration)conf);
                if (CmsStringUtil.isNotEmpty((String)htmlDiff)) {
                    out.println(Messages.get().container("GUI_COMPARE_IDENTICAL_TEXT_DIFFERENT_HTML_0").key(this.getLocale()));
                } else if (this.getMode() == CmsDiffViewMode.ALL) {
                    out.println(this.wrapLinesWithUnchangedStyle(CmsStringUtil.substitute((String)CmsStringUtil.escapeHtml((String)originalSource), (String)"<br/>", (String)"")));
                }
            }
        }
        catch (Exception e) {
            out.print((Object)e);
        }
        out.println("</pre></td></tr>\n</table>");
        out.println(this.dialogBlockEnd());
        out.println(this.dialogContentEnd());
        out.println(this.dialogEnd());
        out.println(this.bodyEnd());
        out.println(this.htmlEnd());
    }

    @Override
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.getParamTextmode())) {
            this.setParamTextmode(MODE_TEXT);
        }
    }

    @Override
    protected void validateParamaters() {
    }
}

