/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.explorer;

import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.opencms.configuration.CmsDefaultUserSettings;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeFolder;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUriSplitter;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.CmsNewResource;
import org.opencms.workplace.explorer.Messages;
import org.opencms.workplace.list.A_CmsListResourceTypeDialog;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.I_CmsListItemComparator;

public class CmsNewResourceFolder
extends A_CmsListResourceTypeDialog {
    public static final String DEFAULT_AVAILABLE = "none|xmlpage";
    public static final String DEFAULT_MARKER = "*";
    public static final String ID_NO_INDEX_PAGE = "__none";
    public static final String NAME_NO_INDEX_PAGE = "none";
    public static final String PARAM_CURRENTFOLDER = "currentfolder";
    public static final String PARAM_INDEX_PAGE_TYPE = "indexpagetype";
    public static final String PROPERTY_RESTYPES_INDEXPAGE = "restypes.indexpage";
    private static final I_CmsListItemComparator LIST_ITEM_COMPARATOR = new I_CmsListItemComparator(){

        @Override
        public Comparator<CmsListItem> getComparator(final String columnId, Locale locale) {
            final Collator collator = Collator.getInstance(locale);
            return new Comparator<CmsListItem>(){

                @Override
                public int compare(CmsListItem o1, CmsListItem o2) {
                    String id2;
                    if (o1 == o2) {
                        return 0;
                    }
                    CmsListItem li1 = o1;
                    CmsListItem li2 = o2;
                    String id1 = li1.getId();
                    if (id1.equals(id2 = li2.getId())) {
                        return 0;
                    }
                    if (id1.equals(CmsNewResourceFolder.ID_NO_INDEX_PAGE)) {
                        return -1;
                    }
                    if (id2.equals(CmsNewResourceFolder.ID_NO_INDEX_PAGE)) {
                        return 1;
                    }
                    Comparable c1 = (Comparable)li1.get(columnId);
                    Comparable c2 = (Comparable)li2.get(columnId);
                    if (c1 instanceof String && c2 instanceof String) {
                        return collator.compare(c1, c2);
                    }
                    if (c1 != null) {
                        if (c2 == null) {
                            return 1;
                        }
                        return c1.compareTo(c2);
                    }
                    if (c2 != null) {
                        return -1;
                    }
                    return 0;
                }
            };
        }
    };
    private String m_paramCurrentFolder;
    private String m_paramNewResourceEditProps;

    public CmsNewResourceFolder(CmsJspActionElement jsp) {
        super(jsp, "nrt", Messages.get().container("GUI_NEWFOLDER_SELECT_INDEX_TYPE_0"), "nrcn", CmsListOrderEnum.ORDER_ASCENDING, null);
    }

    public CmsNewResourceFolder(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public boolean actionCreateResource() throws JspException {
        try {
            String title = CmsNewResource.computeNewTitleProperty(this.getParamResource());
            String fullResourceName = this.computeFullResourceName();
            List<CmsProperty> properties = CmsNewResource.createResourceProperties(this.getCms(), fullResourceName, CmsResourceTypeFolder.getStaticTypeName(), title);
            this.getCms().createResource(fullResourceName, OpenCms.getResourceManager().getResourceType(CmsResourceTypeFolder.getStaticTypeName()).getTypeId(), null, properties);
            this.setParamResource(fullResourceName);
            return true;
        }
        catch (Throwable e) {
            this.setParamMessage(Messages.get().getBundle(this.getLocale()).key("ERR_CREATE_FOLDER_0"));
            this.includeErrorpage((CmsWorkplace)this, e);
            return false;
        }
    }

    @Override
    public void actionDialog() throws JspException, ServletException, IOException {
        if (this.getAction() == 8 && this.actionCreateResource()) {
            this.actionEditProperties();
            return;
        }
        super.actionDialog();
    }

    public void actionEditProperties() throws IOException, JspException, ServletException {
        boolean createIndex;
        boolean editProps = Boolean.valueOf(this.getParamNewResourceEditProps());
        String indexPageType = this.getParamSelectedType();
        boolean bl = createIndex = CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)indexPageType) && !indexPageType.equals(ID_NO_INDEX_PAGE);
        if (editProps) {
            HashMap<String, String[]> params = new HashMap<String, String[]>();
            params.put("resource", new String[]{this.getParamResource()});
            if (createIndex) {
                params.put("dialogmode", new String[]{"wizardcreateindex"});
                params.put(PARAM_INDEX_PAGE_TYPE, new String[]{indexPageType});
            } else {
                params.put("dialogmode", new String[]{"wizard"});
            }
            this.sendForward("/system/workplace/commons/property.jsp", params);
        } else if (createIndex) {
            String newFolder = this.getParamResource();
            if (!newFolder.endsWith("/")) {
                newFolder = newFolder + "/";
            }
            this.getSettings().setExplorerResource(newFolder, this.getCms());
            String newUri = "/system/workplace/commons/" + OpenCms.getWorkplaceManager().getExplorerTypeSetting(indexPageType).getNewResourceUri();
            CmsUriSplitter splitter = new CmsUriSplitter(newUri);
            Map params = CmsRequestUtil.createParameterMap((String)splitter.getQuery());
            params.put("dialogmode", new String[]{"wizardcreateindex"});
            params.put("action", new String[]{"newform"});
            this.sendForward(splitter.getPrefix(), params);
        } else {
            ArrayList<String> folderList = new ArrayList<String>(1);
            folderList.add(CmsResource.getParentFolder((String)this.getParamResource()));
            this.getJsp().getRequest().setAttribute("__CmsWorkplace.RELOADTREE", folderList);
            this.actionCloseDialog();
        }
    }

    public String getParamCurrentFolder() {
        if (CmsStringUtil.isEmpty((String)this.m_paramCurrentFolder)) {
            return this.computeCurrentFolder();
        }
        return this.m_paramCurrentFolder;
    }

    public String getParamNewResourceEditProps() {
        return this.m_paramNewResourceEditProps;
    }

    @Override
    public String getParamSelectedType() {
        String item = super.getParamSelectedType();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)item)) {
            boolean existNoIndex = false;
            List<String> availableResTypes = this.getAvailableResTypes();
            for (String entry : availableResTypes) {
                if (entry.equals(NAME_NO_INDEX_PAGE)) {
                    existNoIndex = true;
                }
                if (!entry.startsWith(DEFAULT_MARKER)) continue;
                return entry.substring(1, entry.length());
            }
            if (existNoIndex) {
                return ID_NO_INDEX_PAGE;
            }
            if (availableResTypes.size() > 0) {
                return availableResTypes.get(0);
            }
            return null;
        }
        return item;
    }

    @Override
    public String paramsAsHidden() {
        ArrayList<String> exclude = new ArrayList<String>();
        exclude.add("newresourceeditprops");
        exclude.add("resource");
        return this.paramsAsHidden(exclude);
    }

    public void setParamCurrentFolder(String paramCurrentFolder) {
        this.m_paramCurrentFolder = paramCurrentFolder;
    }

    public void setParamNewResourceEditProps(String paramNewResourceEditProps) {
        this.m_paramNewResourceEditProps = paramNewResourceEditProps;
    }

    protected String computeFullResourceName() {
        String currentFolder = this.getParamCurrentFolder();
        if (CmsStringUtil.isEmpty((String)currentFolder)) {
            currentFolder = this.computeCurrentFolder();
        }
        String translatedFoldername = OpenCms.getResourceManager().getFolderTranslator().translateResource(this.getParamResource());
        return currentFolder + translatedFoldername;
    }

    @Override
    protected String customHtmlBeforeList() {
        StringBuffer result = new StringBuffer();
        result.append(this.dialogBlockStart(this.key("GUI_NEWFOLDER_OPTIONS_0")));
        result.append("<table border=\"0\" width=\"100%\">\n");
        result.append("\t<tr>\n");
        result.append("\t\t<td style=\"white-space: nowrap;\" unselectable=\"on\">");
        result.append(this.key("GUI_RESOURCE_NAME_0"));
        result.append("</td>\n");
        result.append("\t\t<td class=\"maxwidth\"><input name=\"");
        result.append("resource");
        result.append("\" id=\"newresfield\" type=\"text\" value=\"");
        String resource = this.getParamResource();
        if (resource == null) {
            resource = "";
        }
        result.append(resource);
        result.append("\" class=\"maxwidth\" onkeyup=\"checkValue();\" onchange=\"checkValue();\" onpaste=\"setTimeout(checkValue,4);\" ></td>\n");
        result.append("\t</tr>\n");
        result.append("\t<tr>\n");
        result.append("\t\t<td>&nbsp;</td>\n");
        result.append("\t\t<td style=\"white-space: nowrap;\" unselectable=\"on\" class=\"maxwidth\">\n");
        result.append("\t\t\t<input name=\"");
        result.append("newresourceeditprops");
        result.append("\" id=\"newresedit\" type=\"checkbox\" value=\"true\"");
        result.append(" onclick=\"toggleButtonLabel();\"");
        if (Boolean.valueOf(this.getParamNewResourceEditProps()).booleanValue()) {
            result.append(" checked");
        }
        result.append(">&nbsp;");
        result.append(this.key("GUI_NEWFOLDER_EDITPROPERTIES_0"));
        result.append("\n");
        result.append("\t\t</td>\n");
        result.append("\t</tr>\n");
        result.append("</table>\n");
        result.append(this.dialogBlockEnd());
        result.append("<br/>\n");
        return result.toString();
    }

    @Override
    protected String customHtmlEnd() {
        StringBuffer result = new StringBuffer(256);
        result.append(super.customHtmlEnd());
        result.append("<script type='text/javascript'>\n");
        result.append("\ttoggleButtonLabel();\n");
        result.append("\tcheckValue();\n");
        result.append("</script>");
        return result.toString();
    }

    @Override
    protected String customHtmlStart() {
        StringBuffer result = new StringBuffer(256);
        result.append(super.customHtmlStart());
        result.append("<script type='text/javascript'>\n");
        result.append("function toggleButtonLabel() {\n");
        result.append("\tvar theCheckBox = document.getElementById('newresedit');\n");
        result.append("\tvar theButton = document.getElementById('nextButton');\n");
        result.append("\tif (theCheckBox.checked == true) {\n");
        result.append("\t\ttheButton.value = '" + this.key("GUI_BUTTON_CONTINUE_0") + "';\n");
        result.append("\t} else {\n");
        result.append("\t\ttheButton.value = '" + this.key("GUI_BUTTON_ENDWIZARD_0") + "';\n");
        result.append("\t}\n");
        result.append("}\n\n");
        result.append("function checkValue() {\n");
        result.append("\tvar resName = document.getElementById(\"newresfield\").value;\n");
        result.append("\tvar theButton = document.getElementById(\"nextButton\");\n");
        result.append("\tif (resName.length == 0) {\n");
        result.append("\t\tif (theButton.disabled == false) {\n");
        result.append("\t\t\ttheButton.disabled = true;\n");
        result.append("\t\t}\n");
        result.append("\t} else {\n");
        result.append("\t\tif (theButton.disabled == true) {\n");
        result.append("\t\t\ttheButton.disabled = false;\n");
        result.append("\t\t}\n");
        result.append("\t}\n");
        result.append("}\n");
        result.append("</script>");
        return result.toString();
    }

    protected void dialogButtonsHtml(StringBuffer result, int button, String attribute) {
        switch (button) {
            case 10: {
                result.append("<input name=\"set\" type=\"button\" value=\"");
                result.append(this.key("GUI_BUTTON_CONTINUE_0") + "\"");
                if (attribute.toLowerCase().indexOf("onclick") == -1) {
                    result.append(" onclick=\"submitAction('continue', form, '" + this.getListId() + "-form');\"");
                }
                result.append(" class=\"dialogbutton\"");
                result.append(" id=\"nextButton\"");
                result.append(" disabled=\"disabled\"");
                result.append(attribute);
                result.append(">\n");
                break;
            }
            default: {
                super.dialogButtonsHtml(result, button, attribute);
            }
        }
    }

    protected List<String> getAvailableResTypes() {
        String availableResTypes = null;
        try {
            String propResTypes = this.getCms().readPropertyObject(this.getParamCurrentFolder(), PROPERTY_RESTYPES_INDEXPAGE, true).getValue();
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)propResTypes)) {
                availableResTypes = propResTypes;
            }
        }
        catch (CmsException propResTypes) {
            // empty catch block
        }
        if (availableResTypes == null) {
            try {
                I_CmsResourceType resType = OpenCms.getResourceManager().getResourceType(CmsResourceTypeFolder.getStaticTypeName());
                String folderResTypes = ((CmsResourceTypeFolder)resType).getIndexPageTypes();
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)folderResTypes)) {
                    availableResTypes = folderResTypes;
                }
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
        }
        if (availableResTypes == null) {
            availableResTypes = DEFAULT_AVAILABLE;
        }
        return CmsStringUtil.splitAsList((String)availableResTypes, (char)'|', (boolean)true);
    }

    @Override
    protected List<CmsListItem> getListItems() {
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        List<String> newResTypes = this.getAvailableResTypes();
        for (String resType : newResTypes) {
            if (resType.startsWith(DEFAULT_MARKER)) {
                resType = resType.substring(1, resType.length());
            }
            if (resType.equals(NAME_NO_INDEX_PAGE)) {
                CmsListItem item = this.getList().newItem(ID_NO_INDEX_PAGE);
                item.set("nrcn", this.key("GUI_NEWFOLDER_LIST_NO_INDEX_0"));
                ret.add(item);
                continue;
            }
            CmsExplorerTypeSettings set = OpenCms.getWorkplaceManager().getExplorerTypeSetting(resType);
            if (set == null) continue;
            CmsListItem item = this.getList().newItem(set.getName());
            item.set("nrcn", this.key(set.getKey()));
            item.set("nrci", "<img src=\"" + CmsNewResourceFolder.getSkinUri() + "filetypes/" + set.getIcon() + "\" style=\"width: 16px; height: 16px;\" />");
            ret.add(item);
        }
        return ret;
    }

    @Override
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        if ("continue".equals(this.getParamAction())) {
            this.setAction(8);
        } else if ("newform".equals(this.getParamAction())) {
            CmsDefaultUserSettings userSettings = OpenCms.getWorkplaceManager().getDefaultUserSettings();
            Boolean editPropsChecked = userSettings.getNewFolderEditProperties();
            this.setParamNewResourceEditProps(editPropsChecked.toString());
        }
        String title = null;
        CmsExplorerTypeSettings set = OpenCms.getWorkplaceManager().getExplorerTypeSetting(CmsResourceTypeFolder.getStaticTypeName());
        if (set != null && CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)set.getTitleKey())) {
            title = this.getMessages().key(set.getTitleKey(), true);
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(title)) {
            title = this.key("GUI_NEWRESOURCE_FOLDER_0");
        }
        this.setParamTitle(title);
    }

    @Override
    protected void setColumns(CmsListMetadata metadata) {
        super.setColumns(metadata);
        CmsListColumnDefinition def = metadata.getColumnDefinition("nrcn");
        def.setListItemComparator(LIST_ITEM_COMPARATOR);
    }
}

