/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.explorer;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsProperty;
import org.opencms.file.types.CmsResourceTypePointer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.OpenCms;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.explorer.CmsNewResource;
import org.opencms.workplace.explorer.Messages;

public class CmsNewResourcePointer
extends CmsNewResource {
    public static final String PARAM_LINKTARGET = "linktarget";
    private String m_paramLinkTarget;

    public CmsNewResourcePointer(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsNewResourcePointer(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    @Override
    public void actionCreateResource() throws JspException {
        try {
            String title = this.computeNewTitleProperty();
            String fullResourceName = this.computeFullResourceName();
            List<CmsProperty> properties = this.createResourceProperties(fullResourceName, CmsResourceTypePointer.getStaticTypeName(), title);
            String linkTarget = this.getParamLinkTarget();
            if (linkTarget == null) {
                linkTarget = "";
            }
            int pointerId = OpenCms.getResourceManager().getResourceType(CmsResourceTypePointer.getStaticTypeName()).getTypeId();
            this.getCms().createResource(fullResourceName, pointerId, linkTarget.getBytes(), properties);
            this.setParamResource(fullResourceName);
            this.setResourceCreated(true);
        }
        catch (Throwable e) {
            this.setParamMessage(Messages.get().getBundle(this.getLocale()).key("ERR_CREATE_LINK_0"));
            this.includeErrorpage((CmsWorkplace)this, e);
        }
    }

    public String getParamLinkTarget() {
        return this.m_paramLinkTarget;
    }

    public void setParamLinkTarget(String linkTarget) {
        this.m_paramLinkTarget = linkTarget;
    }

    @Override
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        this.setParamDialogtype("newresource");
        if ("ok".equals(this.getParamAction())) {
            this.setAction(3);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else {
            this.setAction(0);
            this.setParamTitle(this.key("GUI_NEWRESOURCE_POINTER_0"));
        }
    }
}

