/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.explorer;

import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.explorer.CmsNewResource;

public class CmsNewResourceXmlContent
extends CmsNewResource {
    public static final int ACTION_CHECKMODEL = 210;
    public static final int ACTION_CHOOSEMODEL = 200;
    public static final String DIALOG_CHECKMODEL = "checkmodel";
    public static final String DIALOG_CHOOSEMODEL = "choosemodel";
    private static final Log LOG = CmsLog.getLog(CmsNewResourceXmlContent.class);
    public static final String PARAM_MODELFILE = "modelfile";
    public static final String VALUE_NONE = "none";
    private String m_paramModelFile;

    public CmsNewResourceXmlContent(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsNewResourceXmlContent(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    @Override
    public void actionCreateResource() throws JspException {
        try {
            String title = this.computeNewTitleProperty();
            String fullResourceName = this.computeFullResourceName();
            fullResourceName = this.appendSuffixHtml(fullResourceName, false);
            I_CmsResourceType resType = OpenCms.getResourceManager().getResourceType(this.getParamNewResourceType());
            List<CmsProperty> properties = this.createResourceProperties(fullResourceName, resType.getTypeName(), title);
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.getParamModelFile()) && !VALUE_NONE.equals(this.getParamModelFile())) {
                this.getCms().getRequestContext().setAttribute(CmsRequestContext.ATTRIBUTE_MODEL, (Object)this.getParamModelFile());
            }
            this.getCms().createResource(fullResourceName, resType.getTypeId(), null, properties);
            this.setParamResource(fullResourceName);
            this.setResourceCreated(true);
        }
        catch (Throwable e) {
            this.includeErrorpage((CmsWorkplace)this, e);
        }
    }

    public String getDialogUri() {
        if (!this.useNewStyle()) {
            return this.getJsp().link("/system/workplace/commons/newresource_xmlcontent.jsp");
        }
        return super.getDialogUri();
    }

    public String getParamModelFile() {
        return this.m_paramModelFile;
    }

    public boolean hasModelFiles() {
        return this.getModelFiles().size() > 0;
    }

    public void setParamModelFile(String paramMasterFile) {
        this.m_paramModelFile = paramMasterFile;
    }

    protected List<CmsResource> getModelFiles() {
        return CmsResourceTypeXmlContent.getModelFiles((CmsObject)this.getCms(), (String)this.getSettings().getExplorerResource(), (String)this.getParamNewResourceType());
    }

    @Override
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        this.setParamDialogtype("newresource");
        if ("ok".equals(this.getParamAction())) {
            this.setAction(3);
        } else if (DIALOG_CHECKMODEL.equals(this.getParamAction())) {
            if (this.hasModelFiles()) {
                this.setAction(200);
                HashMap<String, String[]> params = new HashMap<String, String[]>(6);
                params.put("resource", new String[]{this.getParamResource()});
                params.put("newresourcetype", new String[]{this.getParamNewResourceType()});
                params.put("title", new String[]{this.getParamTitle()});
                if (CmsStringUtil.isNotEmpty((String)this.getParamNewResourceEditProps())) {
                    params.put("newresourceeditprops", new String[]{this.getParamNewResourceEditProps()});
                }
                if (CmsStringUtil.isNotEmpty((String)this.getParamAppendSuffixHtml())) {
                    params.put("appendsuffixhtml", new String[]{this.getParamAppendSuffixHtml()});
                }
                if (CmsStringUtil.isNotEmpty((String)this.getParamOriginalParams())) {
                    params.put("originalparams", new String[]{this.getParamOriginalParams()});
                }
                try {
                    this.sendForward("/system/workplace/commons/newresource_xmlcontent_modelfile.jsp", params);
                }
                catch (Exception e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            } else {
                this.setAction(110);
            }
        } else if ("submitform".equals(this.getParamAction())) {
            this.setAction(110);
        } else if ("newform".equals(this.getParamAction())) {
            this.setAction(100);
            this.setParamTitle(this.getTitle());
            this.setInitialResourceName();
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else {
            this.setAction(0);
            this.setParamTitle(this.key("GUI_NEWRESOURCE_XMLCONTENT_0"));
            this.setInitialResourceName();
        }
    }
}

