/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.explorer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.CmsNewResource;

public class CmsNewResourceXmlPage
extends CmsNewResource {
    public static final String PARAM_BODYFILE = "bodyfile";
    public static final String PARAM_SUFFIXCHECK = "suffixcheck";
    public static final String PARAM_TEMPLATE = "template";
    private static final Log LOG = CmsLog.getLog(CmsNewResourceXmlPage.class);
    private String m_paramBodyFile;
    private String m_paramSuffixCheck;
    private String m_paramTemplate;

    public CmsNewResourceXmlPage(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsNewResourceXmlPage(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public static TreeMap<String, String> getBodies(CmsObject cms, String currWpPath) throws CmsException {
        return CmsNewResourceXmlPage.getElements(cms, "default_bodies/", currWpPath, true);
    }

    public static TreeMap<String, String> getBodies(CmsObject cms, String currWpPath, boolean emptyMap) throws CmsException {
        return CmsNewResourceXmlPage.getElements(cms, "default_bodies/", currWpPath, emptyMap);
    }

    public static TreeMap<String, String> getTemplates(CmsObject cms, String currWpPath) throws CmsException {
        return CmsNewResourceXmlPage.getElements(cms, "templates/", currWpPath, true);
    }

    public static TreeMap<String, String> getTemplates(CmsObject cms, String currWpPath, boolean emptyMap) throws CmsException {
        return CmsNewResourceXmlPage.getElements(cms, "templates/", currWpPath, emptyMap);
    }

    protected static TreeMap<String, String> getElements(CmsObject cms, String elementFolder, String currWpPath, boolean emptyMap) throws CmsException {
        TreeMap<String, String> elements = new TreeMap<String, String>();
        TreeMap<String, String> allElements = new TreeMap<String, String>();
        if (CmsStringUtil.isNotEmpty((String)currWpPath)) {
            currWpPath = cms.getRequestContext().addSiteRoot(currWpPath);
        }
        List modules = cms.getSubFolders("/system/modules/", CmsResourceFilter.IGNORE_EXPIRATION);
        for (int i = 0; i < modules.size(); ++i) {
            List moduleTemplateFiles;
            block13: {
                moduleTemplateFiles = new ArrayList();
                String folder = cms.getSitePath((CmsResource)modules.get(i));
                try {
                    moduleTemplateFiles = cms.getFilesInFolder(folder + elementFolder, CmsResourceFilter.DEFAULT.addRequireVisible());
                }
                catch (CmsException e) {
                    if (!LOG.isDebugEnabled()) break block13;
                    LOG.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
            for (int j = 0; j < moduleTemplateFiles.size(); ++j) {
                String folderProp;
                String title;
                CmsFile templateFile;
                block14: {
                    templateFile = (CmsFile)moduleTemplateFiles.get(j);
                    title = null;
                    folderProp = null;
                    try {
                        title = cms.readPropertyObject(cms.getSitePath((CmsResource)templateFile), "Title", false).getValue();
                        folderProp = cms.readPropertyObject((CmsResource)templateFile, "folders.available", false).getValue();
                    }
                    catch (CmsException e) {
                        if (!LOG.isInfoEnabled()) break block14;
                        LOG.info((Object)e);
                    }
                }
                boolean isInFolder = false;
                if (CmsStringUtil.isNotEmpty((String)currWpPath) && CmsStringUtil.isNotEmpty(folderProp)) {
                    List folders = CmsStringUtil.splitAsList((String)folderProp, (char)',');
                    for (int k = 0; k < folders.size(); ++k) {
                        String checkFolder = (String)folders.get(k);
                        if (!currWpPath.startsWith(checkFolder)) continue;
                        isInFolder = true;
                        break;
                    }
                } else {
                    isInFolder = true;
                }
                if (title == null) {
                    title = templateFile.getName();
                }
                String path = cms.getSitePath((CmsResource)templateFile);
                if (isInFolder) {
                    elements.put(title, path);
                }
                allElements.put(title, path);
            }
        }
        if (!emptyMap && elements.size() < 1) {
            return allElements;
        }
        return elements;
    }

    @Override
    public void actionCreateResource() throws JspException {
        try {
            String title = this.computeNewTitleProperty();
            String fullResourceName = this.computeFullResourceName();
            boolean forceSuffix = false;
            if (CmsStringUtil.isEmpty((String)this.getParamSuffixCheck())) {
                forceSuffix = true;
            }
            fullResourceName = this.appendSuffixHtml(fullResourceName, forceSuffix);
            byte[] bodyFileBytes = null;
            bodyFileBytes = CmsStringUtil.isEmpty((String)this.getParamBodyFile()) ? "".getBytes() : this.getCms().readFile(this.getParamBodyFile(), CmsResourceFilter.IGNORE_EXPIRATION).getContents();
            ArrayList<CmsProperty> properties = new ArrayList<CmsProperty>(4);
            properties.add(new CmsProperty(PARAM_TEMPLATE, this.getParamTemplate(), null));
            properties.addAll(this.createResourceProperties(fullResourceName, CmsResourceTypeXmlPage.getStaticTypeName(), title));
            int xmlPageId = OpenCms.getResourceManager().getResourceType(CmsResourceTypeXmlPage.getStaticTypeName()).getTypeId();
            this.getCms().createResource(fullResourceName, xmlPageId, bodyFileBytes, properties);
            this.setParamResource(fullResourceName);
            this.setResourceCreated(true);
        }
        catch (Throwable e) {
            this.includeErrorpage((CmsWorkplace)this, e);
        }
    }

    public String buildSelectBodyFile(String attributes) {
        TreeMap<String, String> bodies;
        ArrayList<String> values;
        ArrayList<String> options;
        block4: {
            options = new ArrayList<String>();
            values = new ArrayList<String>();
            bodies = null;
            try {
                bodies = CmsNewResourceXmlPage.getBodies(this.getCms(), this.getParamCurrentFolder(), false);
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) break block4;
                LOG.info((Object)e);
            }
        }
        if (bodies == null) {
            return "";
        }
        for (Map.Entry<String, String> entry : bodies.entrySet()) {
            String key = entry.getKey();
            String path = entry.getValue();
            options.add(key);
            values.add(path);
        }
        return CmsNewResourceXmlPage.buildSelect((String)attributes, options, values, (int)-1, (boolean)false);
    }

    public String buildSelectTemplates(String attributes) {
        TreeMap<String, String> templates;
        ArrayList<String> values;
        ArrayList<String> options;
        block4: {
            options = new ArrayList<String>();
            values = new ArrayList<String>();
            templates = null;
            try {
                templates = CmsNewResourceXmlPage.getTemplates(this.getCms(), this.getParamCurrentFolder(), false);
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) break block4;
                LOG.info((Object)e);
            }
        }
        if (templates == null) {
            return "";
        }
        for (Map.Entry<String, String> entry : templates.entrySet()) {
            String key = entry.getKey();
            String path = entry.getValue();
            options.add(key);
            values.add(path);
        }
        return CmsNewResourceXmlPage.buildSelect((String)attributes, options, values, (int)-1, (boolean)false);
    }

    public String getParamBodyFile() {
        return this.m_paramBodyFile;
    }

    public String getParamSuffixCheck() {
        return this.m_paramSuffixCheck;
    }

    public String getParamTemplate() {
        return this.m_paramTemplate;
    }

    public void setParamBodyFile(String bodyFile) {
        this.m_paramBodyFile = bodyFile;
    }

    public void setParamSuffixCheck(String paramSuffixCheck) {
        this.m_paramSuffixCheck = paramSuffixCheck;
    }

    public void setParamTemplate(String template) {
        this.m_paramTemplate = template;
    }

    @Override
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        this.setParamDialogtype("newresource");
        if ("ok".equals(this.getParamAction())) {
            this.setAction(3);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else {
            this.setInitialResourceName();
            this.setAction(0);
            String title = null;
            CmsExplorerTypeSettings set = OpenCms.getWorkplaceManager().getExplorerTypeSetting(CmsResourceTypeXmlPage.getStaticTypeName());
            if (set != null && CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)set.getTitleKey())) {
                title = this.getMessages().key(set.getTitleKey(), true);
            }
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(title)) {
                title = this.key("GUI_NEWRESOURCE_XMLPAGE_0");
            }
            this.setParamTitle(title);
        }
    }
}

