/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.help;

import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsResource;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.jsp.CmsJspNavElement;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.workplace.help.Messages;

public final class CmsHelpNavigationListView {
    private int m_depth;
    private CmsJspActionElement m_jsp;
    private String m_navRootPath;

    public CmsHelpNavigationListView(CmsJspActionElement jsp) {
        this.m_jsp = jsp;
        this.m_navRootPath = this.m_jsp.getCmsObject().getRequestContext().getUri();
    }

    public CmsHelpNavigationListView(PageContext context, HttpServletRequest request, HttpServletResponse response) {
        this(new CmsJspActionElement(context, request, response));
    }

    private static String getSpaces(int n) {
        StringBuffer result = new StringBuffer(n);
        for (n = Math.max(n, 0); n > 0; --n) {
            result.append(' ');
        }
        return result.toString();
    }

    public String createNavigation() {
        StringBuffer buffer = new StringBuffer(2048);
        int endlevel = this.calculateEndLevel();
        String spaces = CmsHelpNavigationListView.getSpaces((endlevel - this.m_depth) * 2);
        if (this.m_navRootPath != null) {
            buffer.append("\n").append(spaces).append("<p>\n");
            buffer.append(spaces).append("  <ul>\n");
            List navElements = this.m_jsp.getNavigation().getSiteNavigation(this.m_navRootPath, endlevel);
            if (navElements.size() > 0) {
                this.createNavigationInternal(buffer, navElements);
            }
            buffer.append(spaces).append("  </ul>\n");
            buffer.append(spaces).append("</p>");
            return buffer.toString();
        }
        CmsIllegalArgumentException ex = new CmsIllegalArgumentException(Messages.get().container("GUI_HELP_ERR_SITEMAP_MISSING_PARAM_1", (Object)"navRootPath"));
        throw ex;
    }

    public int getDepth() {
        return this.m_depth;
    }

    public String getSiteRootPath() {
        return this.m_navRootPath;
    }

    public void setDepth(int depth) {
        this.m_depth = depth;
    }

    public void setNavigationRootPath(String navRootPath) {
        this.m_navRootPath = navRootPath;
    }

    private int calculateEndLevel() {
        int result = 0;
        if (this.m_navRootPath != null) {
            StringTokenizer counter = new StringTokenizer(this.m_navRootPath, "/", false);
            result = counter.countTokens() - 1;
            if (!CmsResource.isFolder((String)this.m_navRootPath)) {
                --result;
            }
            result += this.m_depth;
        }
        if (result < 0) {
            result = 0;
        }
        return result;
    }

    private void createNavigationInternal(StringBuffer buffer, List<CmsJspNavElement> navElements) {
        CmsJspNavElement element = navElements.remove(0);
        int elementLevel = element.getNavTreeLevel();
        String spacing = CmsHelpNavigationListView.getSpaces(elementLevel * 2);
        buffer.append(spacing).append("<li>\n");
        buffer.append(spacing).append("  <a href=\"");
        buffer.append(this.m_jsp.link(element.getResourceName()));
        buffer.append("\" title=\"");
        buffer.append(element.getNavText());
        buffer.append("\"");
        if (elementLevel == 1) {
            buffer.append(" class=\"bold\"");
        }
        buffer.append(">");
        buffer.append(element.getNavText());
        buffer.append("</a>\n");
        if (!navElements.isEmpty()) {
            CmsJspNavElement child = navElements.get(0);
            int childLevel = child.getNavTreeLevel();
            if (elementLevel < childLevel) {
                buffer.append(spacing).append("  <ul>\n");
            } else if (elementLevel == childLevel) {
                buffer.append(spacing).append("</li>\n");
            } else {
                buffer.append(spacing).append("  </li>\n").append(spacing).append("</ul>\n");
            }
            this.createNavigationInternal(buffer, navElements);
        } else {
            buffer.append(spacing).append("  </li>\n").append(spacing).append("</ul>\n");
        }
    }
}

