/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.collectors.I_CmsResourceCollector;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDateMacroFormatter;
import org.opencms.workplace.list.CmsListEditResourceAction;
import org.opencms.workplace.list.CmsListExplorerColumn;
import org.opencms.workplace.list.CmsListIndependentAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemActionIconComparator;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOpenResourceAction;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.CmsListResourceLockAction;
import org.opencms.workplace.list.CmsListResourceProjStateAction;
import org.opencms.workplace.list.CmsListResourceTypeIconAction;
import org.opencms.workplace.list.CmsListState;
import org.opencms.workplace.list.I_CmsListResourceCollector;
import org.opencms.workplace.list.Messages;

public abstract class A_CmsListExplorerDialog
extends A_CmsListDialog {
    public static final String LIST_ACTION_EDIT = "eae";
    public static final String LIST_ACTION_LOCKICON = "eal";
    public static final String LIST_ACTION_PROJSTATEICON = "eaps";
    public static final String LIST_ACTION_TYPEICON = "eai";
    public static final String LIST_COLUMN_DATECREATE = "ecdc";
    public static final String LIST_COLUMN_DATEEXP = "ecde";
    public static final String LIST_COLUMN_DATELASTMOD = "ecdl";
    public static final String LIST_COLUMN_DATEREL = "ecdr";
    public static final String LIST_COLUMN_EDIT = "ece";
    public static final String LIST_COLUMN_LOCKEDBY = "eclb";
    public static final String LIST_COLUMN_LOCKICON = "ecli";
    public static final String LIST_COLUMN_NAME = "ecn";
    public static final String LIST_COLUMN_PERMISSIONS = "ecp";
    public static final String LIST_COLUMN_PROJSTATEICON = "ecpi";
    public static final String LIST_COLUMN_ROOT_PATH = "crp";
    public static final String LIST_COLUMN_SITE = "ecsi";
    public static final String LIST_COLUMN_SIZE = "ecz";
    public static final String LIST_COLUMN_STATE = "ecs";
    public static final String LIST_COLUMN_TITLE = "ect";
    public static final String LIST_COLUMN_TYPE = "ecy";
    public static final String LIST_COLUMN_TYPEICON = "ecti";
    public static final String LIST_COLUMN_USERCREATE = "ecuc";
    public static final String LIST_COLUMN_USERLASTMOD = "ecul";
    public static final String LIST_DEFACTION_OPEN = "edo";
    public static final String PARAM_SHOW_EXPLORER = "showexplorer";
    public static final String PATH_EXPLORER_LIST = "/system/workplace/commons/list-explorer.jsp";
    private static final Log LOG = CmsLog.getLog(A_CmsListExplorerDialog.class);
    private Map<Integer, Boolean> m_colVisibilities;
    private String m_paramShowexplorer;
    private CmsResourceUtil m_resourceUtil;

    protected A_CmsListExplorerDialog(CmsJspActionElement jsp, String listId, CmsMessageContainer listName) {
        this(jsp, listId, listName, LIST_COLUMN_NAME, CmsListOrderEnum.ORDER_ASCENDING, LIST_COLUMN_NAME);
    }

    protected A_CmsListExplorerDialog(CmsJspActionElement jsp, String listId, CmsMessageContainer listName, String sortedColId, CmsListOrderEnum sortOrder, String searchableColId) {
        super(jsp, listId, listName, sortedColId, sortOrder, searchableColId);
    }

    @Override
    public void executeListIndepActions() {
        if (this.getParamListAction().equals("iaes")) {
            HashMap<String, String[]> params = new HashMap<String, String[]>();
            params.put("action", new String[]{"initial"});
            params.putAll(this.getToolManager().getCurrentTool((CmsWorkplace)this).getHandler().getParameters((CmsWorkplace)this));
            this.getSettings().setCollector((I_CmsResourceCollector)this.getCollector());
            this.getSettings().setExplorerMode("listview");
            this.getSettings().setExplorerProjectId(this.getProject().getUuid());
            this.setShowExplorer(true);
            try {
                this.getToolManager().jspForwardPage((CmsWorkplace)this, PATH_EXPLORER_LIST, params);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            super.executeListIndepActions();
        }
    }

    public abstract I_CmsListResourceCollector getCollector();

    public String getParamShowexplorer() {
        return this.m_paramShowexplorer;
    }

    public CmsResourceUtil getResourceUtil() {
        block3: {
            if (this.m_resourceUtil == null) {
                try {
                    this.m_resourceUtil = new CmsResourceUtil(OpenCms.initCmsObject((CmsObject)this.getCms()));
                    this.m_resourceUtil.setReferenceProject(this.getProject());
                }
                catch (CmsException ex) {
                    if (!LOG.isErrorEnabled()) break block3;
                    LOG.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
                }
            }
        }
        return this.m_resourceUtil;
    }

    public CmsResourceUtil getResourceUtil(CmsListItem item) {
        CmsResourceUtil resUtil = this.getResourceUtil();
        resUtil.setResource(this.getCollector().getResource(this.getCms(), item));
        return resUtil;
    }

    public void setParamShowexplorer(String showExplorer) {
        this.m_paramShowexplorer = showExplorer;
    }

    protected void applyColumnVisibilities() {
        this.setColumnVisibilities();
        CmsListMetadata metadata = this.getList().getMetadata();
        metadata.getColumnDefinition(LIST_COLUMN_SITE).setVisible(this.isColumnVisible(LIST_COLUMN_SITE.hashCode()));
        metadata.getColumnDefinition(LIST_COLUMN_EDIT).setVisible(this.isColumnVisible(LIST_COLUMN_EDIT.hashCode()));
        metadata.getColumnDefinition(LIST_COLUMN_TYPEICON).setVisible(this.isColumnVisible(LIST_COLUMN_TYPEICON.hashCode()));
        metadata.getColumnDefinition(LIST_COLUMN_LOCKICON).setVisible(this.isColumnVisible(LIST_COLUMN_LOCKICON.hashCode()));
        metadata.getColumnDefinition(LIST_COLUMN_PROJSTATEICON).setVisible(this.isColumnVisible(LIST_COLUMN_PROJSTATEICON.hashCode()));
        metadata.getColumnDefinition(LIST_COLUMN_NAME).setVisible(this.isColumnVisible(LIST_COLUMN_NAME.hashCode()));
        metadata.getColumnDefinition(LIST_COLUMN_TITLE).setVisible(this.isColumnVisible(1));
        metadata.getColumnDefinition(LIST_COLUMN_TYPE).setVisible(this.isColumnVisible(2));
        metadata.getColumnDefinition(LIST_COLUMN_SIZE).setVisible(this.isColumnVisible(8));
        metadata.getColumnDefinition(LIST_COLUMN_PERMISSIONS).setVisible(this.isColumnVisible(128));
        metadata.getColumnDefinition(LIST_COLUMN_DATELASTMOD).setVisible(this.isColumnVisible(4));
        metadata.getColumnDefinition(LIST_COLUMN_USERLASTMOD).setVisible(this.isColumnVisible(2048));
        metadata.getColumnDefinition(LIST_COLUMN_DATECREATE).setVisible(this.isColumnVisible(1024));
        metadata.getColumnDefinition(LIST_COLUMN_USERCREATE).setVisible(this.isColumnVisible(32));
        metadata.getColumnDefinition(LIST_COLUMN_DATEREL).setVisible(this.isColumnVisible(4096));
        metadata.getColumnDefinition(LIST_COLUMN_DATEEXP).setVisible(this.isColumnVisible(8192));
        metadata.getColumnDefinition(LIST_COLUMN_STATE).setVisible(this.isColumnVisible(16));
        metadata.getColumnDefinition(LIST_COLUMN_LOCKEDBY).setVisible(this.isColumnVisible(256));
    }

    @Override
    protected String defaultActionHtmlStart() {
        StringBuffer result = new StringBuffer(2048);
        result.append(this.htmlStart(null));
        result.append(this.getList().listJs());
        result.append(CmsListExplorerColumn.getExplorerStyleDef());
        result.append(this.bodyStart("dialog", null));
        result.append(this.dialogStart());
        result.append(this.dialogContentStart(this.getParamTitle()));
        return result.toString();
    }

    @Override
    protected void executeSelectPage() {
        super.executeSelectPage();
        this.getSettings().setExplorerPage(this.getList().getCurrentPage());
    }

    @Override
    protected void fillList() {
        this.getListState().setPage(this.getSettings().getExplorerPage());
        super.fillList();
    }

    protected Map<String, String[]> getAdditionalParametersForExplorerForward() {
        return Collections.emptyMap();
    }

    protected Map<Integer, Boolean> getColVisibilities() {
        return this.m_colVisibilities;
    }

    @Override
    protected List<CmsListItem> getListItems() throws CmsException {
        if (this.getSettings().getExplorerMode() != null) {
            CmsListColumnDefinition nameCol = this.getList().getMetadata().getColumnDefinition(LIST_COLUMN_NAME);
            if (!this.getSettings().getExplorerMode().equals("galleryview") && !this.getSettings().getExplorerMode().equals("listview")) {
                nameCol.setName(org.opencms.workplace.explorer.Messages.get().container("GUI_INPUT_NAME_0"));
            } else {
                nameCol.setName(org.opencms.workplace.explorer.Messages.get().container("GUI_INPUT_PATH_0"));
            }
        }
        return this.getCollector().getListItems(null);
    }

    protected CmsListState getListStateForCollector() {
        CmsListState lstate = new CmsListState();
        if (this.getList() != null) {
            lstate = this.getListState();
        }
        switch (this.getAction()) {
            case 81: {
                if (this.getParamSearchFilter() == null) {
                    this.setParamSearchFilter("");
                }
                if (this.getParamSearchFilter().equals(lstate.getFilter())) {
                    lstate.setOrder(CmsListOrderEnum.ORDER_DESCENDING);
                } else {
                    lstate.setOrder(CmsListOrderEnum.ORDER_ASCENDING);
                }
                lstate.setFilter(this.getParamSearchFilter());
                break;
            }
            case 80: {
                lstate.setColumn(this.getParamSortCol());
                break;
            }
            case 82: {
                int page = Integer.valueOf(this.getParamPage());
                lstate.setPage(page);
                break;
            }
        }
        return lstate;
    }

    protected CmsProject getProject() {
        return this.getCms().getRequestContext().getCurrentProject();
    }

    @Override
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        if (this.getShowExplorer()) {
            CmsUUID projectId = this.getProject().getUuid();
            HashMap<String, String[]> params = new HashMap<String, String[]>();
            params.put("action", new String[]{"initial"});
            params.putAll(this.getToolManager().getCurrentTool((CmsWorkplace)this).getHandler().getParameters((CmsWorkplace)this));
            params.putAll(this.getAdditionalParametersForExplorerForward());
            this.getSettings().setExplorerProjectId(projectId);
            this.getSettings().setCollector((I_CmsResourceCollector)this.getCollector());
            this.getSettings().setExplorerMode("listview");
            try {
                this.setShowExplorer(true);
                this.getToolManager().jspForwardPage((CmsWorkplace)this, PATH_EXPLORER_LIST, params);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.setShowExplorer(false);
        }
    }

    protected boolean isColumnVisible(int colFlag) {
        Integer key = new Integer(colFlag);
        if (this.m_colVisibilities.containsKey(key)) {
            return this.m_colVisibilities.get(key);
        }
        return false;
    }

    @Override
    protected void setColumns(CmsListMetadata metadata) {
        this.setColumnVisibilities();
        CmsListColumnDefinition typeIconCol = new CmsListColumnDefinition(LIST_COLUMN_TYPEICON);
        typeIconCol.setName(Messages.get().container("GUI_EXPLORER_LIST_COLS_ICON_0"));
        typeIconCol.setHelpText(Messages.get().container("GUI_EXPLORER_LIST_COLS_ICON_HELP_0"));
        typeIconCol.setWidth("20");
        typeIconCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        typeIconCol.setListItemComparator(new CmsListItemActionIconComparator());
        CmsListResourceTypeIconAction resourceTypeIconAction = new CmsListResourceTypeIconAction(LIST_ACTION_TYPEICON);
        resourceTypeIconAction.setEnabled(false);
        typeIconCol.addDirectAction(resourceTypeIconAction);
        metadata.addColumn(typeIconCol);
        CmsListColumnDefinition editIconCol = new CmsListColumnDefinition(LIST_COLUMN_EDIT);
        editIconCol.setName(Messages.get().container("GUI_EXPLORER_LIST_COLS_EDIT_0"));
        editIconCol.setHelpText(Messages.get().container("GUI_EXPLORER_LIST_COLS_EDIT_HELP_0"));
        editIconCol.setWidth("20");
        editIconCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        CmsListEditResourceAction editAction = new CmsListEditResourceAction(LIST_ACTION_EDIT, LIST_COLUMN_NAME);
        editAction.setEnabled(true);
        editIconCol.addDirectAction(editAction);
        CmsListEditResourceAction noEditAction = new CmsListEditResourceAction("eaed", LIST_COLUMN_NAME);
        noEditAction.setEnabled(false);
        editIconCol.addDirectAction(noEditAction);
        metadata.addColumn(editIconCol);
        CmsListColumnDefinition lockIconCol = new CmsListColumnDefinition(LIST_COLUMN_LOCKICON);
        lockIconCol.setName(Messages.get().container("GUI_EXPLORER_LIST_COLS_LOCK_0"));
        lockIconCol.setWidth("20");
        lockIconCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        lockIconCol.setListItemComparator(new CmsListItemActionIconComparator());
        CmsListResourceLockAction resourceLockIconAction = new CmsListResourceLockAction(LIST_ACTION_LOCKICON);
        resourceLockIconAction.setEnabled(false);
        lockIconCol.addDirectAction(resourceLockIconAction);
        metadata.addColumn(lockIconCol);
        CmsListColumnDefinition projStateIconCol = new CmsListColumnDefinition(LIST_COLUMN_PROJSTATEICON);
        projStateIconCol.setName(Messages.get().container("GUI_EXPLORER_LIST_COLS_PROJSTATE_0"));
        projStateIconCol.setWidth("20");
        CmsListResourceProjStateAction resourceProjStateAction = new CmsListResourceProjStateAction(LIST_ACTION_PROJSTATEICON);
        resourceProjStateAction.setEnabled(false);
        projStateIconCol.addDirectAction(resourceProjStateAction);
        metadata.addColumn(projStateIconCol);
        CmsListExplorerColumn nameCol = new CmsListExplorerColumn(LIST_COLUMN_NAME);
        nameCol.setName(org.opencms.workplace.explorer.Messages.get().container("GUI_INPUT_PATH_0"));
        CmsListOpenResourceAction resourceOpenDefAction = new CmsListOpenResourceAction(LIST_DEFACTION_OPEN, LIST_COLUMN_ROOT_PATH);
        resourceOpenDefAction.setEnabled(true);
        nameCol.addDefaultAction(resourceOpenDefAction);
        metadata.addColumn(nameCol);
        nameCol.setPrintable(false);
        CmsListExplorerColumn rootPathCol = new CmsListExplorerColumn(LIST_COLUMN_ROOT_PATH);
        rootPathCol.setName(org.opencms.workplace.explorer.Messages.get().container("GUI_INPUT_NAME_0"));
        rootPathCol.setVisible(false);
        rootPathCol.setPrintable(true);
        metadata.addColumn(rootPathCol);
        CmsListExplorerColumn titleCol = new CmsListExplorerColumn(LIST_COLUMN_TITLE);
        titleCol.setName(org.opencms.workplace.explorer.Messages.get().container("GUI_INPUT_TITLE_0"));
        metadata.addColumn(titleCol);
        CmsListExplorerColumn typeCol = new CmsListExplorerColumn(LIST_COLUMN_TYPE);
        typeCol.setName(org.opencms.workplace.explorer.Messages.get().container("GUI_INPUT_TYPE_0"));
        metadata.addColumn(typeCol);
        CmsListExplorerColumn sizeCol = new CmsListExplorerColumn(LIST_COLUMN_SIZE);
        sizeCol.setName(org.opencms.workplace.explorer.Messages.get().container("GUI_INPUT_SIZE_0"));
        metadata.addColumn(sizeCol);
        CmsListExplorerColumn permissionsCol = new CmsListExplorerColumn(LIST_COLUMN_PERMISSIONS);
        permissionsCol.setName(org.opencms.workplace.explorer.Messages.get().container("GUI_INPUT_PERMISSIONS_0"));
        metadata.addColumn(permissionsCol);
        CmsListExplorerColumn dateLastModCol = new CmsListExplorerColumn(LIST_COLUMN_DATELASTMOD);
        dateLastModCol.setName(org.opencms.workplace.explorer.Messages.get().container("GUI_INPUT_DATELASTMODIFIED_0"));
        dateLastModCol.setFormatter(CmsListDateMacroFormatter.getDefaultDateFormatter());
        metadata.addColumn(dateLastModCol);
        CmsListExplorerColumn userLastModCol = new CmsListExplorerColumn(LIST_COLUMN_USERLASTMOD);
        userLastModCol.setName(org.opencms.workplace.explorer.Messages.get().container("GUI_INPUT_USERLASTMODIFIED_0"));
        metadata.addColumn(userLastModCol);
        CmsListExplorerColumn dateCreateCol = new CmsListExplorerColumn(LIST_COLUMN_DATECREATE);
        dateCreateCol.setName(org.opencms.workplace.explorer.Messages.get().container("GUI_INPUT_DATECREATED_0"));
        dateCreateCol.setFormatter(CmsListDateMacroFormatter.getDefaultDateFormatter());
        metadata.addColumn(dateCreateCol);
        CmsListExplorerColumn userCreateCol = new CmsListExplorerColumn(LIST_COLUMN_USERCREATE);
        userCreateCol.setName(org.opencms.workplace.explorer.Messages.get().container("GUI_INPUT_USERCREATED_0"));
        metadata.addColumn(userCreateCol);
        CmsListExplorerColumn dateReleaseCol = new CmsListExplorerColumn(LIST_COLUMN_DATEREL);
        dateReleaseCol.setName(org.opencms.workplace.explorer.Messages.get().container("GUI_INPUT_DATERELEASED_0"));
        dateReleaseCol.setFormatter(new CmsListDateMacroFormatter(Messages.get().container("GUI_LIST_DATE_FORMAT_1"), new CmsMessageContainer(null, "-"), 0L));
        metadata.addColumn(dateReleaseCol);
        CmsListExplorerColumn dateExpirationCol = new CmsListExplorerColumn(LIST_COLUMN_DATEEXP);
        dateExpirationCol.setName(org.opencms.workplace.explorer.Messages.get().container("GUI_INPUT_DATEEXPIRED_0"));
        dateExpirationCol.setFormatter(new CmsListDateMacroFormatter(Messages.get().container("GUI_LIST_DATE_FORMAT_1"), new CmsMessageContainer(null, "-"), Long.MAX_VALUE));
        metadata.addColumn(dateExpirationCol);
        CmsListExplorerColumn stateCol = new CmsListExplorerColumn(LIST_COLUMN_STATE);
        stateCol.setName(org.opencms.workplace.explorer.Messages.get().container("GUI_INPUT_STATE_0"));
        metadata.addColumn(stateCol);
        CmsListExplorerColumn lockedByCol = new CmsListExplorerColumn(LIST_COLUMN_LOCKEDBY);
        lockedByCol.setName(org.opencms.workplace.explorer.Messages.get().container("GUI_INPUT_LOCKEDBY_0"));
        metadata.addColumn(lockedByCol);
        CmsListExplorerColumn siteCol = new CmsListExplorerColumn(LIST_COLUMN_SITE);
        siteCol.setName(org.opencms.workplace.explorer.Messages.get().container("GUI_LABEL_SITE_0"));
        metadata.addColumn(siteCol);
    }

    protected void setColumnVisibilities() {
        this.m_colVisibilities = new HashMap<Integer, Boolean>(16);
        int preferences = new CmsUserSettings(this.getCms()).getExplorerSettings();
        this.setColumnVisibility(1, preferences);
        this.setColumnVisibility(2, preferences);
        this.setColumnVisibility(8, preferences);
        this.setColumnVisibility(128, preferences);
        this.setColumnVisibility(4, preferences);
        this.setColumnVisibility(2048, preferences);
        this.setColumnVisibility(1024, preferences);
        this.setColumnVisibility(32, preferences);
        this.setColumnVisibility(4096, preferences);
        this.setColumnVisibility(8192, preferences);
        this.setColumnVisibility(16, preferences);
        this.setColumnVisibility(256, preferences);
        this.m_colVisibilities.put(new Integer(LIST_COLUMN_TYPEICON.hashCode()), Boolean.TRUE);
        this.m_colVisibilities.put(new Integer(LIST_COLUMN_LOCKICON.hashCode()), Boolean.TRUE);
        this.m_colVisibilities.put(new Integer(LIST_COLUMN_PROJSTATEICON.hashCode()), Boolean.TRUE);
        this.m_colVisibilities.put(new Integer(LIST_COLUMN_NAME.hashCode()), Boolean.TRUE);
        this.m_colVisibilities.put(new Integer(LIST_COLUMN_EDIT.hashCode()), Boolean.FALSE);
        this.m_colVisibilities.put(new Integer(LIST_COLUMN_SITE.hashCode()), OpenCms.getSiteManager().getSites().size() > 1);
    }

    protected void setColumnVisibility(int colFlag, int prefs) {
        Integer key = new Integer(colFlag);
        Boolean value = (prefs & colFlag) > 0;
        this.m_colVisibilities.put(key, value);
    }

    protected void setColVisibilities(Map<Integer, Boolean> colVisibilities) {
        this.m_colVisibilities = colVisibilities;
    }

    @Override
    protected void setIndependentActions(CmsListMetadata metadata) {
        metadata.addIndependentAction(CmsListIndependentAction.getDefaultExplorerSwitchAction());
    }

    private boolean getShowExplorer() {
        if (this.getParamShowexplorer() != null) {
            return Boolean.valueOf(this.getParamShowexplorer());
        }
        Map dialogObject = (Map)this.getSettings().getDialogObject();
        if (dialogObject == null) {
            return false;
        }
        Boolean storedParam = (Boolean)dialogObject.get(((Object)((Object)this)).getClass().getName());
        if (storedParam == null) {
            return false;
        }
        return storedParam;
    }

    private void setShowExplorer(boolean showExplorer) {
        HashMap<String, Boolean> dialogMap = (HashMap<String, Boolean>)this.getSettings().getDialogObject();
        if (dialogMap == null) {
            dialogMap = new HashMap<String, Boolean>();
            this.getSettings().setDialogObject(dialogMap);
        }
        dialogMap.put(((Object)((Object)this)).getClass().getName(), showExplorer);
    }
}

