/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.loader.CmsImageScaler;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.Messages;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemSelectionAction;
import org.opencms.workplace.list.CmsListItemSelectionCustomAction;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListItemComparator;

public abstract class A_CmsListResourceTypeDialog
extends A_CmsListDialog {
    public static final String LIST_ACTION_SEL = "rs";
    public static final String LIST_COLUMN_ICON = "nrci";
    public static final String LIST_COLUMN_NAME = "nrcn";
    public static final String LIST_COLUMN_SELECT = "nrcs";
    public static final String LIST_DETAIL_DESCRIPTION = "dd";
    public static final String LIST_ID = "nrt";
    public static final String PARAM_SELECTED_TYPE = "selectedtype";
    private static final I_CmsListItemComparator LIST_ITEM_COMPARATOR = new I_CmsListItemComparator(){

        @Override
        public Comparator<CmsListItem> getComparator(String columnId, Locale locale) {
            return new Comparator<CmsListItem>(){

                @Override
                public int compare(CmsListItem li1, CmsListItem li2) {
                    if (li1 == li2) {
                        return 0;
                    }
                    if (li1 == null) {
                        return -1;
                    }
                    if (li2 == null) {
                        return 1;
                    }
                    CmsExplorerTypeSettings set1 = OpenCms.getWorkplaceManager().getExplorerTypeSetting(li1.getId());
                    CmsExplorerTypeSettings set2 = OpenCms.getWorkplaceManager().getExplorerTypeSetting(li2.getId());
                    if (set1 == null) {
                        return -1;
                    }
                    if (set2 == null) {
                        return 1;
                    }
                    return set1.compareTo(set2);
                }
            };
        }
    };
    private String m_paramSelectedType;

    public A_CmsListResourceTypeDialog(CmsJspActionElement jsp) {
        this(jsp, LIST_ID, Messages.get().container("GUI_NEWRESOURCE_LIST_SELECT_NAME_0"), null, CmsListOrderEnum.ORDER_ASCENDING, null);
    }

    public A_CmsListResourceTypeDialog(CmsJspActionElement jsp, String listId, CmsMessageContainer listName, String sortedColId, CmsListOrderEnum sortOrder, String searchableColId) {
        super(jsp, listId, listName, sortedColId, sortOrder, searchableColId);
        this.setParamStyle("");
        this.getList().setMaxItemsPerPage(Integer.MAX_VALUE);
        this.getList().getMetadata().getIndependentAction("iap").setVisible(false);
        this.getList().setBoxed(false);
        this.getList().setShowTitle(false);
    }

    public A_CmsListResourceTypeDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    @Override
    public void actionDialog() throws JspException, ServletException, IOException {
        String selected;
        I_CmsListDirectAction action = this.getList().getMetadata().getColumnDefinition(LIST_COLUMN_SELECT).getDirectAction(LIST_ACTION_SEL);
        if (action != null && (selected = this.getParamSelectedType()) != null) {
            ((CmsListItemSelectionAction)action).setSelectedItemId(selected);
        }
        super.actionDialog();
    }

    public String dialogButtons() {
        return this.dialogButtons(new int[]{10, 1}, new String[]{" onclick=\"submitAction('continue', form, '" + this.getListId() + "-form');\" id=\"nextButton\"", " onclick=\"submitAction('cancel', form, '" + this.getListId() + "-form');\""});
    }

    @Override
    public void executeListMultiActions() throws CmsRuntimeException {
    }

    @Override
    public void executeListSingleActions() throws CmsRuntimeException {
    }

    public String getParamSelectedType() {
        return this.m_paramSelectedType;
    }

    public String paramsAsHidden() {
        return this.paramsAsHidden(new ArrayList<String>());
    }

    public String paramsAsHidden(Collection<String> excludes) {
        excludes.add(PARAM_SELECTED_TYPE);
        excludes.add("sortcol");
        excludes.add("listindependentaction");
        return super.paramsAsHidden(excludes);
    }

    public void setParamSelectedType(String paramSelectedType) {
        this.m_paramSelectedType = paramSelectedType;
    }

    protected String customHtmlBeforeList() {
        return "";
    }

    @Override
    protected String customHtmlEnd() {
        StringBuffer result = new StringBuffer(256);
        result.append(this.dialogSpacer());
        result.append(this.dialogButtons());
        result.append("</form>\n");
        return result.toString();
    }

    @Override
    protected String customHtmlStart() {
        StringBuffer result = new StringBuffer(256);
        result.append("<script type='text/javascript' src='");
        result.append(CmsWorkplace.getSkinUri());
        result.append("admin/javascript/general.js'></script>\n");
        result.append("<script type='text/javascript' src='");
        result.append(CmsWorkplace.getSkinUri());
        result.append("editors/xmlcontent/help.js'></script>\n");
        result.append("<form name='");
        result.append(this.getList().getId());
        result.append("-form' action='");
        result.append(this.getDialogRealUri());
        result.append("' method='post' class='nomargin'");
        if (this.getList().getMetadata().isSearchable()) {
            result.append(" onsubmit=\"listSearchAction('");
            result.append(this.getList().getId());
            result.append("', '");
            result.append(this.getList().getMetadata().getSearchAction().getId());
            result.append("', '");
            result.append(this.getList().getMetadata().getSearchAction().getConfirmationMessage().key(this.getLocale()));
            result.append("');\"");
        }
        result.append(">\n");
        result.append(this.paramsAsHidden());
        result.append("\n");
        result.append("<input type=\"hidden\" name=\"framename\" value=\"\">\n");
        result.append("<input type=\"hidden\" name=\"listaction\" value=\"\">\n");
        result.append("<input type=\"hidden\" name=\"sortcol\" value=\"\">\n");
        return result.toString();
    }

    @Override
    protected String defaultActionHtmlContent() {
        StringBuffer result = new StringBuffer(2048);
        result.append("<!-- start before list -->\n");
        result.append(this.customHtmlBeforeList());
        result.append("<!-- end before list -->\n");
        result.append(this.dialogBlockStart(this.key(this.getList().getName().getKey())));
        result.append(this.dialogWhiteBoxStart());
        this.getList().setWp(this);
        result.append(this.getList().listHtml());
        result.append(this.dialogWhiteBoxEnd());
        result.append(this.dialogBlockEnd());
        return result.toString();
    }

    @Override
    protected void fillDetails(String detailId) {
        List<CmsListItem> types = this.getList().getAllContent();
        for (CmsListItem item : types) {
            StringBuffer description;
            block9: {
                String resType = item.getId();
                description = new StringBuffer();
                if (!detailId.equals(LIST_DETAIL_DESCRIPTION)) continue;
                try {
                    try {
                        int resTypeId = Integer.parseInt(resType);
                        resType = OpenCms.getResourceManager().getResourceType(resTypeId).getTypeName();
                    }
                    catch (NumberFormatException resTypeId) {
                        // empty catch block
                    }
                    CmsExplorerTypeSettings set = OpenCms.getWorkplaceManager().getExplorerTypeSetting(resType);
                    if (set == null) break block9;
                    String imgSrc = set.getDescriptionImage();
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)imgSrc)) {
                        try {
                            CmsResource res = this.getCms().readResource(imgSrc);
                            CmsImageScaler origImage = new CmsImageScaler(this.getCms(), res);
                            CmsImageScaler scaler = new CmsImageScaler();
                            scaler.setWidth(60);
                            scaler.setHeight(60);
                            CmsImageScaler resultScaler = origImage.getDownScaler(scaler);
                            if (resultScaler == null) {
                                resultScaler = origImage;
                            }
                            HashMap<String, String> attrs = new HashMap<String, String>();
                            attrs.put("align", "left");
                            attrs.put("vspace", "5");
                            attrs.put("hspace", "5");
                            description.append(this.getJsp().img(imgSrc, resultScaler, attrs));
                        }
                        catch (CmsException cmsException) {
                            // empty catch block
                        }
                    }
                    description.append(this.key(set.getInfo()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            item.set(detailId, description);
        }
    }

    @Override
    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition radioSelCol = new CmsListColumnDefinition(LIST_COLUMN_SELECT);
        radioSelCol.setName(Messages.get().container("GUI_NEWRESOURCE_LIST_COLS_SELECT_0"));
        radioSelCol.setWidth("20");
        radioSelCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        radioSelCol.setSorteable(false);
        CmsListItemSelectionCustomAction selAction = new CmsListItemSelectionCustomAction(LIST_ACTION_SEL, PARAM_SELECTED_TYPE);
        selAction.setName(Messages.get().container("GUI_NEWRESOURCE_LIST_SELECT_NAME_0"));
        selAction.setEnabled(true);
        radioSelCol.addDirectAction(selAction);
        metadata.addColumn(radioSelCol);
        CmsListColumnDefinition iconCol = new CmsListColumnDefinition(LIST_COLUMN_ICON);
        iconCol.setName(Messages.get().container("GUI_NEWRESOURCE_LIST_COLS_ICON_0"));
        iconCol.setWidth("20");
        iconCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        iconCol.setSorteable(true);
        iconCol.setListItemComparator(LIST_ITEM_COMPARATOR);
        metadata.addColumn(iconCol);
        CmsListColumnDefinition nameCol = new CmsListColumnDefinition(LIST_COLUMN_NAME);
        nameCol.setName(Messages.get().container("GUI_NEWRESOURCE_LIST_COLS_NAME_0"));
        metadata.addColumn(nameCol);
    }

    @Override
    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails resourceTypeDescription = new CmsListItemDetails(LIST_DETAIL_DESCRIPTION);
        resourceTypeDescription.setAtColumn(LIST_COLUMN_NAME);
        resourceTypeDescription.setVisible(false);
        resourceTypeDescription.setShowActionName(Messages.get().container("GUI_NEWRESOURCE_DETAIL_SHOW_DESCRIPTION_NAME_0"));
        resourceTypeDescription.setShowActionHelpText(Messages.get().container("GUI_NEWRESOURCE_DETAIL_SHOW_DESCRIPTION_HELP_0"));
        resourceTypeDescription.setHideActionName(Messages.get().container("GUI_NEWRESOURCE_DETAIL_HIDE_DESCRIPTION_NAME_0"));
        resourceTypeDescription.setHideActionHelpText(Messages.get().container("GUI_NEWRESOURCE_DETAIL_HIDE_DESCRIPTION_HELP_0"));
        metadata.addItemDetails(resourceTypeDescription);
    }

    @Override
    protected void setMultiActions(CmsListMetadata metadata) {
    }
}

