/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.list.A_CmsListExplorerDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemSelectionAction;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.Messages;

public abstract class A_CmsSelectResourceList
extends A_CmsListExplorerDialog {
    public static final int BUTTON_FINISH = 30;
    public static final int BUTTON_NEXT = 20;
    public static final String LIST_COLUMN_SELECT = "cs";
    public static final String LIST_RACTION_SEL = "rs";

    protected A_CmsSelectResourceList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName) {
        super(jsp, listId, listName);
        this.getList().getMetadata().getIndependentAction("iap").setVisible(false);
        this.getList().setBoxed(false);
    }

    protected A_CmsSelectResourceList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName, String sortedColId, CmsListOrderEnum sortOrder, String searchableColId) {
        super(jsp, listId, listName, sortedColId, sortOrder, searchableColId);
        this.getList().getMetadata().getIndependentAction("iap").setVisible(false);
        this.getList().setBoxed(false);
    }

    @Override
    public void actionDialog() throws JspException, ServletException, IOException {
        if (this.getAction() == 8) {
            this.sendForward(this.nextUrl(), this.paramsAsParameterMap());
            return;
        }
        super.actionDialog();
    }

    public String dialogButtons() {
        return this.dialogButtons(new int[]{10, 1}, new String[]{"", ""});
    }

    @Override
    public void executeListMultiActions() {
    }

    @Override
    public void executeListSingleActions() {
    }

    public String getSelectedResourceName() {
        String resParam = this.getJsp().getRequest().getParameter(this.getListId() + LIST_RACTION_SEL);
        if (CmsStringUtil.isNotEmpty((String)resParam)) {
            CmsListItem item = this.getList().getItem(resParam);
            return (String)item.get("ecn");
        }
        return null;
    }

    @Override
    public void displayDialog() throws JspException, IOException, ServletException {
        this.getList().setShowTitle(false);
        super.displayDialog();
    }

    public abstract String getListTitle();

    public abstract String nextUrl();

    @Override
    protected String customHtmlEnd() {
        StringBuffer result = new StringBuffer(256);
        result.append(this.dialogWhiteBoxEnd());
        result.append(this.dialogBlockEnd());
        result.append(this.dialogSpacer());
        result.append(this.dialogButtons());
        result.append(super.customHtmlEnd());
        return result.toString();
    }

    @Override
    protected String customHtmlStart() {
        StringBuffer result = new StringBuffer(256);
        result.append("<script type='text/javascript' src='");
        result.append(CmsWorkplace.getSkinUri());
        result.append("admin/javascript/general.js'></script>\n");
        result.append("<script type='text/javascript' src='");
        result.append(CmsWorkplace.getSkinUri());
        result.append("editors/xmlcontent/help.js'></script>\n");
        result.append(this.dialogBlockStart(this.getListTitle()));
        result.append(this.dialogWhiteBoxStart());
        return result.toString();
    }

    protected void dialogButtonsHtml(StringBuffer result, int button, String attribute) {
        attribute = this.appendDelimiter(attribute);
        switch (button) {
            case 30: {
                result.append("<input name='continue' type=\"button\" value=\"");
                result.append(this.key("GUI_BUTTON_ENDWIZARD_0") + "\"");
                if (attribute.toLowerCase().indexOf("onclick") == -1) {
                    result.append(" onclick=\"submitAction('continue', form, '");
                    result.append(this.getListId());
                    result.append("-form');\"");
                }
                result.append("\" class=\"dialogbutton\"");
                result.append(attribute);
                result.append(">\n");
                break;
            }
            case 20: {
                result.append("<input name='continue' type=\"button\" value=\"");
                result.append(this.key("GUI_BUTTON_NEXTSCREEN_0") + "\"");
                if (attribute.toLowerCase().indexOf("onclick") == -1) {
                    result.append(" onclick=\"submitAction('continue', form, '");
                    result.append(this.getListId());
                    result.append("-form');\"");
                }
                result.append("\" class=\"dialogbutton\"");
                result.append(attribute);
                result.append(">\n");
                break;
            }
            case 1: {
                result.append("<input name='cancel' type=\"button\" value=\"");
                result.append(this.key("GUI_DIALOG_BUTTON_CANCEL_0") + "\"");
                if (attribute.toLowerCase().indexOf("onclick") == -1) {
                    result.append(" onclick=\"submitAction('cancel', form, '");
                    result.append(this.getListId());
                    result.append("-form');\"");
                }
                result.append(" class=\"dialogbutton\"");
                result.append(attribute);
                result.append(">\n");
                break;
            }
            default: {
                super.dialogButtonsHtml(result, button, attribute);
            }
        }
    }

    @Override
    protected void fillDetails(String detailId) {
    }

    @Override
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        if ("continue".equals(this.getParamAction())) {
            this.setAction(8);
        }
    }

    @Override
    protected boolean isColumnVisible(int colFlag) {
        if (colFlag == "ecti".hashCode()) {
            return true;
        }
        if (colFlag == "ecn".hashCode()) {
            return true;
        }
        if (colFlag == 1) {
            return true;
        }
        return colFlag == 4;
    }

    @Override
    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition radioSelCol = new CmsListColumnDefinition(LIST_COLUMN_SELECT);
        radioSelCol.setName(Messages.get().container("GUI_EXPLORER_LIST_COLS_SELECT_0"));
        radioSelCol.setWidth("20");
        radioSelCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        radioSelCol.setSorteable(false);
        CmsListItemSelectionAction selAction = new CmsListItemSelectionAction(LIST_RACTION_SEL, null);
        selAction.setName(Messages.get().container("GUI_EXPLORER_LIST_COLS_SELECT_HELP_0"));
        selAction.setEnabled(true);
        selAction.setSelectedItemId(CmsUUID.getConstantUUID((String)"nones").toString());
        radioSelCol.addDirectAction(selAction);
        metadata.addColumn(radioSelCol);
        super.setColumns(metadata);
    }

    @Override
    protected void setMultiActions(CmsListMetadata metadata) {
    }
}

