/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import java.text.MessageFormat;
import java.util.Locale;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.A_CmsListAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.tools.A_CmsHtmlIconButton;
import org.opencms.workplace.tools.CmsHtmlIconButtonStyleEnum;

public class CmsListDirectAction
extends A_CmsListAction
implements I_CmsListDirectAction {
    private String m_columnForTexts;
    private CmsListItem m_listItem;

    public CmsListDirectAction(String id) {
        super(id);
    }

    protected String resolveHelpText(Locale locale) {
        String helpText = this.getHelpText().key(locale);
        if (this.getColumnForTexts() != null && this.getItem().get(this.getColumnForTexts()) != null) {
            helpText = new MessageFormat(helpText, locale).format(new Object[]{this.getItem().get(this.getColumnForTexts())});
        }
        return helpText;
    }

    protected String resolveOnClic(Locale locale) {
        String confirmationMessage = this.getConfirmationMessage().key(locale);
        if (this.getColumnForTexts() != null && this.getItem().get(this.getColumnForTexts()) != null) {
            confirmationMessage = new MessageFormat(confirmationMessage, locale).format(new Object[]{this.getItem().get(this.getColumnForTexts())});
        }
        StringBuffer onClic = new StringBuffer(128);
        onClic.append("listAction('");
        onClic.append(this.getListId());
        onClic.append("', '");
        onClic.append(this.getId());
        onClic.append("', '");
        if (this.getColumnForTexts() == null || this.getItem().get(this.getColumnForTexts()) == null || confirmationMessage.equals(new MessageFormat(confirmationMessage, locale).format(new Object[]{""}))) {
            onClic.append("conf" + this.getId());
        } else {
            onClic.append(CmsStringUtil.escapeJavaScript((String)confirmationMessage));
        }
        onClic.append("', '");
        onClic.append(CmsStringUtil.escapeJavaScript((String)this.getItem().getId()));
        onClic.append("');");
        return onClic.toString();
    }

    protected String resolveName(Locale locale) {
        return this.getName().key(locale);
    }

    protected CmsHtmlIconButtonStyleEnum resolveButtonStyle() {
        return CmsHtmlIconButtonStyleEnum.SMALL_ICON_ONLY;
    }

    public String buttonHtml(CmsWorkplace wp) {
        if (!this.isVisible()) {
            return "";
        }
        return A_CmsHtmlIconButton.defaultButtonHtml((CmsHtmlIconButtonStyleEnum)this.resolveButtonStyle(), (String)(this.getId() + this.getItem().getId()), (String)this.getId(), (String)this.resolveName(wp.getLocale()), (String)this.resolveHelpText(wp.getLocale()), (boolean)this.isEnabled(), (String)this.getIconPath(), null, (String)this.resolveOnClic(wp.getLocale()), (this.getColumnForTexts() == null ? 1 : 0) != 0, null);
    }

    @Override
    public String confirmationTextHtml() {
        StringBuffer html = new StringBuffer(512);
        String cm = this.getConfirmationMessage().key(this.getWp().getLocale());
        String confMessage = new MessageFormat(cm, this.getWp().getLocale()).format(new Object[]{""});
        if (this.getColumnForTexts() == null || confMessage.equals(new MessageFormat(cm, this.getWp().getLocale()).format(new Object[]{this.getItem().get(this.getColumnForTexts())}))) {
            html.append(A_CmsListAction.defaultConfirmationHtml(this.getId(), confMessage));
        }
        return html.toString();
    }

    @Override
    public String getColumnForTexts() {
        return this.m_columnForTexts;
    }

    @Override
    public CmsListItem getItem() {
        return this.m_listItem;
    }

    @Override
    public String helpTextHtml() {
        StringBuffer html = new StringBuffer(512);
        String ht = this.getHelpText().key(this.getWp().getLocale());
        String helptext = new MessageFormat(ht, this.getWp().getLocale()).format(new Object[]{""});
        if (this.getColumnForTexts() == null || helptext.equals(new MessageFormat(ht, this.getWp().getLocale()).format(new Object[]{this.getItem().get(this.getColumnForTexts())}))) {
            html.append(A_CmsHtmlIconButton.defaultHelpHtml((String)this.getId(), (String)helptext));
        }
        return html.toString();
    }

    @Override
    public void setColumnForTexts(String columnId) {
        this.m_columnForTexts = columnId;
    }

    @Override
    public void setItem(CmsListItem item) {
        this.m_listItem = item;
    }
}

