/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.lock.CmsLock;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.workplace.list.A_CmsListExplorerDialog;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.Messages;

public class CmsListEditResourceAction
extends CmsListDirectAction {
    private final String m_resColumnPathId;
    private CmsResourceUtil m_resourceUtil;

    public CmsListEditResourceAction(String id, String resColumnPathId) {
        super(id);
        this.m_resColumnPathId = resColumnPathId;
    }

    public CmsMessageContainer getHelpText() {
        CmsMessageContainer helptext = super.getHelpText();
        if (helptext == null) {
            helptext = this.isEnabled() ? Messages.get().container("GUI_EDITRESOURCE_ACTION_HELP_0") : Messages.get().container("GUI_EDITRESOURCE_DISABLED_ACTION_HELP_0");
        }
        return helptext;
    }

    public String getIconPath() {
        String iconpath = super.getIconPath();
        if (iconpath == null) {
            iconpath = this.isEnabled() ? "list/resource_edit.png" : "list/resource_edit_disabled.png";
        }
        return iconpath;
    }

    public CmsMessageContainer getName() {
        CmsMessageContainer name = super.getName();
        if (name == null) {
            name = this.isEnabled() ? Messages.get().container("GUI_EDITRESOURCE_ACTION_NAME_0") : Messages.get().container("GUI_EDITRESOURCE_DISABLED_ACTION_NAME_0");
        }
        return name;
    }

    public boolean isVisible() {
        if (this.getResourceName() != null) {
            try {
                CmsLock lock;
                if (OpenCms.getWorkplaceManager().getEditorHandler().getEditorUri(this.getResourceName(), this.getWp().getJsp()) != null && ((lock = this.getResourceUtil().getLock()).isNullLock() || lock.isOwnedBy(this.getWp().getCms().getRequestContext().getCurrentUser()))) {
                    return this.isEnabled();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return !this.isEnabled();
    }

    @Override
    public void setItem(CmsListItem item) {
        this.m_resourceUtil = ((A_CmsListExplorerDialog)this.getWp()).getResourceUtil(item);
        super.setItem(item);
    }

    protected CmsResourceUtil getResourceUtil() {
        return this.m_resourceUtil;
    }

    private String getResourceName() {
        String resource = this.getItem().get(this.m_resColumnPathId).toString();
        if (!this.getWp().getCms().existsResource(resource, CmsResourceFilter.DEFAULT)) {
            String siteRoot = OpenCms.getSiteManager().getSiteRoot(resource);
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)siteRoot)) {
                resource = resource.substring(siteRoot.length());
            }
            if (!this.getWp().getCms().existsResource(resource, CmsResourceFilter.DEFAULT)) {
                resource = null;
            }
        }
        return resource;
    }
}

