/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.workplace.list.A_CmsListExplorerDialog;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListItem;

public class CmsListExplorerColumn
extends CmsListColumnDefinition {
    public CmsListExplorerColumn(String id) {
        super(id);
    }

    @Override
    public String htmlCell(CmsListItem item, boolean isPrintable) {
        if (isPrintable) {
            return super.htmlCell(item, isPrintable);
        }
        CmsResourceUtil resUtil = ((A_CmsListExplorerDialog)this.getWp()).getResourceUtil(item);
        StringBuffer html = new StringBuffer(128);
        html.append("<table cellpadding='0' cellspacing='0' border='0'><tr><td class='");
        html.append(resUtil.getStyleClassName());
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)resUtil.getTimeWindowLayoutStyle())) {
            html.append(" ' style='");
            html.append(resUtil.getTimeWindowLayoutStyle());
            html.append("'");
        }
        html.append("'>");
        html.append(super.htmlCell(item, isPrintable));
        html.append("</td></tr></table>");
        return html.toString();
    }

    public static String getExplorerStyleDef() {
        StringBuffer result = new StringBuffer(256);
        result.append("<style type='text/css'>\n");
        result.append(".fc, .fc .link a { color: #b40000; }\n");
        result.append(".fn, .fn .link a { color: #0000aa; }\n");
        result.append(".fd, .fd .link a { color: #000000; text-decoration: line-through; }\n");
        result.append(".fp, .fp .link a { color: #888888; }\n");
        result.append(".nf, .nf .link a { color:#000000; }\n");
        result.append("</style>");
        return result.toString();
    }
}

