/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.CmsListItemSelectionAction;
import org.opencms.workplace.tools.A_CmsHtmlIconButton;
import org.opencms.workplace.tools.CmsHtmlIconButtonStyleEnum;

public class CmsListItemSelectionCustomAction
extends CmsListItemSelectionAction {
    private String m_attributes;
    private String m_column;
    private String m_fieldName;

    public CmsListItemSelectionCustomAction(String id, String columnValue) {
        this(id, columnValue, null);
    }

    public CmsListItemSelectionCustomAction(String id, String name, String columnValue) {
        super(id, null);
        this.m_fieldName = name;
        this.m_column = columnValue;
    }

    @Override
    public String buttonHtml(CmsWorkplace wp) {
        if (!this.isVisible()) {
            return "";
        }
        String value = this.getItem().getId();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.m_column)) {
            value = (String)this.getItem().get(this.m_column);
        }
        String html = "<input type='radio' value='" + value + "' name='" + this.m_fieldName + "'";
        if (!this.isEnabled()) {
            html = html + " disabled";
        }
        if (this.getItem().getId().equals(this.getSelectedItemId())) {
            html = html + " checked";
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.m_attributes)) {
            html = html + this.m_attributes;
        }
        html = html + ">\n";
        return A_CmsHtmlIconButton.defaultButtonHtml((CmsHtmlIconButtonStyleEnum)CmsHtmlIconButtonStyleEnum.SMALL_ICON_TEXT, (String)this.getId(), (String)html, (String)this.getHelpText().key(wp.getLocale()), (boolean)false, null, null, null);
    }

    public String getAttributes() {
        return this.m_attributes;
    }

    public String getColumn() {
        return this.m_column;
    }

    public String getFieldName() {
        return this.m_fieldName;
    }

    public void setAttributes(String attributes) {
        this.m_attributes = attributes;
    }

    public void setColumn(String column) {
        this.m_column = column;
    }

    public void setFieldName(String fieldName) {
        this.m_fieldName = fieldName;
    }
}

