/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.workplace.list.Messages;

public final class CmsListOrderEnum {
    public static final CmsListOrderEnum ORDER_ASCENDING = new CmsListOrderEnum("asc");
    public static final CmsListOrderEnum ORDER_DESCENDING = new CmsListOrderEnum("des");
    public static final CmsListOrderEnum ORDER_NONE = new CmsListOrderEnum("none");
    private static final CmsListOrderEnum[] VALUE_ARRAY = new CmsListOrderEnum[]{ORDER_ASCENDING, ORDER_DESCENDING, ORDER_NONE};
    public static final List<CmsListOrderEnum> VALUES = Collections.unmodifiableList(Arrays.asList(VALUE_ARRAY));
    private final String m_order;

    private CmsListOrderEnum(String order) {
        this.m_order = order;
    }

    public static CmsListOrderEnum valueOf(String value) throws CmsIllegalArgumentException {
        for (CmsListOrderEnum target : VALUES) {
            if (!value.equals(target.getOrder())) continue;
            return target;
        }
        throw new CmsIllegalArgumentException(Messages.get().container("ERR_LIST_ENUM_PARSE_2", (Object)new Integer(value), (Object)CmsListOrderEnum.class.getName()));
    }

    public String getOrder() {
        return this.m_order;
    }

    public String toString() {
        return this.m_order;
    }
}

