/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import com.google.common.base.Objects;
import org.opencms.workplace.list.CmsHtmlList;
import org.opencms.workplace.list.CmsListOrderEnum;

public class CmsListState {
    private String m_column;
    private String m_filter;
    private CmsListOrderEnum m_order;
    private int m_page;

    public CmsListState() {
        this.m_page = 1;
        this.m_order = CmsListOrderEnum.ORDER_ASCENDING;
        this.m_filter = "";
        this.m_column = "";
    }

    public CmsListState(CmsHtmlList list) {
        this.m_column = list.getSortedColumn();
        this.m_filter = list.getSearchFilter();
        this.m_page = list.getCurrentPage();
        this.m_order = list.getCurrentSortOrder();
    }

    public String getColumn() {
        return this.m_column;
    }

    public String getFilter() {
        return this.m_filter;
    }

    public CmsListOrderEnum getOrder() {
        return this.m_order;
    }

    public int getPage() {
        return this.m_page;
    }

    public void setColumn(String column) {
        this.m_column = column;
    }

    public void setFilter(String filter) {
        this.m_filter = filter;
    }

    public void setOrder(CmsListOrderEnum order) {
        this.m_order = order;
    }

    public void setPage(int page) {
        this.m_page = page;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("column", (Object)this.m_column).add("filter", (Object)this.m_filter).add("order", (Object)this.m_order).add("page", (Object)("" + this.m_page)).toString();
    }
}

