/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.search;

import java.util.Collection;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.search.CmsSearchParameters;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.search.Messages;

public class CmsSearchWorkplaceBean {
    private String m_currentFolder;
    private String m_fields = CmsStringUtil.collectionAsString((Collection)new CmsSearchParameters().getFields(), (String)",");
    private String m_indexName;
    private String m_maxDateCreated;
    private String m_maxDateLastModified;
    private String m_minDateCreated;
    private String m_minDateLastModified;
    private String m_query;
    private boolean m_restrictSearch;
    private String m_sortOrder = CmsSearchParameters.SORT_NAMES[0];

    public CmsSearchWorkplaceBean(String currentFolder) {
        this.m_currentFolder = currentFolder;
    }

    public String getFields() {
        return this.m_fields;
    }

    public String getIndexName() {
        return this.m_indexName;
    }

    public String getMaxDateCreated() {
        return this.m_maxDateCreated;
    }

    public String getMaxDateLastModified() {
        return this.m_maxDateLastModified;
    }

    public String getMinDateCreated() {
        return this.m_minDateCreated;
    }

    public String getMinDateLastModified() {
        return this.m_minDateLastModified;
    }

    public String getQuery() {
        return this.m_query;
    }

    public String getSearchPath() {
        if (this.isRestrictSearch()) {
            return this.m_currentFolder;
        }
        return "/";
    }

    public String getSortOrder() {
        return this.m_sortOrder;
    }

    public boolean isRestrictSearch() {
        return this.m_restrictSearch;
    }

    public void setFields(String fields) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)fields)) {
            throw new CmsIllegalStateException(Messages.get().container("ERR_VALIDATE_SEARCH_PARAMS_0"));
        }
        this.m_fields = fields;
    }

    public void setIndexName(String indexName) {
        this.m_indexName = indexName;
    }

    public void setMaxDateCreated(String maxDateCreated) {
        this.m_maxDateCreated = maxDateCreated;
    }

    public void setMaxDateLastModified(String maxDateLastModified) {
        this.m_maxDateLastModified = maxDateLastModified;
    }

    public void setMinDateCreated(String dateCreatedFrom) {
        this.m_minDateCreated = dateCreatedFrom;
    }

    public void setMinDateLastModified(String minDateLastModified) {
        this.m_minDateLastModified = minDateLastModified;
    }

    public void setQuery(String query) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)query)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_VALIDATE_SEARCH_QUERY_0"));
        }
        this.m_query = query;
    }

    public void setRestrictSearch(boolean restrictSearch) {
        this.m_restrictSearch = restrictSearch;
    }

    public void setSortOrder(String sortOrder) {
        this.m_sortOrder = sortOrder;
    }
}

