/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.boot.atna;

import java.util.Objects;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.audit.event.UserAuthenticationBuilder;
import org.openehealth.ipf.commons.audit.model.AuditMessage;
import org.openehealth.ipf.commons.audit.types.PurposeOfUse;
import org.springframework.boot.actuate.security.AbstractAuthenticationAuditListener;
import org.springframework.boot.actuate.security.AuthenticationAuditListener;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AbstractAuthenticationFailureEvent;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.WebAuthenticationDetails;

public class AuthenticationListener
extends AbstractAuthenticationAuditListener {
    private final AuditContext auditContext;
    private final AuthenticationAuditListener delegateListener;

    public AuthenticationListener(AuditContext auditContext) {
        this.auditContext = Objects.requireNonNull(auditContext);
        this.delegateListener = new AuthenticationAuditListener();
    }

    public void onApplicationEvent(AbstractAuthenticationEvent authenticationEvent) {
        this.delegateListener.onApplicationEvent(authenticationEvent);
        EventOutcomeIndicator outcome = authenticationEvent instanceof AbstractAuthenticationFailureEvent ? EventOutcomeIndicator.MajorFailure : EventOutcomeIndicator.Success;
        Object details = authenticationEvent.getAuthentication().getDetails();
        if (details instanceof WebAuthenticationDetails) {
            WebAuthenticationDetails webAuthenticationDetails = (WebAuthenticationDetails)details;
            Object principal = authenticationEvent.getAuthentication().getPrincipal();
            if (principal instanceof UserDetails) {
                UserDetails userDetails = (UserDetails)principal;
                UserAuthenticationBuilder builder = (UserAuthenticationBuilder)new UserAuthenticationBuilder.Login(outcome, new PurposeOfUse[0]).setAuditSource(this.auditContext);
                if (userDetails.getUsername() != null) {
                    builder.setAuthenticatedParticipant(userDetails.getUsername(), webAuthenticationDetails.getRemoteAddress());
                }
                if (webAuthenticationDetails.getRemoteAddress() != null) {
                    builder.setAuthenticatingSystemParticipant(this.auditContext.getSendingApplication(), webAuthenticationDetails.getRemoteAddress());
                }
                this.auditContext.audit(new AuditMessage[]{builder.getMessage()});
            }
        }
    }
}

