/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.boot.atna;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Objects;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.queue.AbstractAuditMessageQueue;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;

public class RestTemplateAuditMessageQueue
extends AbstractAuditMessageQueue {
    private final URI uri;
    private final String user;
    private final String password;
    private final RestTemplateBuilder restTemplateBuilder;
    private RestOperations restTemplate;
    private long connectTimeout = -1L;
    private long readTimeout = -1L;

    public RestTemplateAuditMessageQueue(RestTemplateBuilder restTemplateBuilder, URI uri) {
        this(restTemplateBuilder, uri, null, null);
    }

    public RestTemplateAuditMessageQueue(RestTemplateBuilder restTemplateBuilder, URI uri, String user, String password) {
        this.uri = Objects.requireNonNull(uri, "url must not be null");
        this.user = user;
        this.password = password;
        this.restTemplateBuilder = restTemplateBuilder.defaultHeader("Content-Type", new String[]{new MediaType("text", "xml", StandardCharsets.UTF_8).toString()});
        this.initRestTemplate();
    }

    protected void handle(AuditContext auditContext, String auditRecord) {
        try {
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.add("X_IPF_ATNA_Timestamp", auditContext.getAuditMetadataProvider().getTimestamp());
            httpHeaders.add("X_IPF_ATNA_Hostname", auditContext.getAuditMetadataProvider().getHostname());
            httpHeaders.add("X_IPF_ATNA_ProcessID", auditContext.getAuditMetadataProvider().getProcessID());
            httpHeaders.add("X_IPF_ATNA_Application", auditContext.getAuditMetadataProvider().getSendingApplication());
            HttpEntity entity = new HttpEntity((Object)auditRecord, (MultiValueMap)httpHeaders);
            this.restTemplate.postForEntity(this.uri, (Object)entity, Void.class);
        }
        catch (RestClientException e) {
            auditContext.getAuditExceptionHandler().handleException(auditContext, (Throwable)e, auditRecord);
        }
    }

    public void setConnectTimeout(long connectTimeoutMillis) {
        this.connectTimeout = connectTimeoutMillis;
        this.initRestTemplate();
    }

    public void setReadTimeout(long readTimeoutMillis) {
        this.readTimeout = readTimeoutMillis;
        this.initRestTemplate();
    }

    private synchronized void initRestTemplate() {
        RestTemplateBuilder builder = this.restTemplateBuilder;
        if (this.connectTimeout >= 0L) {
            builder = builder.setConnectTimeout(Duration.ofMillis(this.connectTimeout));
        }
        if (this.readTimeout >= 0L) {
            builder = builder.setReadTimeout(Duration.ofMillis(this.readTimeout));
        }
        if (this.user != null && !this.user.isEmpty() && this.password != null && !this.password.isEmpty()) {
            builder = builder.basicAuthentication(this.user, this.password);
        }
        this.restTemplate = builder.build();
    }
}

