/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hl7v3;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.openehealth.ipf.commons.xml.CombinedXmlValidationProfile;

public class Hl7v3ValidationProfile
implements CombinedXmlValidationProfile {
    public static final String DEFAULT_XSD = "";
    public static final String GAZELLE_PIXPDQV3_SCHEMATRON = "/schematron/gazelle-pixpdqv3.sch.xml";
    private final Map<String, Row> map;

    public Hl7v3ValidationProfile(Row ... rows) {
        this.map = new HashMap<String, Row>(rows.length);
        for (Row row : rows) {
            this.map.put(row.rootElementName, row);
        }
    }

    public boolean isValidRootElement(String rootElementName) {
        return this.map.containsKey(rootElementName);
    }

    public String getXsdPath(String rootElementName) {
        return this.map.get(rootElementName).getXsdPath();
    }

    public String getSchematronPath(String rootElementName) {
        return this.map.get(rootElementName).getSchematronPath();
    }

    public Map<String, Object> getCustomSchematronParameters(String rootElementName) {
        String phase = this.map.get(rootElementName).getSchematronPhase();
        return phase != null ? Collections.singletonMap("phase", phase) : null;
    }

    static class Row {
        private static final String HL7V3_SCHEMAS_PATH = "/schema/HL7V3/NE2008/multicacheschemas/";
        final String rootElementName;
        final String xsdPath;
        final String schematronPath;
        final String schematronPhase;

        Row(String rootElementName, String xsdPath, String schematronPath) {
            this.rootElementName = rootElementName;
            if (Hl7v3ValidationProfile.DEFAULT_XSD.equals(xsdPath)) {
                int pos1 = rootElementName.indexOf(95);
                int pos2 = rootElementName.indexOf(95, pos1 + 1);
                String documentName = pos2 > 0 ? rootElementName.substring(0, pos2) : rootElementName;
                this.xsdPath = HL7V3_SCHEMAS_PATH + documentName + ".xsd";
            } else {
                this.xsdPath = xsdPath.startsWith("/") ? xsdPath : HL7V3_SCHEMAS_PATH + xsdPath;
            }
            this.schematronPath = schematronPath;
            this.schematronPhase = Hl7v3ValidationProfile.GAZELLE_PIXPDQV3_SCHEMATRON.equals(schematronPath) ? rootElementName : null;
        }

        @Generated
        public String getRootElementName() {
            return this.rootElementName;
        }

        @Generated
        public String getXsdPath() {
            return this.xsdPath;
        }

        @Generated
        public String getSchematronPath() {
            return this.schematronPath;
        }

        @Generated
        public String getSchematronPhase() {
            return this.schematronPhase;
        }
    }
}

