/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.spring.core.config;

import java.util.Map;
import java.util.Objects;
import org.openehealth.ipf.commons.core.config.ContextFacade;
import org.openehealth.ipf.commons.core.config.Registry;
import org.openehealth.ipf.commons.spring.core.config.ProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;

public class SpringRegistry
implements Registry,
BeanFactoryAware {
    private ListableBeanFactory beanFactory;

    public Object bean(String name) {
        return this.beanFactory.getBean(name);
    }

    public <T> T bean(Class<T> requiredType) {
        return (T)this.beanFactory.getBean(requiredType);
    }

    public <T> Map<String, T> beans(Class<T> requiredType) {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, ProxyUtils.isJDKDynamicProxy(requiredType) ? ProxyUtils.getFirstProxiedInterface(requiredType) : requiredType);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ListableBeanFactory)beanFactory;
        ContextFacade.setRegistry((Registry)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpringRegistry)) {
            return false;
        }
        SpringRegistry that = (SpringRegistry)o;
        return Objects.equals(this.beanFactory, that.beanFactory);
    }

    public int hashCode() {
        return Objects.hash(this.beanFactory);
    }
}

