/**
* Essential OCL Grammar
* <copyright>
*
* Copyright (c) 2005, 2010 IBM Corporation and others.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*   IBM - Initial API and implementation
*   E.D.Willink - Elimination of some shift-reduce conflicts
*   E.D.Willink - Remove unnecessary warning suppression
*   E.D.Willink - Bugs 184048, 225493, 243976, 259818, 282882, 287993, 288040, 292112, 295166
*   Borland - Bug 242880
*   Adolfo Sanchez-Barbudo Herrera (Open Canarias):
*        - 242153: LPG v 2.0.17 adoption.
*        - 299396: Introducing new LPG templates
*        - 300534: Removing the use of deprecated macros.
* </copyright>
*
* $Id: OCLParserprs.java,v 1.24 2010/02/09 21:04:08 ewillink Exp $
*/
/**
* Complete OCL Grammar
* <copyright>
*
* Copyright (c) 2005, 2009 IBM Corporation and others.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*   IBM - Initial API and implementation
*   E.D.Willink - Bug 259818, 285633, 292112
*   Adolfo Sanchez-Barbudo Herrera (Open Canarias):
*        - 242153: LPG v 2.0.17 adoption.
*        - 299396: Introducing new LPG templates
*        - 300534: Removing the use of deprecated macros.
* </copyright>
*/

package org.eclipse.ocl.parser;

/**
 * @noextend This interface is not intended to be extended by clients.
 */
@SuppressWarnings("nls")
public class OCLParserprs implements lpg.runtime.ParseTable, OCLParsersym {
    public final static int ERROR_SYMBOL = 79;
    public final int getErrorSymbol() { return ERROR_SYMBOL; }

    public final static int SCOPE_UBOUND = 44;
    public final int getScopeUbound() { return SCOPE_UBOUND; }

    public final static int SCOPE_SIZE = 45;
    public final int getScopeSize() { return SCOPE_SIZE; }

    public final static int MAX_NAME_LENGTH = 29;
    public final int getMaxNameLength() { return MAX_NAME_LENGTH; }

    public final static int NUM_STATES = 243;
    public final int getNumStates() { return NUM_STATES; }

    public final static int NT_OFFSET = 79;
    public final int getNtOffset() { return NT_OFFSET; }

    public final static int LA_STATE_OFFSET = 4624;
    public final int getLaStateOffset() { return LA_STATE_OFFSET; }

    public final static int MAX_LA = 1;
    public final int getMaxLa() { return MAX_LA; }

    public final static int NUM_RULES = 303;
    public final int getNumRules() { return NUM_RULES; }

    public final static int NUM_NONTERMINALS = 120;
    public final int getNumNonterminals() { return NUM_NONTERMINALS; }

    public final static int NUM_SYMBOLS = 199;
    public final int getNumSymbols() { return NUM_SYMBOLS; }

    public final static int SEGMENT_SIZE = 8192;
    public final int getSegmentSize() { return SEGMENT_SIZE; }

    public final static int START_STATE = 3925;
    public final int getStartState() { return START_STATE; }

    public final static int IDENTIFIER_SYMBOL = 7;
    public final int getIdentifier_SYMBOL() { return IDENTIFIER_SYMBOL; }

    public final static int EOFT_SYMBOL = 76;
    public final int getEoftSymbol() { return EOFT_SYMBOL; }

    public final static int EOLT_SYMBOL = 76;
    public final int getEoltSymbol() { return EOLT_SYMBOL; }

    public final static int ACCEPT_ACTION = 4320;
    public final int getAcceptAction() { return ACCEPT_ACTION; }

    public final static int ERROR_ACTION = 4321;
    public final int getErrorAction() { return ERROR_ACTION; }

    public final static boolean BACKTRACK = false;
    public final boolean getBacktrack() { return BACKTRACK; }

    public final int getStartSymbol() { return lhs(0); }
    public final boolean isValidForParser() { return OCLParsersym.isValidForParser; }


    public interface IsNullable {
        public final static byte isNullable[] = {0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            1,0,0,0,1,1,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            1,0,1,1,0,0,0,0,0,0,
            1,0,1,0,0,1,0,0,0,0,
            0,0,1,0,0,0,0,0,0
        };
    };
    public final static byte isNullable[] = IsNullable.isNullable;
    public final boolean isNullable(int index) { return isNullable[index] != 0; }

    public interface ProsthesesIndex {
        public final static byte prosthesesIndex[] = {0,
            12,13,9,10,15,17,18,11,29,30,
            31,32,33,38,39,40,41,42,43,44,
            46,47,48,49,50,51,52,53,54,59,
            60,61,86,88,89,90,91,100,83,84,
            85,80,81,82,77,78,79,74,75,76,
            71,72,73,68,69,70,65,66,67,24,
            55,62,63,64,21,6,8,14,25,56,
            99,57,16,22,23,58,97,94,28,87,
            109,110,111,112,27,36,37,95,96,103,
            26,34,35,98,101,102,105,108,114,115,
            116,119,120,2,3,4,19,20,45,92,
            93,104,106,107,113,117,118,1,5,7
        };
    };
    public final static byte prosthesesIndex[] = ProsthesesIndex.prosthesesIndex;
    public final int prosthesesIndex(int index) { return prosthesesIndex[index]; }

    public interface IsKeyword {
        public final static byte isKeyword[] = {0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,0,0,0,0,1,
            1,0,0,1,1,1,1,1,1,1,
            1,1,1,1,1,0,1,1,1,0,
            0,1,1,1,1,0,0,0,1,0,
            1,1,1,1,1,0,0,0,0
        };
    };
    public final static byte isKeyword[] = IsKeyword.isKeyword;
    public final boolean isKeyword(int index) { return isKeyword[index] != 0; }

    public interface BaseCheck {
        public final static short baseCheck[] = {0,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,2,1,1,1,
            3,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,4,4,
            0,1,1,3,1,3,3,5,1,1,
            1,1,1,1,1,1,1,1,1,1,
            4,4,0,1,1,3,1,1,3,1,
            1,1,1,1,1,1,4,1,3,1,
            1,1,2,1,1,1,1,1,1,1,
            1,1,1,1,1,8,10,10,8,10,
            1,1,1,5,6,8,8,7,7,5,
            6,9,1,4,6,4,7,5,0,0,
            1,1,3,1,1,1,1,1,1,1,
            1,1,3,1,3,1,1,1,3,1,
            3,1,1,1,3,1,3,1,1,1,
            3,1,3,1,1,1,3,3,1,3,
            3,1,1,1,3,3,3,3,1,3,
            3,3,3,1,1,1,3,3,1,3,
            3,1,1,1,3,3,1,3,3,1,
            1,1,2,2,1,2,2,1,1,1,
            1,1,1,3,7,4,1,3,1,1,
            1,1,1,0,1,1,1,1,1,1,
            1,1,1,1,1,0,1,1,0,1,
            7,2,2,1,6,6,0,1,1,3,
            1,3,1,1,1,2,1,1,4,1,
            0,1,1,2,1,1,1,7,1,2,
            3,3,3,5,1,2,4,4,5,3,
            3,3,1,2,4,4,4,6,8,0,
            1,1,3,-85,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,-91,0,
            0,-2,-3,0,-15,0,0,-4,-5,0,
            -6,-14,-72,0,0,-77,-10,0,-16,0,
            0,-89,0,0,-71,0,0,-86,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -90,0,0,0,0,-92,0,0,-210,-21,
            -22,-74,0,0,0,0,-33,-23,-164,0,
            0,-184,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-25,-26,-28,-31,0,0,0,-32,-34,
            -35,-36,-118,-37,-134,-39,0,-224,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,-41,-42,
            -43,0,-44,-45,-46,-29,-47,-48,-116,-172,
            0,0,0,-177,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-49,
            -13,0,0,0,0,0,0,-27,-50,-51,
            -52,-56,-57,-58,-59,-60,-61,-62,-63,-64,
            0,-68,-75,0,0,-136,-80,0,0,0,
            -178,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,-81,-82,
            -88,-93,-100,-101,-102,-113,-114,-115,-117,-119,
            -121,-122,-123,-124,-125,-126,0,-127,-128,-129,
            0,-169,-130,-197,0,0,0,-120,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-132,0,-133,-206,
            -148,0,0,0,-167,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-135,-138,0,-139,-216,-220,0,0,
            0,-175,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-140,
            -141,-142,-143,-144,-145,-146,-147,-151,-152,-153,
            -154,-155,-156,-236,-157,-137,-158,0,0,-196,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-159,-170,0,
            -171,-176,-179,-182,-183,0,-199,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-185,-186,-187,-188,-190,0,-192,-193,-194,
            -195,-198,0,-200,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,-201,-202,
            -203,-204,-205,0,-207,-209,-211,-214,-215,0,
            -227,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-217,-218,-228,-229,-230,
            0,-231,-232,-233,-234,-235,0,-79,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-237,-241,-242,-243,0,0,-181,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-213,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -223,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-17,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-19,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-20,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-38,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-40,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-65,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-66,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-67,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-70,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-111,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-131,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-149,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-160,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-161,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-168,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-174,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-191,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-219,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-221,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-238,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-239,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-240,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-94,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-110,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,-95,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-109,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,-96,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-97,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-105,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-106,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-107,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-108,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-98,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-99,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,-53,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-54,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,-189,0,0,0,0,0,0,
            0,0,0,-103,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-104,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-1,0,0,-173,0,0,
            0,-225,0,0,0,0,0,0,0,0,
            -83,0,0,0,0,-162,0,0,0,0,
            -226,0,0,0,0,0,0,0,-55,0,
            0,0,0,0,-165,0,0,0,0,0,
            0,0,0,0,-7,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-8,0,0,0,0,-9,0,0,
            0,0,0,0,0,0,0,0,0,-11,
            0,0,0,0,-12,0,0,0,0,-18,
            0,0,0,0,0,0,0,-24,0,0,
            0,0,-87,0,0,0,0,0,0,0,
            -150,0,0,0,0,0,0,0,-163,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-30,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,-208,0,0,0,0,-69,0,
            0,0,0,0,0,0,-166,0,0,0,
            0,0,0,0,0,0,-73,0,0,0,
            0,0,0,0,-76,0,0,0,0,0,
            0,0,-212,0,0,0,0,0,0,0,
            -78,0,0,0,0,-180,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-84,
            0,0,0,0,-112,0,0,0,0,0,
            0,0,0,-222,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0
        };
    };
    public final static short baseCheck[] = BaseCheck.baseCheck;
    public final int baseCheck(int index) { return baseCheck[index]; }
    public final static short rhs[] = baseCheck;
    public final int rhs(int index) { return rhs[index]; };

    public interface BaseAction {
        public final static char baseAction[] = {
            104,105,105,105,105,105,105,105,105,105,
            105,105,105,105,105,105,106,119,119,119,
            119,119,119,119,119,119,119,119,66,120,
            67,67,67,8,1,1,2,2,68,68,
            5,5,4,4,4,4,4,4,4,4,
            3,3,3,3,3,73,73,73,73,6,
            7,107,107,108,108,74,65,75,69,91,
            91,85,85,79,79,79,79,9,9,9,
            9,10,10,92,92,93,93,86,86,87,
            12,12,12,12,12,12,12,11,109,109,
            14,15,16,16,17,17,18,19,20,13,
            13,13,21,21,23,23,24,24,24,25,
            25,22,22,22,27,27,27,27,27,27,
            27,27,27,29,28,28,30,30,30,72,
            76,76,70,70,60,60,32,31,61,61,
            64,64,62,62,63,63,58,58,57,57,
            59,59,55,55,54,54,56,56,52,52,
            51,51,53,53,49,49,48,48,48,50,
            50,50,46,46,45,45,45,45,45,47,
            47,47,47,47,43,43,42,42,42,44,
            44,44,40,40,39,39,39,41,41,41,
            80,80,33,33,33,34,34,34,26,26,
            35,35,35,35,35,37,36,110,110,104,
            104,104,104,104,104,119,119,119,119,119,
            119,119,119,119,119,119,77,77,4,94,
            94,27,30,71,72,38,38,95,95,96,
            96,90,90,90,35,111,111,112,112,97,
            113,114,114,98,98,81,81,81,82,115,
            115,89,89,83,83,99,99,78,78,78,
            100,100,84,117,117,88,88,88,101,116,
            102,102,103,103,209,487,373,574,109,569,
            572,111,146,222,77,78,79,80,90,91,
            570,93,94,95,96,220,112,113,114,115,
            576,121,122,123,133,655,221,204,207,565,
            215,223,264,649,742,199,651,741,189,650,
            743,179,654,740,172,653,744,166,658,739,
            160,657,745,154,848,144,746,149,730,459,
            756,373,99,390,1003,274,40,373,346,11,
            4122,270,435,274,40,373,626,10,659,247,
            85,87,274,927,373,160,846,849,209,487,
            373,574,109,569,572,111,146,222,77,78,
            79,80,90,91,570,93,94,95,96,220,
            112,113,114,115,576,121,122,123,133,655,
            221,204,207,565,215,223,264,649,742,199,
            651,741,189,650,743,179,654,740,172,653,
            744,166,658,739,160,657,745,154,848,144,
            746,149,730,274,275,276,277,274,275,276,
            277,274,929,373,16,575,274,1096,373,557,
            486,506,16,294,85,87,266,165,563,194,
            850,849,53,930,373,574,109,569,572,111,
            146,222,77,78,79,80,90,91,570,93,
            94,95,96,220,112,113,114,115,576,121,
            122,123,133,655,221,204,207,565,215,223,
            264,649,742,199,651,741,189,650,743,179,
            654,740,172,653,744,166,658,739,160,657,
            745,154,1319,1323,746,149,730,1322,829,757,
            286,1320,588,593,659,107,71,286,280,335,
            616,12,3,424,195,159,211,1321,157,1094,
            373,574,109,569,572,111,146,222,77,78,
            79,80,90,91,570,93,94,95,96,220,
            112,113,114,115,576,121,122,123,133,655,
            221,204,207,565,215,223,264,649,742,199,
            651,741,189,650,743,179,654,740,172,653,
            744,166,658,739,160,657,745,154,142,144,
            746,149,730,72,254,134,254,1173,1406,356,
            21,471,71,172,334,313,61,594,617,217,
            274,842,373,1405,1,487,373,574,109,569,
            572,111,146,222,77,78,79,80,90,91,
            570,93,94,95,96,220,112,113,114,115,
            576,121,122,123,133,655,221,204,207,565,
            215,223,264,649,742,199,651,741,189,650,
            743,179,654,740,172,653,744,166,658,739,
            160,657,745,154,263,144,746,149,730,70,
            403,274,564,373,285,69,656,285,56,618,
            397,480,428,47,461,646,517,561,219,472,
            654,99,665,602,259,482,307,510,489,1248,
            1250,1,487,373,574,109,569,572,111,146,
            222,77,78,79,80,90,91,570,93,94,
            95,96,220,112,113,114,115,576,121,122,
            123,133,655,221,204,207,565,215,223,264,
            649,742,199,651,741,189,650,743,179,654,
            740,172,653,744,166,658,739,160,657,745,
            154,263,144,746,149,730,293,254,1174,660,
            264,667,669,263,482,670,674,675,90,298,
            108,167,485,676,684,686,275,738,398,689,
            672,259,159,688,643,395,1251,1250,261,487,
            373,574,109,569,572,111,146,222,77,78,
            79,80,90,91,570,93,94,95,96,220,
            112,113,114,115,576,121,122,123,133,655,
            221,204,207,565,215,223,264,649,742,199,
            651,741,189,650,743,179,654,740,172,653,
            744,166,658,739,160,657,745,154,142,144,
            746,149,730,254,138,254,1329,691,1171,693,
            589,274,835,373,1169,261,487,373,574,109,
            569,572,111,146,222,77,78,79,80,90,
            91,570,93,94,95,96,220,112,113,114,
            115,576,121,122,123,133,655,221,204,207,
            565,215,223,264,649,742,199,651,741,189,
            650,743,179,654,740,172,653,744,166,658,
            739,160,657,745,154,142,144,746,149,730,
            228,829,757,696,533,1171,700,159,274,835,
            373,1246,157,487,373,574,109,569,572,111,
            146,222,77,78,79,80,90,91,570,93,
            94,95,96,220,112,113,114,115,576,121,
            122,123,133,655,221,204,207,565,215,223,
            264,649,742,199,651,741,189,650,743,179,
            654,740,172,653,744,166,658,739,160,657,
            745,154,848,144,746,149,730,1399,254,137,
            595,536,427,125,151,325,487,502,4,535,
            554,555,619,620,641,560,314,567,86,87,
            261,487,373,574,109,569,572,111,146,222,
            77,78,79,80,90,91,570,93,94,95,
            96,220,112,113,114,115,576,121,122,123,
            133,655,221,204,207,565,215,223,264,649,
            742,199,651,741,189,650,743,179,654,740,
            172,653,744,166,658,739,160,657,745,154,
            142,144,746,149,730,829,757,1175,701,702,
            1171,703,705,706,709,713,1328,261,487,373,
            574,109,569,572,111,146,222,77,78,79,
            80,90,91,570,93,94,95,96,220,112,
            113,114,115,576,121,122,123,133,655,221,
            204,207,565,215,223,264,649,742,199,651,
            741,189,650,743,179,654,740,172,653,744,
            166,658,739,160,657,745,154,142,144,746,
            149,730,711,715,716,718,721,1171,722,726,
            727,728,474,1396,261,487,373,574,109,569,
            572,111,146,222,77,78,79,80,90,91,
            570,93,94,95,96,220,112,113,114,115,
            576,121,122,123,133,655,221,204,207,565,
            215,223,264,649,742,199,651,741,189,650,
            743,179,654,740,172,653,744,166,658,739,
            160,657,745,154,142,144,746,149,730,732,
            731,495,735,737,1171,739,740,741,748,751,
            1397,261,487,373,574,109,569,572,111,146,
            222,77,78,79,80,90,91,570,93,94,
            95,96,220,112,113,114,115,576,121,122,
            123,133,655,221,204,207,565,215,223,264,
            649,742,199,651,741,189,650,743,179,654,
            740,172,653,744,166,658,739,160,657,745,
            154,142,144,746,149,730,754,755,758,745,
            759,1171,749,762,648,763,649,1473,157,487,
            373,574,109,569,572,111,146,222,77,78,
            79,80,90,91,570,93,94,95,96,220,
            112,113,114,115,576,121,122,123,133,655,
            221,204,207,565,215,223,264,649,742,199,
            651,741,189,650,743,179,654,740,172,653,
            744,166,658,739,160,657,745,154,142,144,
            746,149,730,764,767,771,772,4321,840,157,
            487,373,574,109,569,572,111,146,222,77,
            78,79,80,90,91,570,93,94,95,96,
            220,112,113,114,115,576,121,122,123,133,
            655,221,204,207,565,215,223,264,649,742,
            199,651,741,189,650,743,179,654,740,172,
            653,744,166,658,739,160,657,745,154,142,
            144,746,149,730,4321,4321,4321,4321,4321,1252,
            105,487,373,574,109,569,572,111,146,222,
            77,78,79,80,90,91,570,93,94,95,
            96,220,112,113,114,115,576,121,122,123,
            133,655,221,204,207,565,215,223,264,649,
            742,199,651,741,189,650,743,179,654,740,
            172,653,744,166,658,739,160,657,745,154,
            263,144,746,149,730,4321,4321,4321,4321,4321,
            4321,4321,4321,4321,4321,4321,4321,4321,4321,4321,
            4321,4321,4321,4321,4321,4321,4321,4321,4321,4321,
            260,157,487,373,574,109,569,572,111,146,
            222,77,78,79,80,90,91,570,93,94,
            95,96,220,112,113,114,115,576,121,122,
            123,133,655,221,204,207,565,215,223,264,
            649,742,199,651,741,189,650,743,179,654,
            740,172,653,744,166,658,739,160,657,745,
            154,142,144,746,149,730,4321,4321,4321,4321,
            4321,1404,157,487,373,574,109,569,572,111,
            146,222,77,78,79,80,90,91,570,93,
            94,95,96,220,112,113,114,115,576,121,
            122,123,133,655,221,204,207,565,215,223,
            264,649,742,199,651,741,189,650,743,179,
            654,740,172,653,744,166,658,739,160,657,
            745,154,67,144,746,149,730,157,487,373,
            574,109,569,572,111,146,222,77,78,79,
            80,90,91,570,93,94,95,96,220,112,
            113,114,115,576,121,122,123,133,655,221,
            204,207,565,215,223,264,649,742,199,651,
            741,189,650,743,179,654,740,172,653,744,
            166,658,739,160,657,745,154,282,144,746,
            149,730,157,487,373,574,109,569,572,111,
            146,222,77,78,79,80,90,91,570,93,
            94,95,96,220,112,113,114,115,576,121,
            122,123,133,655,221,204,207,565,215,223,
            264,649,742,199,651,741,189,650,743,179,
            654,740,172,653,744,166,658,739,160,657,
            745,154,281,144,746,149,730,157,487,373,
            574,109,569,572,111,146,222,77,78,79,
            80,90,91,570,93,94,95,96,220,112,
            113,114,115,576,121,122,123,133,655,221,
            204,207,565,215,223,264,649,742,199,651,
            741,189,650,743,179,654,740,172,653,744,
            166,658,739,160,657,745,154,831,144,746,
            149,730,157,487,373,574,109,569,572,111,
            146,222,77,78,79,80,90,91,570,93,
            94,95,96,220,112,113,114,115,576,121,
            122,123,133,655,221,204,207,565,215,223,
            264,649,742,199,651,741,189,650,743,179,
            654,740,172,653,744,166,658,739,160,657,
            745,154,832,144,746,149,730,157,487,373,
            574,109,569,572,111,146,222,77,78,79,
            80,90,91,570,93,94,95,96,220,112,
            113,114,115,576,121,122,123,133,655,221,
            204,207,565,215,223,264,649,742,199,651,
            741,189,650,743,179,654,740,172,653,744,
            166,658,739,160,657,745,154,297,144,746,
            149,730,157,487,373,574,109,569,572,111,
            146,222,77,78,79,80,90,91,570,93,
            94,95,96,220,112,113,114,115,576,121,
            122,123,133,655,221,204,207,565,215,223,
            264,649,742,199,651,741,189,650,743,179,
            654,740,172,653,744,166,658,739,160,657,
            745,154,296,144,746,149,730,157,487,373,
            574,109,569,572,111,146,222,77,78,79,
            80,90,91,570,93,94,95,96,220,112,
            113,114,115,576,121,122,123,133,655,221,
            204,207,565,215,223,264,649,742,199,651,
            741,189,650,743,179,654,740,172,653,744,
            166,658,739,160,657,745,154,295,144,746,
            149,730,157,487,373,574,109,569,572,111,
            146,222,77,78,79,80,90,91,570,93,
            94,95,96,220,112,113,114,115,576,121,
            122,123,133,655,221,204,207,565,215,223,
            264,649,742,199,651,741,189,650,743,179,
            654,740,172,653,744,166,658,739,160,657,
            745,154,287,144,746,149,730,157,487,373,
            574,109,569,572,111,146,222,77,78,79,
            80,90,91,570,93,94,95,96,220,112,
            113,114,115,576,121,122,123,133,655,221,
            204,207,565,215,223,264,649,742,199,651,
            741,189,650,743,179,654,740,172,653,744,
            166,658,739,160,657,745,154,68,144,746,
            149,730,157,487,373,574,109,569,572,111,
            146,222,77,78,79,80,90,91,570,93,
            94,95,96,220,112,113,114,115,576,121,
            122,123,133,655,221,204,207,565,215,223,
            264,649,742,199,651,741,189,650,743,179,
            654,740,172,653,744,166,658,739,160,657,
            745,154,1172,144,746,149,730,157,487,373,
            574,109,569,572,111,146,222,77,78,79,
            80,90,91,570,93,94,95,96,220,112,
            113,114,115,576,121,122,123,133,655,221,
            204,207,565,215,223,264,649,742,199,651,
            741,189,650,743,179,654,740,172,653,744,
            166,658,739,160,657,745,154,226,144,746,
            149,730,157,487,373,574,109,569,572,111,
            146,222,77,78,79,80,90,91,570,93,
            94,95,96,220,112,113,114,115,576,121,
            122,123,133,655,221,204,207,565,215,223,
            264,649,742,199,651,741,189,650,743,179,
            654,740,172,653,744,166,658,739,160,657,
            745,154,291,144,746,149,730,157,487,373,
            574,109,569,572,111,146,222,77,78,79,
            80,90,91,570,93,94,95,96,220,112,
            113,114,115,576,121,122,123,133,655,221,
            204,207,565,215,223,264,649,742,199,651,
            741,189,650,743,179,654,740,172,653,744,
            166,658,739,160,657,745,154,290,144,746,
            149,730,157,487,373,574,109,569,572,111,
            146,222,77,78,79,80,90,91,570,93,
            94,95,96,220,112,113,114,115,576,121,
            122,123,133,655,221,204,207,565,215,223,
            264,649,742,199,651,741,189,650,743,179,
            654,740,172,653,744,166,658,739,160,657,
            745,154,143,144,746,149,730,157,487,373,
            574,109,569,572,111,146,222,77,78,79,
            80,90,91,570,93,94,95,96,220,112,
            113,114,115,576,121,122,123,133,655,221,
            204,207,565,215,223,264,649,742,199,651,
            741,189,650,743,179,654,740,172,653,744,
            166,658,739,160,657,745,154,89,144,746,
            149,730,157,487,373,574,109,569,572,111,
            146,222,77,78,79,80,90,91,570,93,
            94,95,96,220,112,113,114,115,576,121,
            122,123,133,655,221,204,207,565,215,223,
            264,649,742,199,651,741,189,650,743,179,
            654,740,172,653,744,166,658,739,160,657,
            745,154,1327,144,746,149,730,157,487,373,
            574,109,569,572,111,146,222,77,78,79,
            80,90,91,570,93,94,95,96,220,112,
            113,114,115,576,121,122,123,133,655,221,
            204,207,565,215,223,264,649,742,199,651,
            741,189,650,743,179,654,740,172,653,744,
            166,658,739,160,657,745,154,1398,144,746,
            149,730,157,487,373,574,109,569,572,111,
            146,222,77,78,79,80,90,91,570,93,
            94,95,96,220,112,113,114,115,576,121,
            122,123,133,655,221,204,207,565,215,223,
            264,649,742,199,651,741,189,650,743,179,
            654,740,172,653,744,166,658,739,160,657,
            745,154,1400,144,746,149,730,157,487,373,
            574,109,569,572,111,146,222,77,78,79,
            80,90,91,570,93,94,95,96,220,112,
            113,114,115,576,121,122,123,133,655,221,
            204,207,565,215,223,264,649,742,199,651,
            741,189,650,743,179,654,740,172,653,744,
            166,658,739,160,657,745,154,1474,144,746,
            149,730,157,487,373,574,109,569,572,111,
            146,222,77,78,79,80,90,91,570,93,
            94,95,96,220,112,113,114,115,576,121,
            122,123,133,655,221,204,207,565,215,223,
            264,649,742,199,651,741,189,650,743,179,
            654,740,172,653,744,166,658,739,160,657,
            745,154,1475,144,746,149,730,157,487,373,
            574,109,569,572,111,146,222,77,78,79,
            80,90,91,570,93,94,95,96,220,112,
            113,114,115,576,121,122,123,133,655,221,
            204,207,565,215,223,264,649,742,199,651,
            741,189,650,743,179,654,740,172,653,744,
            166,658,739,160,657,745,154,1476,144,746,
            149,730,157,487,373,574,109,569,572,111,
            146,222,77,78,79,80,90,91,570,93,
            94,95,96,220,112,113,114,115,576,121,
            122,123,133,1004,221,204,207,565,215,223,
            264,649,742,199,651,741,189,650,743,179,
            654,740,172,653,744,166,658,739,160,156,
            1006,155,157,487,373,574,109,569,572,111,
            146,222,77,78,79,80,90,91,570,93,
            94,95,96,220,112,113,114,115,576,121,
            122,123,133,1097,221,204,207,565,215,223,
            264,649,742,199,651,741,189,650,743,179,
            654,740,172,653,744,166,162,1168,161,157,
            487,373,574,109,569,572,111,146,222,77,
            78,79,80,90,91,570,93,94,95,96,
            220,112,113,114,115,576,121,122,123,133,
            1080,221,204,207,565,215,223,264,649,742,
            199,651,741,189,650,743,179,654,740,172,
            168,1081,167,157,487,373,574,109,569,572,
            111,146,222,77,78,79,80,90,91,570,
            93,94,95,96,220,112,113,114,115,576,
            121,122,123,133,1093,221,204,207,565,215,
            223,264,649,742,199,651,741,189,650,743,
            179,174,1095,173,157,487,373,574,109,569,
            572,111,146,222,77,78,79,80,90,91,
            570,93,94,95,96,220,112,113,114,115,
            576,121,122,123,133,1082,221,204,207,565,
            215,223,264,649,742,199,651,741,189,182,
            1083,181,157,487,373,574,109,569,572,111,
            146,222,77,78,79,80,90,91,570,93,
            94,95,96,220,112,113,114,115,576,121,
            122,123,133,1082,221,204,207,565,215,223,
            264,649,742,199,651,741,189,182,1084,180,
            157,487,373,574,109,569,572,111,146,222,
            77,78,79,80,90,91,570,93,94,95,
            96,220,112,113,114,115,576,121,122,123,
            133,1088,221,204,207,565,215,223,264,649,
            742,199,194,1089,193,157,487,373,574,109,
            569,572,111,146,222,77,78,79,80,90,
            91,570,93,94,95,96,220,112,113,114,
            115,576,121,122,123,133,1088,221,204,207,
            565,215,223,264,649,742,199,194,1090,192,
            157,487,373,574,109,569,572,111,146,222,
            77,78,79,80,90,91,570,93,94,95,
            96,220,112,113,114,115,576,121,122,123,
            133,1088,221,204,207,565,215,223,264,649,
            742,199,194,1091,191,157,487,373,574,109,
            569,572,111,146,222,77,78,79,80,90,
            91,570,93,94,95,96,220,112,113,114,
            115,576,121,122,123,133,1088,221,204,207,
            565,215,223,264,649,742,199,194,1092,190,
            157,487,373,574,109,569,572,111,146,222,
            77,78,79,80,90,91,570,93,94,95,
            96,220,112,113,114,115,576,121,122,123,
            133,1085,221,204,207,565,215,223,264,202,
            1086,201,157,487,373,574,109,569,572,111,
            146,222,77,78,79,80,90,91,570,93,
            94,95,96,220,112,113,114,115,576,121,
            122,123,133,1085,221,204,207,565,215,223,
            264,202,1087,200,157,487,373,574,109,569,
            572,111,146,222,77,78,79,80,90,91,
            570,93,94,95,96,220,112,113,114,115,
            576,121,122,123,133,833,221,210,217,565,
            215,223,264,157,487,373,574,109,569,572,
            111,146,222,77,78,79,80,90,91,570,
            93,94,95,96,220,112,113,114,115,576,
            121,122,123,133,833,221,210,216,565,215,
            223,264,4321,4321,214,4321,4321,4321,4321,4321,
            4321,4321,4321,4321,4321,4321,4321,4321,4321,4321,
            4321,4321,4321,4321,4321,4321,4321,4321,4321,4321,
            4321,4321,4321,4321,300,4321,4321,4321,4321,4321,
            4321,4321,4321,213,157,487,373,574,109,569,
            572,111,146,222,77,78,79,80,90,91,
            570,93,94,95,96,220,112,113,114,115,
            576,121,122,123,133,833,221,210,209,565,
            215,223,264,157,487,373,574,109,569,572,
            111,146,222,77,78,79,80,90,91,570,
            93,94,95,96,220,112,113,114,115,576,
            121,122,123,133,833,221,210,208,565,215,
            223,264,4321,279,206,337,378,373,274,844,
            373,4321,497,40,373,749,55,750,57,58,
            4321,274,842,373,4321,4321,508,378,373,479,
            4321,497,40,373,749,55,750,57,58,274,
            835,373,4321,205,4321,508,378,373,4321,4321,
            4321,4321,4321,4321,4321,351,38,373,30,31,
            4321,4321,4321,4321,4321,4321,4321,4321,4321,4321,
            75,4321,4321,64,76,4321,4321,4321,4321,73,
            74,4321,4321,230,233,250,273,275,276,277,
            70,75,4321,231,232,76,69,4321,4321,4321,
            73,74,267,382,250,302,298,4321,227,372,
            75,4321,98,4321,76,4321,389,265,268,73,
            74,32,39,247,302,299,4321,4321,1243,1244,
            841,4321,480,351,38,373,30,31,351,38,
            373,30,31,4321,4321,4321,4321,1245,1244,834,
            351,38,373,30,31,351,38,373,30,31,
            387,40,373,749,55,750,57,58,351,38,
            373,30,31,387,40,373,749,55,750,57,
            58,387,40,373,749,55,750,57,58,387,
            40,373,749,55,750,57,58,4321,4321,32,
            39,247,348,4321,32,39,247,4321,4321,4321,
            481,4321,4321,4321,4321,488,32,39,247,4321,
            4321,32,39,247,274,378,373,562,4321,274,
            838,373,563,747,32,39,247,387,40,373,
            749,55,750,57,58,752,853,423,38,373,
            30,31,4321,4321,1242,423,38,373,30,31,
            4321,4321,66,387,40,373,749,55,750,57,
            58,423,38,373,30,31,423,38,373,30,
            31,4321,4321,273,275,276,277,4321,4321,75,
            362,844,373,76,837,274,838,373,73,74,
            386,4321,4321,303,274,1403,373,4321,4321,4321,
            3834,4321,4321,32,39,839,753,4321,4321,4321,
            4321,32,39,41,4321,4321,4321,4321,4321,288,
            836,4321,4321,4321,4321,4321,262,32,39,573,
            4321,4321,32,39,854,4321,4321,4321,4321,4321,
            4321,4321,4321,4321,4321,63,4321,4321,4321,4321,
            837,4321,4321,4321,4321,4321,4321,4321,4321,72,
            4321,4321,4321,4321,4321,4321,4321,4321,71,4321,
            4321,4321,4321,4321,4321,4321,4321,4321,4321,1402,
            4321,4321,4321,4321,4321,289,836,843,845,4321,
            4321
        };
    };
    public final static char baseAction[] = BaseAction.baseAction;
    public final int baseAction(int index) { return baseAction[index]; }
    public final static char lhs[] = baseAction;
    public final int lhs(int index) { return lhs[index]; };

    public interface TermCheck {
        public final static byte termCheck[] = {0,
            0,1,0,0,4,5,6,7,5,0,
            0,0,1,3,11,0,13,14,15,16,
            0,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,17,18,19,
            20,41,42,43,44,45,0,47,48,49,
            50,51,0,1,2,0,4,5,6,7,
            0,52,60,17,18,19,20,52,68,54,
            55,60,12,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,0,
            1,0,3,41,42,43,44,45,0,47,
            48,49,50,51,0,1,0,0,4,5,
            6,7,52,58,54,55,9,62,63,13,
            14,15,16,0,0,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,17,18,19,20,41,42,43,44,45,
            0,47,48,49,50,51,0,1,0,0,
            4,5,6,7,0,1,0,17,18,19,
            20,0,68,66,76,9,12,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,0,0,1,38,41,42,43,
            44,45,38,47,48,49,50,51,0,1,
            0,40,4,5,6,7,0,58,0,1,
            56,62,63,13,14,15,16,61,12,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,52,0,54,55,41,
            42,43,44,45,60,47,48,49,50,51,
            0,1,0,0,4,5,6,7,52,0,
            54,55,3,0,0,13,14,15,16,6,
            7,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,0,1,0,
            3,41,42,43,44,45,0,47,48,49,
            50,51,0,0,1,69,4,5,12,0,
            8,58,10,11,0,13,14,15,16,17,
            18,19,20,0,0,61,0,13,14,15,
            16,8,6,7,38,0,12,0,3,37,
            0,38,40,8,0,0,6,7,46,12,
            5,0,56,64,65,53,11,6,7,57,
            37,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,0,0,52,0,
            54,55,6,7,58,59,0,0,62,63,
            64,65,0,0,8,69,59,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,0,0,1,36,0,0,6,7,
            4,5,5,37,0,12,10,11,11,13,
            14,15,16,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,0,57,
            0,38,4,5,6,7,8,70,10,11,
            0,0,1,0,4,17,18,19,20,0,
            10,0,9,4,0,0,0,3,3,10,
            9,5,8,59,0,37,0,11,40,41,
            40,0,6,7,46,0,5,0,3,0,
            1,53,11,6,7,57,0,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,0,39,0,0,4,5,4,66,
            8,0,10,11,10,13,14,15,16,17,
            18,19,20,0,0,74,0,4,4,0,
            0,67,0,10,10,3,0,8,8,37,
            4,5,40,57,8,40,10,11,46,13,
            14,15,16,17,18,19,20,0,0,1,
            3,3,0,0,0,3,37,9,4,5,
            12,0,8,37,10,11,40,13,14,15,
            16,17,18,19,20,0,0,0,0,0,
            64,65,4,4,5,0,38,39,10,10,
            11,37,13,14,15,16,17,18,19,20,
            0,1,0,3,56,0,53,0,0,2,
            2,36,12,0,12,67,9,9,0,0,
            1,3,46,46,0,12,0,3,0,0,
            2,0,3,0,0,0,75,2,38,39,
            38,8,8,0,59,0,3,0,0,2,
            0,1,0,1,9,0,56,9,53,0,
            0,0,0,2,0,0,1,12,0,1,
            0,9,0,1,0,0,2,0,8,2,
            0,0,2,2,9,0,0,0,3,2,
            0,0,61,2,0,9,0,71,0,0,
            0,3,3,9,0,9,46,0,0,2,
            0,1,53,0,0,2,2,0,0,2,
            2,0,0,0,3,2,0,0,2,39,
            0,0,2,2,0,0,72,0,0,0,
            0,0,0,39,0,0,0,39,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,39,0,0,0,0,0,0,0,0,
            0,0,0,73,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0
        };
    };
    public final static byte termCheck[] = TermCheck.termCheck;
    public final int termCheck(int index) { return termCheck[index]; }

    public interface TermAction {
        public final static char termAction[] = {0,
            257,1972,110,195,3763,4427,4357,4355,203,4321,
            4321,4321,4210,1777,203,283,219,219,219,219,
            176,4371,4372,4373,4374,4375,4366,4364,4367,4365,
            4363,571,4368,4370,4369,4569,4423,182,182,182,
            182,3724,4421,4422,4354,1907,4321,3959,4425,4426,
            4429,4428,4321,1972,4445,4321,3763,4427,4357,4355,
            4321,4088,304,3595,3550,3505,3460,4070,1249,4075,
            387,3941,4167,4371,4372,4373,4374,4375,4366,4364,
            4367,4365,4363,571,4368,4370,4369,4569,4423,4321,
            3946,4321,4109,3724,4421,4422,4354,1907,4321,3959,
            4425,4426,4429,4428,4321,1972,212,4321,3763,4427,
            4357,4355,4070,4058,4075,387,2622,4053,3975,218,
            218,218,218,4321,178,4371,4372,4373,4374,4375,
            4366,4364,4367,4365,4363,571,4368,4370,4369,4569,
            4423,3595,3550,3505,3460,3724,4421,4422,4354,1907,
            177,3959,4425,4426,4429,4428,4321,1972,139,292,
            3763,4427,4357,4355,147,139,4321,3595,3550,3505,
            3460,164,1249,852,4320,660,40,4371,4372,4373,
            4374,4375,4366,4364,4367,4365,4363,571,4368,4370,
            4369,4569,4423,284,4321,4093,830,3724,4421,4422,
            4354,1907,830,3959,4425,4426,4429,4428,83,1972,
            4321,168,3763,4427,4357,4355,4321,4058,4321,4210,
            1408,4053,3975,476,369,392,471,4418,4175,4371,
            4372,4373,4374,4375,4366,4364,4367,4365,4363,571,
            4368,4370,4369,4569,4423,4070,229,4075,387,3724,
            4421,4422,4354,1907,398,3959,4425,4426,4429,4428,
            140,1972,211,4321,3763,4427,4357,4355,4070,4321,
            4075,387,1842,4321,4321,219,219,219,219,4357,
            4355,4371,4372,4373,4374,4375,4366,4364,4367,4365,
            4363,571,4368,4370,4369,4569,4423,41,3965,4321,
            4157,3724,4421,4422,4354,1907,139,3959,4425,4426,
            4429,4428,145,4321,492,375,195,203,40,4321,
            175,4574,195,203,203,219,219,219,219,183,
            183,183,183,170,4321,4403,234,219,219,219,
            219,174,4357,4355,830,65,4191,271,4080,175,
            246,830,169,1712,4321,196,4357,4355,163,4175,
            202,61,1479,379,381,157,202,4357,4355,151,
            174,4371,4372,4373,4374,4375,4366,4364,4367,4365,
            4363,4349,4368,4370,4369,4569,4321,4321,4070,35,
            4075,387,4357,4355,4058,731,4321,88,4053,3975,
            379,381,4321,4321,3412,375,731,4371,4372,4373,
            4374,4375,4366,4364,4367,4365,4363,748,4368,4370,
            4369,4569,4321,139,935,4358,183,4321,4357,4355,
            195,203,3883,3364,270,41,195,203,3844,219,
            219,219,219,4371,4372,4373,4374,4375,4366,4364,
            4367,4365,4363,4349,4368,4370,4369,4569,4321,3142,
            4321,830,4334,4335,4357,4355,4331,2687,4333,4336,
            184,4321,4093,4321,194,4330,4327,4329,4328,4321,
            194,4321,2622,3640,4321,4321,198,4101,2037,3682,
            931,3883,1712,731,4321,4332,249,3844,4322,4324,
            3313,197,4357,4355,4325,4321,3883,300,2102,4321,
            858,4326,3844,4357,4355,4323,148,4371,4372,4373,
            4374,4375,4366,4364,4367,4365,4363,748,4368,4370,
            4369,4569,157,2882,188,165,195,203,3640,1007,
            175,4321,195,203,3682,219,219,219,219,183,
            183,183,183,187,186,2427,278,3640,3640,171,
            66,1008,4321,3682,3682,2167,163,3412,2297,175,
            195,203,169,150,175,3313,195,203,163,219,
            219,219,219,183,183,183,183,4321,147,139,
            4149,4080,4321,152,169,2232,3364,578,195,203,
            40,4321,175,175,195,203,169,219,219,219,
            219,183,183,183,183,92,158,4321,185,175,
            379,381,3640,195,203,272,830,65,3682,195,
            203,175,219,219,219,219,183,183,183,183,
            147,139,139,4109,1408,4321,156,4321,4321,4447,
            4448,4424,40,56,41,65,2622,2622,40,252,
            254,383,162,3259,4321,4175,4321,4215,4321,4321,
            4545,4321,4101,4321,4321,4321,4590,4381,830,65,
            830,2492,2557,4321,731,62,4109,4321,84,4380,
            4321,664,4321,761,3928,4321,1408,1012,3202,153,
            159,4321,141,4451,4321,4321,1100,4196,136,1177,
            4321,2622,4321,1254,4321,301,1325,4321,2297,1326,
            4321,4321,4452,4577,4144,261,258,4321,4183,4576,
            4321,4321,4402,4446,72,1550,144,2362,4321,4321,
            4321,3932,3951,4224,4321,1641,3259,4321,4321,4449,
            135,1331,3202,4321,4321,4450,4572,4321,4321,4440,
            4437,65,4321,4321,4109,4453,4321,4321,4441,2817,
            4321,4321,4439,4438,4321,4321,2752,4321,4321,4321,
            4321,4321,4321,2947,4321,4321,4321,3012,4321,4321,
            4321,4321,4321,4321,4321,4321,4321,4321,4321,4321,
            4321,3077,4321,4321,4321,4321,4321,4321,4321,4321,
            4321,4321,4321,4546
        };
    };
    public final static char termAction[] = TermAction.termAction;
    public final int termAction(int index) { return termAction[index]; }

    public interface Asb {
        public final static char asb[] = {0,
            392,98,52,100,463,463,446,446,446,404,
            446,446,227,96,227,97,198,212,198,198,
            463,463,463,446,463,463,295,308,309,465,
            59,312,55,106,148,151,148,198,380,198,
            63,67,65,73,71,59,75,74,230,232,
            234,237,198,198,227,49,143,240,242,76,
            250,194,194,244,198,198,198,463,227,198,
            291,227,212,92,467,212,466,212,198,194,
            257,297,227,353,1,1,212,299,227,227,
            34,227,355,198,198,198,198,198,198,59,
            301,463,198,198,198,198,198,198,198,198,
            198,227,423,423,304,309,307,56,314,324,
            321,317,355,463,103,32,320,321,32,355,
            198,194,194,193,312,55,193,59,75,59,
            73,59,67,67,59,63,63,227,198,212,
            59,65,65,65,65,59,71,59,74,198,
            198,353,212,92,353,212,324,198,58,355,
            103,227,227,198,198,385,196,196,194,212,
            198,257,194,324,423,355,103,355,190,355,
            198,355,102,103,355,324,56,314,324,324,
            355,255,254,253,103,357,463,227,463,186,
            387,212,197,355,257,58,355,355,198,227,
            198,227,198,198,406,425,324,355,255,355,
            255,389,103,255,103,358,355,198,198,198,
            355,355,355
        };
    };
    public final static char asb[] = Asb.asb;
    public final int asb(int index) { return asb[index]; }

    public interface Asr {
        public final static byte asr[] = {0,
            47,4,41,1,45,21,22,23,24,25,
            31,50,51,5,48,49,36,43,42,30,
            27,29,26,28,32,34,33,35,44,7,
            6,61,0,6,7,40,57,41,46,53,
            18,20,19,17,8,37,10,4,5,11,
            0,3,67,36,56,12,1,38,13,14,
            15,16,5,11,10,4,17,18,19,20,
            8,37,40,46,53,57,2,61,66,39,
            9,70,71,72,73,74,58,62,63,64,
            65,75,54,52,55,59,69,76,0,76,
            8,3,2,9,0,10,4,5,11,8,
            37,2,61,66,13,39,9,14,70,15,
            16,71,72,73,40,46,53,57,74,54,
            58,62,59,69,75,52,63,64,65,55,
            76,36,17,18,19,20,0,1,60,0,
            10,4,5,11,17,18,8,19,20,37,
            2,61,66,13,39,9,14,70,15,16,
            71,72,73,40,46,53,57,74,54,58,
            62,52,63,55,60,59,69,75,76,65,
            64,0,38,1,0,2,68,47,4,41,
            1,45,50,51,5,48,49,36,43,42,
            44,30,27,29,26,28,32,34,33,35,
            21,22,23,24,25,31,7,6,0,57,
            0,46,0,8,37,0,10,4,0,40,
            0,53,0,58,62,63,64,65,12,2,
            76,8,9,67,39,0,1,10,4,5,
            11,17,18,8,19,20,37,2,61,66,
            13,39,9,14,70,15,16,71,72,73,
            40,46,53,57,74,54,52,64,65,55,
            59,69,75,76,62,63,58,0,71,0,
            74,9,0,3,1,0,1,3,54,52,
            55,12,0,66,9,0,8,3,0,70,
            61,9,0,47,4,41,1,45,21,22,
            23,24,25,31,50,51,5,48,49,36,
            43,42,30,27,29,26,28,32,34,33,
            35,44,7,6,2,0,67,10,4,5,
            11,17,18,8,19,20,37,2,9,40,
            46,53,57,39,12,1,38,3,56,13,
            14,16,15,0,72,0,73,0,39,3,
            0,76,69,59,54,55,58,62,63,65,
            64,7,6,52,0,30,27,29,26,28,
            32,34,33,35,6,7,21,22,23,24,
            25,31,8,0,58,62,63,30,27,29,
            26,28,32,34,33,35,6,7,21,22,
            23,24,25,31,0,21,22,23,24,25,
            30,27,29,26,28,32,34,33,35,31,
            6,7,3,0,12,59,75,0
        };
    };
    public final static byte asr[] = Asr.asr;
    public final int asr(int index) { return asr[index]; }

    public interface Nasb {
        public final static byte nasb[] = {0,
            88,22,22,22,22,22,21,21,21,22,
            21,21,30,4,21,6,18,20,18,18,
            22,22,22,21,22,22,33,22,25,89,
            22,22,14,22,22,22,22,18,22,18,
            22,22,22,22,22,22,22,22,22,22,
            22,22,80,80,94,22,22,22,22,22,
            22,22,22,22,18,18,18,22,97,18,
            8,21,21,12,22,21,4,21,18,22,
            22,22,91,102,18,18,20,22,21,21,
            1,21,22,38,50,62,62,74,74,22,
            22,22,80,80,68,68,68,68,56,44,
            18,97,22,22,22,25,22,23,22,18,
            22,22,22,22,22,22,22,22,22,22,
            18,22,22,23,22,23,14,22,22,22,
            22,22,22,22,22,22,22,35,18,20,
            22,22,22,22,22,22,22,22,22,18,
            18,21,20,12,21,20,18,18,23,22,
            22,27,99,18,18,22,18,18,22,21,
            18,22,22,16,22,22,22,22,86,22,
            18,22,22,22,22,18,23,22,18,18,
            22,22,22,22,22,14,22,21,22,10,
            22,20,18,22,22,23,22,22,18,35,
            18,21,18,18,20,20,18,22,22,22,
            22,22,22,22,22,14,22,18,18,18,
            22,22,22
        };
    };
    public final static byte nasb[] = Nasb.nasb;
    public final int nasb(int index) { return nasb[index]; }

    public interface Nasr {
        public final static char nasr[] = {0,
            2,106,0,81,0,97,0,88,0,89,
            0,78,0,71,0,65,69,6,16,3,
            2,0,72,0,99,0,2,91,0,2,
            116,0,117,0,2,69,0,6,16,3,
            2,59,0,3,6,16,2,56,0,6,
            16,3,2,53,0,3,6,16,2,50,
            0,6,16,3,2,47,0,3,6,16,
            2,44,0,6,16,3,2,41,0,2,
            6,16,3,34,0,115,0,2,98,0,
            2,109,0,2,110,0,101,100,2,65,
            0,108,2,0
        };
    };
    public final static char nasr[] = Nasr.nasr;
    public final int nasr(int index) { return nasr[index]; }

    public interface TerminalIndex {
        public final static char terminalIndex[] = {0,
            11,12,20,2,3,30,77,7,19,1,
            4,21,17,23,26,27,5,6,8,9,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,75,33,10,25,18,39,
            42,31,32,34,35,40,44,46,47,48,
            49,70,41,64,74,15,43,65,67,13,
            14,66,71,72,73,16,22,28,68,24,
            36,37,38,45,69,76,78,79,80
        };
    };
    public final static char terminalIndex[] = TerminalIndex.terminalIndex;
    public final int terminalIndex(int index) { return terminalIndex[index]; }

    public interface NonterminalIndex {
        public final static char nonterminalIndex[] = {0,
            83,84,82,0,86,88,0,0,0,0,
            0,0,0,0,0,98,0,0,0,0,
            0,0,0,0,0,100,0,0,0,0,
            103,0,0,128,129,0,0,0,124,125,
            126,121,122,123,118,119,120,115,116,117,
            112,113,114,109,110,111,106,107,108,91,
            101,104,0,105,90,0,0,85,92,102,
            135,0,87,0,0,0,0,132,95,127,
            140,0,0,0,94,97,0,133,134,137,
            93,0,96,0,0,136,138,139,142,143,
            144,0,147,0,0,81,0,89,99,130,
            131,0,0,0,141,145,146,0,0,0
        };
    };
    public final static char nonterminalIndex[] = NonterminalIndex.nonterminalIndex;
    public final int nonterminalIndex(int index) { return nonterminalIndex[index]; }

    public interface ScopePrefix {
        public final static char scopePrefix[] = {
            195,231,241,129,163,171,217,251,205,15,
            28,149,156,1,9,138,189,123,179,225,
            144,37,259,265,269,273,277,116,55,22,
            46,58,58,66,66,74,74,74,74,88,
            88,96,101,106,111
        };
    };
    public final static char scopePrefix[] = ScopePrefix.scopePrefix;
    public final int scopePrefix(int index) { return scopePrefix[index]; }

    public interface ScopeSuffix {
        public final static char scopeSuffix[] = {
            7,7,7,7,7,7,7,7,213,7,
            35,7,7,7,7,7,7,120,185,213,
            7,42,263,263,263,7,7,120,7,25,
            49,60,63,68,71,76,79,82,85,90,
            93,98,103,108,113
        };
    };
    public final static char scopeSuffix[] = ScopeSuffix.scopeSuffix;
    public final int scopeSuffix(int index) { return scopeSuffix[index]; }

    public interface ScopeLhs {
        public final static char scopeLhs[] = {
            25,24,24,27,27,27,25,24,25,27,
            37,27,27,38,38,27,27,30,27,25,
            27,37,11,10,10,7,6,30,35,36,
            37,41,41,44,44,47,47,47,47,50,
            50,53,56,59,63
        };
    };
    public final static char scopeLhs[] = ScopeLhs.scopeLhs;
    public final int scopeLhs(int index) { return scopeLhs[index]; }

    public interface ScopeLa {
        public final static byte scopeLa[] = {
            2,2,2,2,2,2,2,2,39,2,
            73,2,2,2,2,2,2,66,9,39,
            2,72,61,61,61,2,2,66,2,74,
            71,11,5,4,10,20,19,18,17,37,
            8,40,46,53,57
        };
    };
    public final static byte scopeLa[] = ScopeLa.scopeLa;
    public final int scopeLa(int index) { return scopeLa[index]; }

    public interface ScopeStateSet {
        public final static byte scopeStateSet[] = {
            9,9,9,9,9,9,9,9,9,9,
            9,9,9,9,9,9,9,9,9,9,
            9,9,9,9,9,1,1,9,9,9,
            9,13,13,15,15,19,19,19,19,21,
            21,22,23,24,25
        };
    };
    public final static byte scopeStateSet[] = ScopeStateSet.scopeStateSet;
    public final int scopeStateSet(int index) { return scopeStateSet[index]; }

    public interface ScopeRhs {
        public final static char scopeRhs[] = {0,
            174,1,80,15,105,0,2,0,174,1,
            80,16,105,0,155,1,150,80,13,105,
            0,189,47,0,74,139,0,139,72,139,
            71,139,45,0,73,0,139,71,139,45,
            0,72,139,73,0,139,45,0,71,139,
            72,139,73,0,139,1,0,119,0,11,
            113,0,5,113,0,122,0,4,120,0,
            10,120,0,125,0,20,123,0,19,123,
            0,18,123,0,17,123,0,128,0,37,
            126,0,8,126,0,131,0,40,129,0,
            134,0,46,132,0,137,0,53,135,0,
            143,0,57,138,0,149,56,80,0,66,
            151,0,149,56,80,14,105,0,155,1,
            151,147,12,84,14,105,0,155,1,147,
            12,84,0,155,1,151,80,0,155,1,
            151,80,14,105,0,155,1,151,185,14,
            105,0,149,9,80,1,80,13,105,0,
            149,9,140,1,80,13,105,0,140,1,
            80,13,105,0,9,149,2,0,139,1,
            80,13,105,0,139,39,148,67,164,1,
            80,13,105,0,148,67,164,1,80,13,
            105,0,39,139,2,0,139,39,148,1,
            80,13,105,0,148,1,80,13,105,0,
            139,39,164,9,144,1,80,13,105,0,
            139,39,164,9,80,1,80,13,105,0,
            139,39,164,1,80,13,105,0,188,60,
            31,0,61,0,171,60,85,0,171,60,
            82,0,186,1,31,0,152,1,82,0
        };
    };
    public final static char scopeRhs[] = ScopeRhs.scopeRhs;
    public final int scopeRhs(int index) { return scopeRhs[index]; }

    public interface ScopeState {
        public final static char scopeState[] = {0,
            3951,3932,4183,4157,4109,4101,4093,4080,3883,3844,
            3763,3724,3682,3640,3595,3550,3505,3460,3412,3364,
            3313,3259,3202,3142,3077,3012,2947,1331,578,1641,
            2882,2817,1550,1254,1177,1100,2752,492,1479,761,
            664,1012,2687,2622,935,2557,2492,2427,2362,858,
            2297,398,304,1408,2232,2167,2102,2037,1972,1907,
            1842,1777,1712,0
        };
    };
    public final static char scopeState[] = ScopeState.scopeState;
    public final int scopeState(int index) { return scopeState[index]; }

    public interface InSymb {
        public final static char inSymb[] = {0,
            0,183,81,80,64,65,63,62,58,55,
            52,54,59,177,69,190,8,3,3,3,
            156,156,156,52,156,156,195,80,84,84,
            114,84,80,95,31,85,82,45,105,1,
            118,124,121,130,127,110,136,133,143,134,
            128,122,41,4,47,119,125,131,137,141,
            152,31,82,84,3,3,3,156,3,3,
            196,3,12,178,193,12,177,12,56,151,
            150,38,60,1,60,60,1,139,15,16,
            14,13,139,57,46,37,8,4,10,110,
            189,80,11,5,20,19,18,17,40,53,
            8,3,180,144,80,84,147,147,149,1,
            188,80,186,80,187,171,139,172,171,152,
            71,80,80,185,84,80,80,110,137,110,
            131,110,125,125,110,119,119,9,74,3,
            110,122,122,122,122,110,128,110,134,8,
            8,1,3,178,1,3,1,9,66,155,
            149,9,9,70,9,139,1,1,151,12,
            56,151,150,1,152,181,182,181,152,155,
            72,174,68,175,174,1,147,149,1,1,
            139,148,164,144,140,80,2,9,2,194,
            139,3,9,155,151,66,155,155,39,67,
            39,9,9,9,3,3,1,139,148,139,
            164,80,149,164,149,80,155,39,39,39,
            139,139,139
        };
    };
    public final static char inSymb[] = InSymb.inSymb;
    public final int inSymb(int index) { return inSymb[index]; }

    public interface Name {
        public final static String name[] = {
            "",
            "+",
            "-",
            "*",
            "/",
            ">",
            "<",
            "=",
            ">=",
            "<=",
            "<>",
            "(",
            ")",
            "{",
            "}",
            "[",
            "]",
            "->",
            "|",
            ",",
            ":",
            "::",
            ";",
            ".",
            "..",
            "@",
            "^",
            "^^",
            "?",
            "$empty",
            "QUOTED_IDENTIFIER",
            "INTEGER_LITERAL",
            "REAL_LITERAL",
            "STRING_LITERAL",
            "self",
            "if",
            "then",
            "else",
            "endif",
            "and",
            "or",
            "xor",
            "not",
            "implies",
            "let",
            "in",
            "true",
            "false",
            "null",
            "invalid",
            "Set",
            "Bag",
            "Sequence",
            "Collection",
            "OrderedSet",
            "String",
            "Integer",
            "UnlimitedNatural",
            "Real",
            "Boolean",
            "Tuple",
            "OclAny",
            "OclVoid",
            "OclInvalid",
            "inv",
            "pre",
            "post",
            "context",
            "package",
            "endpackage",
            "def",
            "body",
            "derive",
            "init",
            "static",
            "OclMessage",
            "EOF_TOKEN",
            "IDENTIFIER",
            "SINGLE_LINE_COMMENT",
            "MULTI_LINE_COMMENT",
            "ERROR_TOKEN",
            "conceptualOperationNameCS",
            "CollectionTypeIdentifierCS",
            "simpleNameCS",
            "QuotedSimpleNameCS",
            "unreservedSimpleNameCS",
            "pathNameCS",
            "typeCS",
            "collectionTypeCS",
            "tupleTypePartsCS",
            "typedUninitializedVariableCS",
            "OclExpressionCS",
            "typedInitializedVariableCS",
            "initializedVariableCS",
            "uninitializedVariableCS",
            "VariableDeclarationCS",
            "CollectionLiteralPartsCS",
            "CollectionLiteralPartCS",
            "StringLiteralExpCS",
            "TupleLiteralPartsCS",
            "primaryExpCS",
            "notNameExpressionCS",
            "argumentsCS",
            "SimpleNameExpCS",
            "impliesNotNameNotLetCS",
            "impliesNotLetCS",
            "xorNotNameNotLetCS",
            "xorNotLetCS",
            "xorWithLetCS",
            "orNotNameNotLetCS",
            "orNotLetCS",
            "orWithLetCS",
            "andNotNameNotLetCS",
            "andNotLetCS",
            "andWithLetCS",
            "equalityNotNameNotLetCS",
            "equalityNotLetCS",
            "equalityWithLetCS",
            "relationalNotNameNotLetCS",
            "relationalNotLetCS",
            "relationalWithLetCS",
            "additiveNotNameNotLetCS",
            "additiveNotLetCS",
            "additiveWithLetCS",
            "multiplicativeNotNameNotLetCS",
            "multiplicativeNotLetCS",
            "multiplicativeWithLetCS",
            "unaryNotLetCS",
            "unaryWithLetCS",
            "primaryNotNameCS",
            "letVariablesCS",
            "packageDeclarationsCS",
            "invOrDefCS",
            "prePostOrBodyDeclCS",
            "initOrDerValueCS",
            "isMarkedPreCS",
            "OclMessageArgumentsCS",
            "OclMessageArgCS",
            "packageDeclarationCS_A",
            "contextDeclsCS",
            "contextDeclCS",
            "initOrDerValuesCS",
            "invOrDefsCS",
            "defExpressionCS",
            "operationCS1",
            "operationCS2",
            "prePostOrBodyDeclsCS",
            "parametersCS"
        };
    };
    public final static String name[] = Name.name;
    public final String name(int index) { return name[index]; }

    public final int originalState(int state) {
        return -baseCheck[state];
    }
    public final int asi(int state) {
        return asb[originalState(state)];
    }
    public final int nasi(int state) {
        return nasb[originalState(state)];
    }
    public final int inSymbol(int state) {
        return inSymb[originalState(state)];
    }

    /**
     * assert(! goto_default);
     */
    public final int ntAction(int state, int sym) {
        return baseAction[state + sym];
    }

    /**
     * assert(! shift_default);
     */
    public final int tAction(int state, int sym) {
        int i = baseAction[state],
            k = i + sym;
        return termAction[termCheck[k] == sym ? k : i];
    }
    public final int lookAhead(int la_state, int sym) {
        int k = la_state + sym;
        return termAction[termCheck[k] == sym ? k : la_state];
    }
}
